/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeBreakpoint;
import oracle.jdevimpl.debugger.probe.DebugProbeLocation;
import oracle.jdevimpl.debugger.probe.DebugProbeRuntimeInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeThreadInfo;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugLocation;

final class DebugProbeBreakpointPackageFileLine
extends DebugProbeBreakpoint
implements DebugBreakpointPackageFileLine {
    String pkg;
    String filename;
    int line;
    int bn;
    DebugProbeLocation location;

    DebugProbeBreakpointPackageFileLine(DebugProbe debugProbe, String string, String string2, int n) {
        super(debugProbe);
        this.pkg = string;
        this.filename = string2;
        this.line = n;
        this.bn = -1;
    }

    public String getPackage() {
        return this.pkg;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public void setPackageFileLine(String string, String string2, int n) {
        this.prepareForChange();
        this.pkg = string;
        this.filename = string2;
        this.line = n;
        if (this.dp != null) {
            this.dp.putBreakpoint(this);
        }
    }

    public void setFileLine(String string, int n) {
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.getEnabled() != bl) {
            super.setEnabled(bl);
            if (this.bn != -1) {
                if (bl) {
                    this.dp.callEnableBreakpoint(this.bn);
                } else {
                    this.dp.callDisableBreakpoint(this.bn);
                }
            }
        }
    }

    @Override
    public DebugLocation[] getLocations() {
        if (this.bn != -1 && this.location != null) {
            DebugLocation[] debugLocationArray = new DebugLocation[]{this.location};
            return debugLocationArray;
        }
        return super.getLocations();
    }

    @Override
    void prepareForChange() {
        super.prepareForChange();
        if (this.bn != -1) {
            this.dp.callDeleteBreakpoint(this.bn);
            this.bn = -1;
            this.location = null;
        }
    }

    void verified(int n, DebugProbeLocation debugProbeLocation) {
        this.bn = n;
        this.location = debugProbeLocation;
    }

    @Override
    boolean isThisYourEvent(DebugProbeRuntimeInfo debugProbeRuntimeInfo, DebugProbeThreadInfo debugProbeThreadInfo) {
        if (debugProbeRuntimeInfo.reason == 3 && debugProbeRuntimeInfo.breakpoint == this.bn) {
            return super.isThisYourEvent(debugProbeRuntimeInfo, debugProbeThreadInfo);
        }
        return false;
    }
}

