/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.actions.DDLBasedActionsHelper;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSyntaxParser;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;

public abstract class DDLBasedBaseMeasureActionsHelper
extends DDLBasedActionsHelper {
    private final Logger LOG = Logger.getLogger(DDLBasedBaseMeasureActionsHelper.class.getName());
    private AnalyticView origAv;
    private AnalyticView updatedAv;
    private List<String> changedMeasures;
    private HCSSchema schema;
    private HCSSyntaxParser parser;
    private boolean defaultMeasureChanged;

    public DDLBasedBaseMeasureActionsHelper(Database database, HCSSchema hCSSchema) {
        super(database);
        this.schema = hCSSchema;
        this.changedMeasures = new ArrayList<String>();
    }

    protected void setDefaultMeasureChanged(boolean bl) {
        this.defaultMeasureChanged = bl;
    }

    protected boolean isDefaultMeasureChanged() {
        return this.defaultMeasureChanged;
    }

    protected void initParser(String string) {
        Properties properties = new Properties();
        properties.setProperty("SCHEMA", this.schema.getName());
        properties.setProperty("CUBE", string);
        this.parser = new HCSSyntaxParser(this.schema, properties);
    }

    protected HCSSchema getSchema() {
        return this.schema;
    }

    protected HCSSyntaxParser getParser() {
        return this.parser;
    }

    protected void setUpdatedAv(AnalyticView analyticView) {
        this.updatedAv = analyticView;
    }

    protected void setOriginalAv(AnalyticView analyticView) {
        this.origAv = analyticView;
    }

    protected AnalyticView getUpdatedAv() {
        return this.updatedAv;
    }

    protected AnalyticView getOrigAv() {
        return this.origAv;
    }

    @Override
    protected SystemObject getOriginalObject() {
        return this.origAv;
    }

    @Override
    protected SystemObject getUpdatedObject() {
        return this.updatedAv;
    }

    protected void addChangedMeasure(String string) {
        this.changedMeasures.add(string);
    }

    protected List<String> getChangedMeasures() {
        return this.changedMeasures;
    }

    protected void setChangedMeasures(List<String> list) {
        this.changedMeasures = list;
    }

    @Override
    protected void recordMetadataChanges() {
        Connection connection = this.getDatabase().getConnection();
        String string = Connections.getInstance().getConnectionName(connection);
        String string2 = this.getOrigAv().getSchema().getName();
        LinkedList<MetadataChange> linkedList = new LinkedList<MetadataChange>();
        for (String string3 : this.getChangedMeasures()) {
            linkedList.add(new MetadataChange(this.getOrigAv().getName(), string3, HCSSyntaxType.MEASURE));
        }
        if (this.isDefaultMeasureChanged()) {
            linkedList.add(new MetadataChange(this.getOrigAv().getName(), this.getOrigAv().getName(), HCSSyntaxType.ANALYTIC_VIEW));
        }
    }
}

