/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.AbstractModifyHCSObjectAction;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.actions.ConfirmRenamePanel;
import oracle.hcs.actions.RenameHelper;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.HCSCompileDDLGenerator;
import oracle.hcs.db.panels.HCSObjectDependenciesGenerator;
import oracle.hcs.db.panels.InvalidDependenciesDialog;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.Ide;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class RenameHCSObjectAction
extends AbstractModifyHCSObjectAction {
    private static final Logger LOG = Logger.getLogger(RenameHCSObjectAction.class.getName());
    private static final String HELP_ID = "av_rename_object";
    private ConfirmRenamePanel confirmRenamePanel;
    private List<AbstractSchemaObjectWithDesc> dependencies;
    private HCSCompileDDLGenerator compileStatementsHelper;

    @Override
    protected AlterHCSObjectHelper getHelper() throws Exception {
        DBObject dBObject = this.getDBObject();
        this.compileStatementsHelper = new HCSCompileDDLGenerator();
        this.dependencies = this.getDependenciesByType(dBObject.getObjectType(), dBObject.getSchemaName(), (OracleDatabaseImpl)dBObject.getDatabase(), dBObject.getObjectName());
        RenameHelper renameHelper = new RenameHelper(dBObject, (ConfirmRenamePanel)this.getConfirmationPanel(), this.compileStatementsHelper, this.dependencies);
        return renameHelper;
    }

    @Override
    protected String getParentObjectName() {
        return this.getObjectName();
    }

    @Override
    protected String getParentObjectType() {
        return this.getType();
    }

    @Override
    protected String getObjectName() {
        String string = this.getDBObject().getObjectName();
        return string;
    }

    @Override
    public String getType() {
        String string = this.getDBObject().getObjectType();
        return string;
    }

    @Override
    protected String getTitle(String string) {
        String string2 = HCSArb.getString("RENAME_ACTION_RAPTOR_TASK_TITLE");
        return string2;
    }

    @Override
    protected String getProgressMessage() {
        String string = HCSArb.getString("RENAME_ACTION_RAPTOR_TASK_RUNNING_MSG");
        return string;
    }

    @Override
    protected ActionConfirmPanel getConfirmationPanel() {
        String string = this.getDBObject().getSchemaName();
        Database database = this.getDBObject().getDatabase();
        String string2 = this.getObjectName();
        if (this.confirmRenamePanel == null) {
            this.confirmRenamePanel = new ConfirmRenamePanel(string, string2);
        }
        return this.confirmRenamePanel;
    }

    @Override
    protected String getHelpID() {
        return HELP_ID;
    }

    @Override
    protected void actionPostProcess() {
        DBObject dBObject = this.getDBObject();
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        arrayList.add(dBObject);
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectName();
        Database database = dBObject.getDatabase();
        String string3 = database.getExternalName(string2);
        String string4 = UIStringUtils.normalizeName(this.confirmRenamePanel.getNewName(), (DBObjectProvider)database);
        String string5 = this.getType();
        String string6 = null;
        if (string5.equals("ATTRIBUTE DIMENSION")) {
            string6 = HCSArb.format("RENAME_ATTRIBUTE_DIMENSION_SUCCESS_MSG", string, string3, string4);
        } else if (string5.equals("HIERARCHY")) {
            string6 = HCSArb.format("RENAME_HIERARCHY_SUCCESS_MSG", string, string3, string4);
        } else if (string5.equals("ANALYTIC VIEW")) {
            string6 = HCSArb.format("RENAME_AV_SUCCESS_MSG", string, string3, string4);
        }
        if (!this.dependencies.isEmpty()) {
            int n = this.compileStatementsHelper.getCompileErrorsCount(dBObject.getConnection(), this.dependencies);
            if (n > 0) {
                InvalidDependenciesDialog invalidDependenciesDialog = new InvalidDependenciesDialog(this.dependencies, this.compileStatementsHelper, (DBObjectProvider)dBObject.getDatabase(), string4);
                invalidDependenciesDialog.display();
            }
            this.refreshObjectsInNavigator(string5, dBObject);
        } else {
            this.showSuccessDialog(string6, string, string3);
            this.refreshParentObject(dBObject);
        }
        this.recordMetadataChanges();
    }

    private void showSuccessDialog(String string, String string2, String string3) {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, HCSArb.format("RENAME_DIALOG_TITLE", string2 + "." + string3), 1);
    }

    private List<AbstractSchemaObjectWithDesc> getDependenciesByType(String string, String string2, OracleDatabaseImpl oracleDatabaseImpl, String string3) {
        if (string.equals("ATTRIBUTE DIMENSION")) {
            return HCSObjectDependenciesGenerator.getDimensionDependencies(string2, oracleDatabaseImpl, string3);
        }
        if (string.equals("HIERARCHY")) {
            return HCSObjectDependenciesGenerator.getHierarchyDependencies(string2, oracleDatabaseImpl, string3);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected LinkedList<MetadataChange> getChanges(String string, HCSSyntaxType hCSSyntaxType) {
        DBObject dBObject = this.getDBObject();
        LinkedList<MetadataChange> linkedList = new LinkedList<MetadataChange>();
        Database database = dBObject.getDatabase();
        String string2 = UIStringUtils.normalizeName(this.confirmRenamePanel.getNewName(), (DBObjectProvider)database);
        linkedList.add(new MetadataChange(string, string2, hCSSyntaxType, "RENAME"));
        return linkedList;
    }
}

