/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ConfirmDropMeasurePanel;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.panels.AVAggregationPanel;
import oracle.hcs.av.panels.AVDescriptionPanel;
import oracle.hcs.av.panels.AVGeneralPanel;
import oracle.hcs.av.panels.AVHierarchiesPanel;
import oracle.hcs.av.panels.AVMeasureAggregationPanel;
import oracle.hcs.av.panels.AVMeasureTableEditorPanel;
import oracle.hcs.av.panels.cache.AVMainCachePanel;
import oracle.hcs.db.BasePanelLibrary;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.HCSPanel;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.Ide;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.dialogs.MessageDialog;

public class AVPanelLibrary
extends BasePanelLibrary {
    private static final String GENERAL = HCSArb.get("GENERAL.TITLE");
    private static final String MEASURES = HCSArb.get("MEASURES.TITLE");
    private static final String HIERARCHIES = HCSArb.get("HIERARCHIES_TITLE");
    private static final String MEASURES_AGGREGATION_RULES = HCSArb.get("MEASURE.AGGREGATION.RULES.TITLE");
    private static final String AGGREGATION_RULES = HCSArb.get("AGGREGATION_RULES_TITLE");
    private static final String DESCRIPTION = HCSArb.get("DESCRIPTIONS.TITLE");
    private static final String CACHE_MEASURE_GROUPS = HCSArb.get("CACHE_MEASURE_GROUPS_TITLE");
    private Namespace namespace;
    private List<AVBaseMeasure> calculatedMeasuresToBeDropped;
    private Map<String, Stack<String>> renamedMeasures;
    private String schemaName;

    public AVPanelLibrary() {
        super("ANALYTIC VIEW");
        this.addPanel(GENERAL, AVGeneralPanel.class, "av_create_av_general", new String[0]);
        Navigable navigable = this.addPanel(MEASURES, AVMeasureTableEditorPanel.class, "av_create_av_measures", new String[0]);
        navigable.addChildNavigable(this.addPanel(MEASURES_AGGREGATION_RULES, AVMeasureAggregationPanel.class, "av_create_av_meas_agg_rules", new String[0]));
        navigable = this.addPanel(HIERARCHIES, AVHierarchiesPanel.class, "av_create_av_hierarchies", new String[0]);
        navigable = this.addPanel(AGGREGATION_RULES, AVAggregationPanel.class, "av_create_av_agg_rules", new String[0]);
        navigable = this.addPanel(DESCRIPTION, AVDescriptionPanel.class, "av_descriptions", new String[0]);
        navigable = this.addPanel(CACHE_MEASURE_GROUPS, AVMainCachePanel.class, "av_cache_meas_groups", new String[0]);
        this.renamedMeasures = new HashMap<String, Stack<String>>();
    }

    protected List<String> getTitles(DBObject dBObject, DBObjectProvider dBObjectProvider, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(GENERAL);
        arrayList.add(HIERARCHIES);
        arrayList.add(AGGREGATION_RULES);
        arrayList.add(MEASURES);
        arrayList.add(DESCRIPTION);
        arrayList.add(CACHE_MEASURE_GROUPS);
        return arrayList;
    }

    protected List<String> getSimpleTitles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(GENERAL);
        arrayList.add(HIERARCHIES);
        arrayList.add(AGGREGATION_RULES);
        arrayList.add(MEASURES);
        arrayList.add(DESCRIPTION);
        arrayList.add(CACHE_MEASURE_GROUPS);
        return arrayList;
    }

    public String getCreateTitle() {
        return HCSArb.get("AV.CREATE.TITLE");
    }

    public String getEditTitle() {
        return HCSArb.get("AV.EDIT.TITLE");
    }

    public boolean canEditObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        return true;
    }

    public Class<? extends Traversable> getHeader() {
        return HCSPanel.class;
    }

    public Dimension getSize(boolean bl) {
        Dimension dimension = new Dimension(800, 600);
        return dimension;
    }

    public Navigable getDDLNavigable() {
        Navigable navigable = super.getDDLNavigable();
        navigable.setHelpID("av_create_av_ddl");
        return navigable;
    }

    public void initReconcileDependencies() {
        this.renamedMeasures = new HashMap<String, Stack<String>>();
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object = this.getNamespace().get("dimensions");
        List list = (List)object;
        hashMap.put("dimensions", list);
        return hashMap;
    }

    @Override
    protected Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean shouldValidateOnExit(BaseEditorPanel baseEditorPanel, Namespace namespace) {
        this.namespace = namespace;
        return super.shouldValidateOnExit(baseEditorPanel, namespace);
    }

    @Override
    protected HCSSyntaxType getObjectType() {
        return HCSSyntaxType.ANALYTIC_VIEW;
    }

    @Override
    protected void addMetadataChanges(SystemObject systemObject, Difference difference, List<MetadataChange> list) {
        this.addMetadataChangesForDimensionalities(systemObject, difference, list);
        this.addMetadataChanges(systemObject, "consistentSolveSpec", difference, list, HCSSyntaxType.ANALYTIC_VIEW);
        this.addMetadataChanges(systemObject, "measures", difference, list, HCSSyntaxType.MEASURE);
        this.addMetadataChanges(systemObject, "calculatedMeasures", difference, list, HCSSyntaxType.MEASURE);
        this.addMetadataChangesForCacheMeasureGroups(systemObject, difference, list);
    }

    private void addMetadataChangesForDimensionalities(SystemObject systemObject, Difference difference, List<MetadataChange> list) {
        for (MetadataChange object : list) {
            if (!object.getObjectType().equals((Object)HCSSyntaxType.ANALYTIC_VIEW)) continue;
            return;
        }
        Difference difference2 = difference.getChildDifference("dimensions", false);
        for (Difference difference3 : difference2.getChildren()) {
            if (difference3.isSame()) continue;
            list.add(new MetadataChange(systemObject.getName(), systemObject.getName(), HCSSyntaxType.ANALYTIC_VIEW));
            break;
        }
    }

    private void addMetadataChangesForCacheMeasureGroups(SystemObject systemObject, Difference difference, List<MetadataChange> list) {
        for (MetadataChange object : list) {
            if (!object.getObjectType().equals((Object)HCSSyntaxType.ANALYTIC_VIEW)) continue;
            return;
        }
        Difference difference2 = difference.getChildDifference("cacheMeasureGroups", false);
        for (Difference difference3 : difference2.getChildren()) {
            if (difference3.isSame()) continue;
            list.add(new MetadataChange(systemObject.getName(), systemObject.getName(), HCSSyntaxType.ANALYTIC_VIEW));
            break;
        }
    }

    @Override
    protected boolean containsChanges(List<MetadataChange> list, HCSSyntaxType hCSSyntaxType) {
        boolean bl = false;
        for (MetadataChange metadataChange : list) {
            if (!metadataChange.getObjectType().equals((Object)hCSSyntaxType) || hCSSyntaxType.equals((Object)HCSSyntaxType.MEASURE)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void commitToProvider(DBEditorConfig dBEditorConfig) {
        AnalyticView analyticView = (AnalyticView)dBEditorConfig.getUpdatedObject();
        boolean bl = analyticView.isForceCreate();
        if (this.calculatedMeasuresToBeDropped != null && this.calculatedMeasuresToBeDropped.size() > 0) {
            ConfirmDropMeasurePanel confirmDropMeasurePanel = new ConfirmDropMeasurePanel(this.calculatedMeasuresToBeDropped, this.schemaName);
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), confirmDropMeasurePanel, this.getEditTitle(), 0);
            if (n != 0) {
                dBEditorConfig.setResult(DBEditorConfig.Result.CANCELLED);
                return;
            }
        }
        if (!bl && !this.isSourceValid(dBEditorConfig)) {
            this.showErrorMessage(HCSArb.format("VALIDATION_ERROR_INVALID_SOURCE_TABLE", this.getType()), HCSArb.getString("VALIDATION_ERROR_AV_INVALID_SOURCE_TABLE"));
            return;
        }
        if (analyticView.getMeasures().length == 0) {
            this.showErrorMessage(HCSArb.format("VALIDATION_ERROR_INVALID_SOURCE_TABLE", this.getType()), HCSArb.get("AV_VALIDATE_MEASURES_ERROR"));
            return;
        }
        super.commitToProvider(dBEditorConfig);
    }

    @Override
    protected String getSourceQualifiedName(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
        String string = null;
        AnalyticView analyticView = (AnalyticView)abstractSchemaObjectWithDesc;
        String string2 = abstractSchemaObjectWithDesc.getSchema().getName();
        String string3 = analyticView.getavSourceTableOwner();
        string = string3.equals(string2) ? analyticView.getavSourceTable() : string3 + "." + analyticView.getavSourceTable();
        return string;
    }

    @Override
    protected void addParentObjectChanges(SystemObject systemObject, SystemObject systemObject2, List<MetadataChange> list) {
        String string = null;
        String string2 = null;
        AnalyticView analyticView = (AnalyticView)systemObject;
        string = analyticView.getDefaultMeasure();
        AnalyticView analyticView2 = (AnalyticView)systemObject2;
        string2 = analyticView2.getDefaultMeasure();
        if (!systemObject.getName().equalsIgnoreCase(systemObject2.getName())) {
            list.add(new MetadataChange(analyticView.getName(), systemObject2.getName(), this.getObjectType(), "RENAME"));
        } else if (!string.equals(string2)) {
            list.add(new MetadataChange(systemObject2.getName(), systemObject2.getName(), this.getObjectType()));
        }
    }

    @Override
    public void reconcileDependencies(Database database, SystemObject systemObject, SystemObject systemObject2) {
        AnalyticView analyticView = (AnalyticView)systemObject;
        this.schemaName = analyticView.getSchema().getName();
        AnalyticView analyticView2 = (AnalyticView)systemObject2;
        boolean bl = analyticView2.isForceCreate();
        this.calculatedMeasuresToBeDropped = new ArrayList<AVBaseMeasure>();
        analyticView2.removeAllCalculatedMeasures();
        this.reloadCalcsFromOrigAV(analyticView, analyticView2);
        this.reconcileCalcExpressionsWithDimsAndHiers(database, analyticView, analyticView2);
        this.reconcileCalcExpressionsWithMeasures(database, analyticView, analyticView2);
    }

    private void reloadCalcsFromOrigAV(AnalyticView analyticView, AnalyticView analyticView2) {
        AVCalculatedMeasure[] aVCalculatedMeasureArray = analyticView.getCalculatedMeasures();
        ArrayList<AVCalculatedMeasure> arrayList = new ArrayList<AVCalculatedMeasure>();
        for (AVCalculatedMeasure aVCalculatedMeasure : aVCalculatedMeasureArray) {
            arrayList.add(aVCalculatedMeasure);
        }
        AVCalculatedMeasure[] aVCalculatedMeasureArray2 = arrayList.toArray(new AVCalculatedMeasure[arrayList.size()]);
        analyticView2.setCalculatedMeasures(aVCalculatedMeasureArray2);
    }

    private void reconcileCalcExpressionsWithDimsAndHiers(Database database, AnalyticView analyticView, AnalyticView analyticView2) {
        Database database2 = database;
        AnalyticView analyticView3 = analyticView;
        AnalyticView analyticView4 = analyticView2;
        if (analyticView != null) {
            Difference difference = database2.getDiffEngine().difference((Object)analyticView3, (Object)analyticView4);
            Difference difference2 = difference.getChildDifference("dimensions", false);
            for (Difference difference3 : difference2.getChildren()) {
                Difference difference4;
                String string;
                Object object;
                if (difference3.isSame()) continue;
                AVDimensionality aVDimensionality = (AVDimensionality)difference3.getOriginalObject();
                AVDimensionality aVDimensionality2 = (AVDimensionality)difference3.getUpdatedObject();
                if (difference3.isLeaf()) {
                    if (aVDimensionality == null || (object = analyticView2.findDimensionalityForAlias(string = aVDimensionality.getDimensionAlias())) != null) continue;
                    for (Object object2 : difference4 = aVDimensionality.getHierarchies()) {
                        String string2 = ((AVHierarchy)object2).getHierarchyAlias();
                        this.dropCalculatedMeasuresByHierarchy((DBObjectProvider)database2, analyticView2, string, string2);
                    }
                    continue;
                }
                string = null;
                object = null;
                difference4 = null;
                boolean bl = true;
                int n = 1;
                for (Object object2 : difference3.getChildren()) {
                    if (!object2.isSame()) {
                        if (object2.isLeaf() && object2.getPropertyName().equalsIgnoreCase("dimensionAlias")) {
                            n = 0;
                        }
                        if (object2.getPropertyName().equalsIgnoreCase("hierarchies")) {
                            bl = false;
                        }
                    }
                    if (object2.isLeaf() && object2.getPropertyName().equalsIgnoreCase("dimensionAlias")) {
                        string = String.valueOf(object2.getOriginalObject());
                        object = String.valueOf(object2.getUpdatedObject());
                    }
                    if (!object2.getPropertyName().equalsIgnoreCase("hierarchies")) continue;
                    difference4 = difference3.getChildDifference("hierarchies", false);
                }
                if (n != 0 && bl) continue;
                this.reconcileCalcExpressions((DBObjectProvider)database2, analyticView2, aVDimensionality2, string, (String)object, difference4);
            }
        }
    }

    private void reconcileCalcExpressions(DBObjectProvider dBObjectProvider, AnalyticView analyticView, AVDimensionality aVDimensionality, String string, String string2, Difference difference) {
        try {
            boolean bl = string.equals(string2);
            for (Difference difference2 : difference.getChildren()) {
                Object object;
                Iterator iterator;
                Object object2;
                Object object32;
                Object object4;
                Object object52;
                int n;
                Object object6;
                AVHierarchy[] aVHierarchyArray;
                Object object7;
                if (!difference2.isSame()) {
                    Object object8;
                    if (difference2.isLeaf()) {
                        object7 = (AVHierarchy[])difference2.getOriginalObject();
                        if (object7 == null || (aVHierarchyArray = aVDimensionality.findHierarchyByAlias((String)(object6 = object7.getHierarchyAlias()))) != null) continue;
                        this.dropCalculatedMeasuresByHierarchy(dBObjectProvider, analyticView, string, (String)object6);
                        continue;
                    }
                    object7 = null;
                    object6 = null;
                    boolean bl2 = true;
                    n = 0;
                    for (Object object52 : difference2.getChildren()) {
                        if (!object52.isSame()) {
                            if (object52.isLeaf() && object52.getPropertyName().equalsIgnoreCase("hierarchyAlias")) {
                                bl2 = false;
                            }
                            if (object52.getPropertyName().equalsIgnoreCase("properties")) {
                                object4 = difference2.getChildDifference("properties", false);
                                for (Object object32 : object4.getChildren()) {
                                    if (object32.isSame() || !object32.isLeaf() || !object32.getPropertyName().equalsIgnoreCase("hierarchyIncludedInAV") || !((String)(object2 = String.valueOf(object32.getUpdatedObject()))).equalsIgnoreCase("false")) continue;
                                    n = 1;
                                }
                            }
                        }
                        if (!object52.isLeaf() || !object52.getPropertyName().equalsIgnoreCase("hierarchyAlias")) continue;
                        object7 = String.valueOf(object52.getOriginalObject());
                        object6 = String.valueOf(object52.getUpdatedObject());
                    }
                    if (n == 0) {
                        if (bl2 && bl) continue;
                        string = dBObjectProvider.getExternalName(string);
                        object7 = dBObjectProvider.getExternalName((String)object7);
                        string2 = dBObjectProvider.getExternalName(string2);
                        object6 = dBObjectProvider.getExternalName((String)object6);
                        object8 = String.format("%s.%s", string, object7);
                        if (((String)object8).equals(object52 = String.format("%s.%s", string2, object6))) continue;
                        object4 = analyticView.getCalculatedMeasuresList();
                        iterator = object4.iterator();
                        while (iterator.hasNext()) {
                            object32 = (AVBaseMeasure)iterator.next();
                            object2 = (AVCalculatedMeasure)object32;
                            object = ((AVCalculatedMeasure)object2).getExpression();
                            object = ((String)object).replaceAll("\\b" + (String)object8 + "\\b", (String)object52);
                            ((AVCalculatedMeasure)object2).setMeasureExpression((String)object);
                        }
                        continue;
                    }
                    object8 = aVDimensionality.findHierarchyByAlias((String)object7);
                    if (object8 != null) continue;
                    this.dropCalculatedMeasuresByHierarchy(dBObjectProvider, analyticView, string, (String)object7);
                    continue;
                }
                if (bl) continue;
                string = dBObjectProvider.getExternalName(string);
                string2 = dBObjectProvider.getExternalName(string2);
                object7 = aVDimensionality.getHierarchies();
                object6 = analyticView.getCalculatedMeasuresList();
                aVHierarchyArray = object7;
                n = aVHierarchyArray.length;
                for (int i = 0; i < n; ++i) {
                    object52 = aVHierarchyArray[i];
                    object4 = ((AVHierarchy)object52).getHierarchyAlias();
                    object4 = dBObjectProvider.getExternalName((String)object4);
                    iterator = String.format("%s.%s", string, object4);
                    object32 = String.format("%s.%s", string2, object4);
                    object2 = object6.iterator();
                    while (object2.hasNext()) {
                        object = (AVBaseMeasure)object2.next();
                        AVCalculatedMeasure aVCalculatedMeasure = (AVCalculatedMeasure)object;
                        String string3 = aVCalculatedMeasure.getExpression();
                        string3 = string3.replaceAll("\\b" + iterator + "\\b", (String)object32);
                        aVCalculatedMeasure.setMeasureExpression(string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            String string4 = exception.getStackTrace()[0].toString();
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string4, exception);
        }
    }

    private void dropCalculatedMeasuresByHierarchy(DBObjectProvider dBObjectProvider, AnalyticView analyticView, String string, String string2) {
        string = dBObjectProvider.getExternalName(string);
        string2 = dBObjectProvider.getExternalName(string2);
        String string3 = String.format("%s.%s", string, string2);
        List<AVCalculatedMeasure> list = analyticView.getCalculatedMeasuresList();
        ArrayList<AVCalculatedMeasure> arrayList = new ArrayList<AVCalculatedMeasure>();
        for (AVCalculatedMeasure aVCalculatedMeasure : list) {
            String string4 = aVCalculatedMeasure.getExpression();
            String string5 = "\\b" + string3 + "\\b";
            Pattern pattern = Pattern.compile(string5);
            Matcher matcher = pattern.matcher(string4);
            if (!matcher.find()) {
                arrayList.add(aVCalculatedMeasure);
                continue;
            }
            this.calculatedMeasuresToBeDropped.add(aVCalculatedMeasure);
        }
        AVCalculatedMeasure[] aVCalculatedMeasureArray = arrayList.toArray(new AVCalculatedMeasure[arrayList.size()]);
        analyticView.setCalculatedMeasures(aVCalculatedMeasureArray);
    }

    private void reconcileCalcExpressionsWithMeasures(Database database, AnalyticView analyticView, AnalyticView analyticView2) {
        Database database2 = database;
        AnalyticView analyticView3 = analyticView;
        AnalyticView analyticView4 = analyticView2;
        List<AVCalculatedMeasure> list = analyticView2.getCalculatedMeasuresList();
        if (analyticView != null) {
            Difference difference = database2.getDiffEngine().difference((Object)analyticView3, (Object)analyticView4);
            Difference difference2 = difference.getChildDifference("measures", false);
            for (Difference difference3 : difference2.getChildren()) {
                String string;
                String string2;
                AVMeasure aVMeasure = (AVMeasure)difference3.getOriginalObject();
                AVMeasure aVMeasure2 = (AVMeasure)difference3.getUpdatedObject();
                if (!difference3.isSame()) {
                    if (difference3.isLeaf()) {
                        if (aVMeasure2 != null) continue;
                        this.dropCalculatedMeasuresByMeasure(analyticView2, aVMeasure.getName());
                        continue;
                    }
                    string2 = null;
                    string = null;
                    for (Difference difference4 : difference3.getChildren()) {
                        if (difference4.isSame() || !difference4.isLeaf() || !difference4.getPropertyName().equalsIgnoreCase("name")) continue;
                        string2 = String.valueOf(difference4.getOriginalObject());
                        string = String.valueOf(difference4.getUpdatedObject());
                        if (this.renamedMeasures.containsKey(string2)) continue;
                        Stack<String> stack = new Stack<String>();
                        stack.push(string2);
                        this.renamedMeasures.put(string2, stack);
                    }
                    if (string2 == null) continue;
                    this.replaceCalculatedMeasuresExpressions(list, string2, string, (DBObjectProvider)database2);
                    continue;
                }
                string2 = aVMeasure.getName();
                string = aVMeasure2.getName();
                if (!this.renamedMeasures.containsKey(string2) || !string2.equals(string)) continue;
                this.replaceCalculatedMeasuresExpressions(list, string2, string, (DBObjectProvider)database2);
            }
        }
    }

    private void replaceCalculatedMeasuresExpressions(List<AVCalculatedMeasure> list, String string, String string2, DBObjectProvider dBObjectProvider) {
        Stack<String> stack = this.renamedMeasures.get(string);
        String string3 = "";
        if (!stack.isEmpty()) {
            string3 = stack.pop();
        }
        if (!(string3 = dBObjectProvider.getExternalName(string3)).equals(string2 = dBObjectProvider.getExternalName(string2))) {
            for (AVBaseMeasure aVBaseMeasure : list) {
                AVCalculatedMeasure aVCalculatedMeasure = (AVCalculatedMeasure)aVBaseMeasure;
                String string4 = aVCalculatedMeasure.getExpression();
                if (UIStringUtils.isQuotedName(string3)) {
                    string4 = string4.replaceAll(string3, string2);
                } else {
                    string4 = string4.replaceAll("\"" + string3 + "\"", string2);
                    string4 = string4.replaceAll("\\b(?iu)" + string3 + "\\b(?=(?:[^\"']*(\"|')[^\"']*\\1)*[^\"']*$)", string2);
                }
                aVCalculatedMeasure.setMeasureExpression(string4);
            }
        }
        if (UIStringUtils.isQuotedName(string2)) {
            string2 = dBObjectProvider.getInternalName(string2);
        }
        stack.push(string2);
        this.renamedMeasures.put(string, stack);
    }

    private void dropCalculatedMeasuresByMeasure(AnalyticView analyticView, String string) {
        List<AVCalculatedMeasure> list = analyticView.getCalculatedMeasuresList();
        ArrayList<AVCalculatedMeasure> arrayList = new ArrayList<AVCalculatedMeasure>();
        for (AVCalculatedMeasure aVCalculatedMeasure : list) {
            String string2 = aVCalculatedMeasure.getExpression();
            String string3 = "\\b" + string + "\\b";
            Pattern pattern = Pattern.compile(string3);
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find()) {
                arrayList.add(aVCalculatedMeasure);
                continue;
            }
            this.calculatedMeasuresToBeDropped.add(aVCalculatedMeasure);
        }
        AVCalculatedMeasure[] aVCalculatedMeasureArray = arrayList.toArray(new AVCalculatedMeasure[arrayList.size()]);
        analyticView.setCalculatedMeasures(aVCalculatedMeasureArray);
    }

    @Override
    public void showForceCreateWarning(Window window) {
        MessageDialog.information((Component)window, (Object)HCSArb.getString("AV_FORCE_WARNING_MSG"), (String)HCSArb.getString("FORCE_WARNING_TITLE"), null);
    }
}

