/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.avviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.text.Document;
import oracle.dbtools.raptor.editors.RaptorEditorPlugin;
import oracle.dbtools.raptor.editors.WorksheetEditorPluginRegistry;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.worksheet.folding.WorksheetFoldingPlugin;
import oracle.hcs.util.ContextUtil;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.DragDropPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class AVQueryPanel
extends JPanel {
    private BasicEditorPane queryEditor;
    private List<RaptorEditorPlugin> installedPlugins;
    private CompletionInsight insightPlugin;
    private WorksheetFoldingPlugin foldingPlugin;
    private JPanel leftMargin;

    public AVQueryPanel(OracleDatabaseImpl oracleDatabaseImpl) {
        this.init(oracleDatabaseImpl);
        this.layoutComponents();
    }

    public void setQuery(String string) {
        this.queryEditor.setText(string);
    }

    public String getQuery() {
        String string = this.queryEditor.getText();
        return string;
    }

    public JPanel getLeftMargin() {
        return this.leftMargin;
    }

    public BasicEditorPane getQueryEditor() {
        return this.queryEditor;
    }

    private void layoutComponents() {
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.queryEditor);
    }

    private void init(OracleDatabaseImpl oracleDatabaseImpl) {
        KeyStrokeContext[] keyStrokeContextArray = new KeyStrokeContext[]{Ide.getKeyStrokeContextRegistry().getContext("oracle/dbtools/worksheet/editor/accelerators.xml")};
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        EditorStatusBar editorStatusBar = new EditorStatusBar();
        this.leftMargin = null;
        boolean bl = true;
        if (bl) {
            Object object;
            BasicDocument basicDocument;
            HighlightEditorPlugin highlightEditorPlugin;
            this.queryEditor = EditorFactory.createIdeEditorPane((KeyStrokeContext[])keyStrokeContextArray);
            this.queryEditor.setEditable(bl);
            this.foldingPlugin = new WorksheetFoldingPlugin();
            if (this.queryEditor.isEditable()) {
                highlightEditorPlugin = null;
                basicDocument = highlightEditorPlugin != null ? new BasicDocument("foo.plsql", highlightEditorPlugin) : new BasicDocument("foo.plsql");
                this.queryEditor.setDocument((Document)basicDocument);
                if (this.insightPlugin != null) {
                    this.queryEditor.deinstallPlugin((EditorPlugin)this.insightPlugin);
                }
                if (Ide.getLastActiveNavigator() != null) {
                    object = Ide.getLastActiveNavigator().getContext();
                    String string = ContextUtil.getConnectionName(object);
                    if (string == null) {
                        string = oracleDatabaseImpl.getConnectionName();
                    }
                    this.insightPlugin = new CompletionInsight(string, this.foldingPlugin.parser);
                    this.queryEditor.installPlugin((EditorPlugin)this.insightPlugin);
                }
            }
            this.queryEditor.installPlugin((EditorPlugin)new LineHighlightPlugin());
            this.queryEditor.installPlugin((EditorPlugin)lineGutterPlugin);
            if (this.queryEditor.isEditable()) {
                this.queryEditor.installPlugin((EditorPlugin)new BraceMatchingPlugin());
                this.queryEditor.installPlugin((EditorPlugin)editorStatusBar);
            }
            highlightEditorPlugin = new HighlightEditorPlugin(this.queryEditor, null);
            if (Ide.getLastActiveNavigator() != null) {
                basicDocument = Ide.getLastActiveNavigator().getContext();
                if (this.queryEditor.isEditable()) {
                    for (String string : WorksheetEditorPluginRegistry.getPlugins((Context)basicDocument)) {
                        this.queryEditor.installPlugin((EditorPlugin)string);
                        if (!(string instanceof RaptorEditorPlugin)) continue;
                        RaptorEditorPlugin raptorEditorPlugin = (RaptorEditorPlugin)string;
                        raptorEditorPlugin.setLineGutter(lineGutterPlugin);
                        this.installedPlugins.add(raptorEditorPlugin);
                    }
                    object = new DragDropPlugin(){

                        protected void removeSelectedText() {
                        }
                    };
                    this.queryEditor.installPlugin((EditorPlugin)object);
                }
            }
            if (this.queryEditor.isEditable()) {
                this.leftMargin = new JPanel(new BorderLayout());
                this.leftMargin.add((Component)lineGutterPlugin, "Center");
            }
        } else {
            this.queryEditor = new BasicEditorPane();
            this.queryEditor.setEditable(false);
        }
    }
}

