/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.panels;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.DBObjectInitializer;
import oracle.hcs.db.panels.DescriptionFields;
import oracle.hcs.db.panels.GeneralBaseEditorPanelContext;
import oracle.hcs.db.panels.PanelUtil;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectListener;

public abstract class GeneralBaseEditorPanel<T extends AbstractSchemaObjectWithDesc>
extends BaseEditorPanel<T>
implements DescriptionFields,
PropertyChangeListener {
    private boolean m_initialized;
    private JLabel captionLabel = new JLabel();
    private JLabel descLabel = new JLabel();
    private JTextField captionFld = new JTextField();
    private JTextField descriptionFld = new JTextField();
    private DBObjectInitializer dbObjectInitializer;
    private boolean captionTextFieldUpdated;
    private boolean descriptionTextFieldUpdated;
    private boolean captionToDescriptionCopyOccurred;
    private boolean skipCaptionToDescriptionSynch;

    public GeneralBaseEditorPanel() {
        GeneralBaseEditorPanelContext generalBaseEditorPanelContext = GeneralBaseEditorPanelContext.getInstance();
        generalBaseEditorPanelContext.setGeneralBaseEditorPanel(this);
    }

    @Override
    public JLabel getCaptionLabel() {
        return this.captionLabel;
    }

    @Override
    public JLabel getDescriptionLabel() {
        return this.descLabel;
    }

    @Override
    public JTextField getCaptionFld() {
        return this.captionFld;
    }

    @Override
    public JTextField getDescriptionFld() {
        return this.descriptionFld;
    }

    protected void updateDescriptions() {
        String string = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getCaption();
        this.captionFld.setText(string);
        String string2 = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getDescription();
        this.descriptionFld.setText(string2);
    }

    protected void setDbObjectInitializer(DBObjectInitializer dBObjectInitializer) {
        this.dbObjectInitializer = dBObjectInitializer;
    }

    protected void initialisePanel() {
        if (!this.m_initialized) {
            GeneralBaseEditorPanelContext generalBaseEditorPanelContext = GeneralBaseEditorPanelContext.getInstance();
            generalBaseEditorPanelContext.setDescriptionSynchOn(true);
            this.initializeDescriptionTextFieldModifiedState();
            this.initializeDescriptionFieldKeyListeners();
            if (!this.isEditing() && this.dbObjectInitializer != null) {
                this.dbObjectInitializer.init(this.getProvider(), (AbstractSchemaObjectWithDesc)this.getOriginalObject(), (AbstractSchemaObjectWithDesc)this.getUpdatedObject());
            }
            ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    List list = dBObjectChange.getOwnedObjectsAdded();
                    if (list != null && list.size() > 0) {
                        for (DBObject dBObject : list) {
                            if (!(dBObject instanceof AbstractChildObjectWithDesc)) continue;
                            AbstractChildObjectWithDesc abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)dBObject;
                            abstractChildObjectWithDesc.setNewObject();
                        }
                    }
                }
            });
        }
        this.updateDescriptions();
        this.m_initialized = true;
    }

    protected oracle.javatools.db.event.DBObjectListener createObjectListener() {
        String[] stringArray = new String[]{"caption"};
        return new SwingDBObjectPropertyListener(stringArray){

            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                if (GeneralBaseEditorPanel.this.isEditing()) {
                    return;
                }
                GeneralBaseEditorPanelContext generalBaseEditorPanelContext = GeneralBaseEditorPanelContext.getInstance();
                if (!generalBaseEditorPanelContext.isDescriptionSynchOn()) {
                    return;
                }
                String string2 = GeneralBaseEditorPanel.this.getCaptionFld().getText();
                if (string.equals("caption")) {
                    if (!GeneralBaseEditorPanel.this.isSkipCaptionToDescriptionSynch()) {
                        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = (AbstractSchemaObjectWithDesc)GeneralBaseEditorPanel.this.getUpdatedObject();
                        GeneralBaseEditorPanel.this.setDescriptionTextFieldUpdated(GeneralBaseEditorPanel.this.isDescriptionTextFieldUpdated() || abstractSchemaObjectWithDesc.getDescriptionDirty() != false);
                        if (!GeneralBaseEditorPanel.this.isDescriptionTextFieldUpdated()) {
                            abstractSchemaObjectWithDesc.setDescription(string2);
                            GeneralBaseEditorPanel.this.descriptionFld.setText(string2);
                            GeneralBaseEditorPanel.this.setCaptionToDescriptionCopyOccurred(true);
                        }
                    }
                    GeneralBaseEditorPanel.this.setSkipCaptionToDescriptionSynch(false);
                }
            }
        };
    }

    private void initializeDescriptionTextFieldModifiedState() {
        if (!this.isEditing()) {
            AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = (AbstractSchemaObjectWithDesc)this.getUpdatedObject();
            abstractSchemaObjectWithDesc.markDescriptionDirty(false);
            abstractSchemaObjectWithDesc.markCaptionDirty(false);
        }
    }

    private void initializeDescriptionFieldKeyListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = (AbstractSchemaObjectWithDesc)GeneralBaseEditorPanel.this.getUpdatedObject();
                if (keyEvent.getSource() == GeneralBaseEditorPanel.this.captionFld) {
                    abstractSchemaObjectWithDesc.setCaption(GeneralBaseEditorPanel.this.captionFld.getText());
                    GeneralBaseEditorPanel.this.setCaptionTextFieldUpdated(true);
                } else if (keyEvent.getSource() == GeneralBaseEditorPanel.this.descriptionFld) {
                    abstractSchemaObjectWithDesc.setDescription(GeneralBaseEditorPanel.this.descriptionFld.getText());
                    GeneralBaseEditorPanel.this.setDescriptionTextFieldUpdated(true);
                }
            }
        };
        this.captionFld.addKeyListener(keyAdapter);
        this.descriptionFld.addKeyListener(keyAdapter);
    }

    protected void commitPanel() throws TraversalException {
        String string = this.descriptionFld.getText();
        ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).setDescription(string);
        string = this.captionFld.getText();
        ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).setCaption(string);
    }

    protected void registerDescriptionFields() {
        ComponentFactory componentFactory = this.getComponentFactory();
        PanelUtil.registerDescriptionFields(componentFactory, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected int layoutDescriptionFields(JPanel jPanel) {
        int n = PanelUtil.layoutDescriptionFields(jPanel, this, 0);
        return ++n;
    }

    public void setCaptionTextFieldUpdated(boolean bl) {
        this.captionTextFieldUpdated = bl;
    }

    public boolean isCaptionTextFieldUpdated() {
        return this.captionTextFieldUpdated;
    }

    public void setDescriptionTextFieldUpdated(boolean bl) {
        this.descriptionTextFieldUpdated = bl;
    }

    public boolean isDescriptionTextFieldUpdated() {
        return this.descriptionTextFieldUpdated;
    }

    public void setCaptionToDescriptionCopyOccurred(boolean bl) {
        this.captionToDescriptionCopyOccurred = bl;
    }

    public boolean isCaptionToDescriptionCopyOccurred() {
        return this.captionToDescriptionCopyOccurred;
    }

    public void setSkipCaptionToDescriptionSynch(boolean bl) {
        this.skipCaptionToDescriptionSynch = bl;
    }

    public boolean isSkipCaptionToDescriptionSynch() {
        return this.skipCaptionToDescriptionSynch;
    }
}

