/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.hcs.HCSArb;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.dimension.panels.AttrMapExpressionCellRenderer;
import oracle.hcs.dimension.panels.CompletionAttributeMatchProvider;
import oracle.hcs.dimension.panels.CompletionLevelMatchProvider;
import oracle.hcs.dimension.panels.LevelMapExpressionCellRenderer;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class DimensionLevelDeterminesTableEditorPanel<T extends DimensionLevel, P extends AttributeDimension>
extends ChildObjectEditorPanel<T, P> {
    private final int LEVEL_COLUMN = 0;
    private final int DETERMINES_COLUMN = 1;
    protected DBObjectProvider prov;
    private List<DimensionAttribute> attributes;
    private CompletionAttributeMatchProvider attributeCompletionProvider;
    private List<DimensionLevel> levels;
    private CompletionLevelMatchProvider levelCompletionProvider;
    private DefaultTableModel tableModel;
    private JTable table;
    private JButton removeButton;
    private JButton addButton;
    private JButton generateButton;
    private TableColumn levelColumn;
    private TableColumn determinesColumn;
    private Map<String, List<String>> determinesMap;

    public DimensionLevelDeterminesTableEditorPanel() {
        super("DimensionLevelDeterminesTableEditorPanel", "ATTRIBUTE DIMENSION");
    }

    protected void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    protected void commitPanel() throws TraversalException {
        String[] stringArray;
        List<Object> list = new ArrayList();
        DimensionLevel[] dimensionLevelArray = ((AttributeDimension)this.getUpdatedObject()).getLevels();
        DimensionAttribute[] dimensionAttributeArray = ((AttributeDimension)this.getUpdatedObject()).getAttributes();
        this.determinesMap.clear();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Object object;
            int n = 0;
            int n2 = 0;
            String string = (String)this.tableModel.getValueAt(i, 0);
            stringArray = (String[])this.tableModel.getValueAt(i, 1);
            String object2 = this.prov.getInternalName(string);
            stringArray = this.prov.getInternalName((String)stringArray);
            for (DimensionLevel dimensionLevel : dimensionLevelArray) {
                if (!dimensionLevel.getName().equals(object2)) continue;
                n = 1;
            }
            if (n == 0) continue;
            for (AbstractChildObjectWithDesc abstractChildObjectWithDesc : dimensionAttributeArray) {
                if (!abstractChildObjectWithDesc.getName().equals(stringArray)) continue;
                n2 = 1;
            }
            if (n2 == 0) continue;
            if (this.determinesMap.containsKey(object2)) {
                object = this.determinesMap.get(object2);
                object.add(stringArray);
                this.determinesMap.replace(object2, (List<String>)object);
                continue;
            }
            object = new ArrayList();
            object.add(stringArray);
            this.determinesMap.put(object2, (List<String>)object);
        }
        for (DimensionLevel dimensionLevel : dimensionLevelArray) {
            dimensionLevel.setLevelDeterminesKeys(null);
        }
        for (DimensionLevel dimensionLevel : dimensionLevelArray) {
            if (!this.determinesMap.containsKey(dimensionLevel.getName())) continue;
            list = this.determinesMap.get(dimensionLevel.getName());
            stringArray = list.toArray(new String[list.size()]);
            dimensionLevel.setLevelDeterminesKeys(stringArray);
        }
    }

    protected void initialisePanel() {
        Object object;
        super.initialisePanel();
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        List<DimensionLevel> list = Arrays.asList(attributeDimension.getLevels());
        if (!this.levels.containsAll(list) || this.levels.size() != list.size()) {
            this.levels = Arrays.asList(attributeDimension.getLevels());
            object = this.levels.iterator();
            while (object.hasNext()) {
                DimensionLevel dimensionLevel = (DimensionLevel)object.next();
                String object2 = this.prov.getExternalName(dimensionLevel.getName());
                dimensionLevel.setExternalName(object2);
            }
            this.levelColumn.setCellEditor(new LevelCellEditor(this.levels));
        }
        if (!this.attributes.containsAll((Collection<?>)(object = Arrays.asList(attributeDimension.getAttributes()))) || this.attributes.size() != object.size()) {
            this.attributes = Arrays.asList(attributeDimension.getAttributes());
            for (DimensionAttribute dimensionAttribute : this.attributes) {
                String string = this.prov.getExternalName(dimensionAttribute.getName());
                dimensionAttribute.setExternalName(string);
            }
            this.determinesColumn.setCellEditor(new AttributeCellEditor(this.attributes));
        }
        this.determinesMap = new HashMap<String, List<String>>();
        this.loadData();
    }

    protected void initialiseComponents() {
        Object object;
        this.initImpl(this.getProvider());
        this.setName(((Object)((Object)this)).getClass().getName());
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"levels"});
        this.tableModel = new DefaultTableModel();
        this.table = new JTable(this.tableModel){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        };
        this.tableModel.setColumnIdentifiers(new String[]{HCSArb.getString("DETERMINES_PANEL_LEVEL_COLUMN"), HCSArb.getString("DETERMINES_PANEL_DETERMINES_COLUMN")});
        this.levels = Arrays.asList(((AttributeDimension)this.getUpdatedObject()).getLevels());
        for (DimensionLevel abstractChildObjectWithDesc2 : this.levels) {
            object = this.prov.getExternalName(abstractChildObjectWithDesc2.getName());
            abstractChildObjectWithDesc2.setExternalName((String)object);
        }
        this.levelColumn = this.table.getColumn(HCSArb.getString("DETERMINES_PANEL_LEVEL_COLUMN"));
        this.levelColumn.setCellRenderer(new LevelMapExpressionCellRenderer(HCSArb.get("DETERMINES_PANEL_LEVEL_COLUMN")));
        this.levelColumn.setCellEditor(new LevelCellEditor(this.levels));
        this.attributes = Arrays.asList(((AttributeDimension)this.getUpdatedObject()).getAttributes());
        for (DimensionAttribute dimensionAttribute : this.attributes) {
            object = this.prov.getExternalName(dimensionAttribute.getName());
            dimensionAttribute.setExternalName((String)object);
        }
        this.determinesColumn = this.table.getColumn(HCSArb.getString("DETERMINES_PANEL_DETERMINES_COLUMN"));
        this.determinesColumn.setCellRenderer(new AttrMapExpressionCellRenderer(HCSArb.get("DETERMINES_PANEL_DETERMINES_COLUMN")));
        this.determinesColumn.setCellEditor(new AttributeCellEditor(this.attributes));
        Iterator<AbstractChildObjectWithDesc> iterator = new ControlBar();
        this.generateButton = new JButton(HCSArb.getString("DETERMINES_PANEL_GENERATE_BUTTON_LABEL"));
        this.generateButton.setToolTipText(HCSArb.getString("DETERMINES_PANEL_GENERATE_BUTTON_TOOLTIP"));
        iterator.add(Box.createRigidArea(new Dimension(5, 16)));
        iterator.add(this.generateButton);
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DimensionLevelDeterminesTableEditorPanel.this.createDetermines();
            }
        });
        this.addButton = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addButton.setToolTipText(HCSArb.getString("DETERMINES_PANEL_ADD_BUTTON_TOOLTIP"));
        iterator.add(Box.createRigidArea(new Dimension(5, 16)));
        iterator.add(this.addButton);
        this.addButton.setEnabled(true);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DimensionLevelDeterminesTableEditorPanel.this.table.getSelectedRow();
                if (n > -1) {
                    String string = (String)DimensionLevelDeterminesTableEditorPanel.this.tableModel.getValueAt(n, 0);
                    DimensionLevelDeterminesTableEditorPanel.this.tableModel.insertRow(DimensionLevelDeterminesTableEditorPanel.this.table.getSelectedRow() + 1, new Object[]{string, ""});
                    DimensionLevelDeterminesTableEditorPanel.this.table.setRowSelectionInterval(n + 1, n + 1);
                } else {
                    n = DimensionLevelDeterminesTableEditorPanel.this.tableModel.getRowCount();
                    DimensionLevelDeterminesTableEditorPanel.this.tableModel.addRow(new Object[]{"", ""});
                    DimensionLevelDeterminesTableEditorPanel.this.table.setRowSelectionInterval(n, n);
                }
                DimensionLevelDeterminesTableEditorPanel.this.table.scrollRectToVisible(DimensionLevelDeterminesTableEditorPanel.this.table.getCellRect(DimensionLevelDeterminesTableEditorPanel.this.table.getSelectedRow(), 0, true));
                DimensionLevelDeterminesTableEditorPanel.this.updateGenerateButton();
            }
        });
        this.removeButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeButton.setToolTipText(HCSArb.getString("DETERMINES_PANEL_REMOVE_BUTTON_TOOLTIP"));
        iterator.add(Box.createRigidArea(new Dimension(5, 16)));
        iterator.add(this.removeButton);
        this.removeButton.setEnabled(true);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DimensionLevelDeterminesTableEditorPanel.this.removeSelectedRow();
            }
        });
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(HCSArb.getString("DETERMINES_TITLE")));
        componentWithTitlebar.setControlBar(iterator);
        object = new JScrollPane(this.table);
        ((JScrollPane)object).setHorizontalScrollBarPolicy(30);
        ((JScrollPane)object).setVerticalScrollBarPolicy(20);
        componentWithTitlebar.setComponent((JComponent)object);
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)componentWithTitlebar, new GridBagConstraints(0, ++n, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 12), 0, 0));
        ++n;
    }

    private void loadData() {
        this.tableModel.setRowCount(0);
        for (DimensionLevel dimensionLevel : this.levels) {
            for (String string : dimensionLevel.getLevelDeterminesKeys()) {
                String string2 = this.prov.getExternalName(string);
                this.tableModel.addRow(new Object[]{dimensionLevel.getExternalName(), string2});
            }
        }
        this.updateGenerateButton();
    }

    private void removeSelectedRow() {
        int n = this.table.getEditingRow();
        if (n == -1) {
            n = this.table.getSelectedRow();
        }
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.tableModel.removeRow(n);
        if (n < this.table.getRowCount() && n > -1) {
            this.table.addRowSelectionInterval(n, n);
        } else if (this.table.getRowCount() > 0) {
            this.table.addRowSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
        }
        this.updateGenerateButton();
    }

    private void updateGenerateButton() {
        this.generateButton.setEnabled(this.table.getRowCount() < 1 && ((AttributeDimension)this.getUpdatedObject()).getLevels().length > 1);
    }

    private void createDetermines() {
        DimensionLevel[] dimensionLevelArray = ((AttributeDimension)this.getUpdatedObject()).getLevels();
        if (dimensionLevelArray.length > 1) {
            for (int i = 1; i < dimensionLevelArray.length; ++i) {
                String[] stringArray;
                String string = dimensionLevelArray[i - 1].getLevelKey();
                if (string.contains(",") && (stringArray = (string = string.replaceAll("[()]", "")).split(",")) != null & stringArray.length > 0) {
                    string = stringArray[0];
                }
                this.tableModel.addRow(new Object[]{this.prov.getExternalName(dimensionLevelArray[i].getName()), this.prov.getExternalName(string)});
            }
            this.updateGenerateButton();
        }
    }

    protected boolean shouldValidateOnExit() {
        return true;
    }

    protected void validateObject() throws TraversalException {
        HashSet<String> hashSet = new HashSet<String>();
        for (DimensionLevel dimensionLevel : ((AttributeDimension)this.getUpdatedObject()).getLevels()) {
            for (String string : dimensionLevel.getLevelDeterminesKeys()) {
                if (hashSet.add(string)) continue;
                throw new TraversalException(HCSArb.format("DETERMINES_PANEL_ERROR_VALIDATION_MSG", string), HCSArb.getString("DETERMINES_PANEL_ERROR_VALIDATION_TITLE"));
            }
        }
    }

    private class LevelCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private List<DimensionLevel> levels;
        private JComboBox combo;

        public LevelCellEditor(List<DimensionLevel> list) {
            this.levels = list;
        }

        @Override
        public Component getTableCellEditorComponent(final JTable jTable, Object object, boolean bl, final int n, final int n2) {
            this.combo = new JComboBox();
            this.combo.setEditable(false);
            this.populateComboBox(n, this.combo);
            this.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LevelCellEditor.this.stopCellEditing();
                    jTable.setValueAt(LevelCellEditor.this.combo.getSelectedItem(), n, n2);
                }
            });
            return this.combo;
        }

        private void populateComboBox(int n, JComboBox jComboBox) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            jComboBox.setModel(defaultComboBoxModel);
            String string = (String)DimensionLevelDeterminesTableEditorPanel.this.tableModel.getValueAt(n, 0);
            for (DimensionLevel dimensionLevel : this.levels) {
                String string2 = DimensionLevelDeterminesTableEditorPanel.this.prov.getExternalName(dimensionLevel.getName());
                defaultComboBoxModel.addElement(string2);
            }
            defaultComboBoxModel.setSelectedItem(string);
        }

        @Override
        public Object getCellEditorValue() {
            return this.combo.getSelectedItem();
        }
    }

    private class AttributeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private List<DimensionAttribute> attributes;
        private JComboBox combo;

        public AttributeCellEditor(List<DimensionAttribute> list) {
            this.attributes = list;
        }

        @Override
        public Component getTableCellEditorComponent(final JTable jTable, Object object, boolean bl, final int n, final int n2) {
            this.combo = new JComboBox();
            this.combo.setEditable(false);
            this.populateComboBox(n, this.combo);
            this.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AttributeCellEditor.this.stopCellEditing();
                    jTable.setValueAt(AttributeCellEditor.this.combo.getSelectedItem(), n, n2);
                }
            });
            return this.combo;
        }

        private void populateComboBox(int n, JComboBox jComboBox) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            jComboBox.setModel(defaultComboBoxModel);
            String string = (String)DimensionLevelDeterminesTableEditorPanel.this.tableModel.getValueAt(n, 1);
            for (DimensionAttribute dimensionAttribute : this.attributes) {
                String string2 = DimensionLevelDeterminesTableEditorPanel.this.prov.getExternalName(dimensionAttribute.getName());
                defaultComboBoxModel.addElement(string2);
            }
            defaultComboBoxModel.setSelectedItem(string);
        }

        @Override
        public Object getCellEditorValue() {
            return this.combo.getSelectedItem();
        }
    }
}

