/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.preferences;

import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class HCSPreferenceSettings
extends HashStructureAdapter {
    protected static final String DATA_KEY = "oracle.hcs.preferences.build.HCSPreferenceSettings";
    public static final String TEMPLATE_DIRECTORY = "TEMPLATE_DIRECTORY";
    public static final String TEMPLATE_FILE = "TEMPLATE_FILE";
    public static final String TEMPLATE_NAME_FILE = "TEMPLATE_NAME_FILE";
    public static final String AV_DATA_VIEWER_MAX_ROWS = "AV_DATA_VIEWER_MAX_ROWS";
    private static final int AV_DATA_VIEWER_MAX_ROWS_DEFAULT = 200;
    public static final String AV_DATA_VIEWER_MAX_HIERARCHIES = "AV_DATA_VIEWER_MAX_HIERARCHIES";
    public static final int AV_DATA_VIEWER_MAX_HIERARCHIES_DEFAULT = 2;
    public static final String AUTO_GENERATE_LEVELS = "AUTO_GENERATE_LEVELS";
    public static final boolean AUTO_GENERATE_LEVELS_DEFAULT = false;

    static HCSPreferenceSettings getInstance() {
        return HCSPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    protected HCSPreferenceSettings(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static HCSPreferenceSettings getInstance(PropertyStorage propertyStorage) {
        return new HCSPreferenceSettings(HCSPreferenceSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public void setAVDataViewerMaxRows(int n) {
        this._hash.putInt(AV_DATA_VIEWER_MAX_ROWS, n);
    }

    public int getAVDataViewerMaxRows() {
        return this._hash.getInt(AV_DATA_VIEWER_MAX_ROWS, 200);
    }

    public void setAVDataViewerMaxHierarchies(int n) {
        this._hash.putInt(AV_DATA_VIEWER_MAX_HIERARCHIES, n);
    }

    public int getAVDataViewerMaxHierarchies() {
        return this._hash.getInt(AV_DATA_VIEWER_MAX_HIERARCHIES, 2);
    }

    public void setTemplateDirectory(String string) {
        this._hash.putString(TEMPLATE_DIRECTORY, string);
    }

    public String getTemplateDirectory() {
        return this._hash.getString(TEMPLATE_DIRECTORY);
    }

    public void setTemplateFile(String string) {
        this._hash.putString(TEMPLATE_FILE, string);
    }

    public String getTemplateFile() {
        return this._hash.getString(TEMPLATE_FILE);
    }

    public void setTemplateNameFile(String string) {
        this._hash.putString(TEMPLATE_NAME_FILE, string);
    }

    public String getTemplateNameFile() {
        return this._hash.getString(TEMPLATE_NAME_FILE);
    }

    public void setAutoGenerateLevels(Boolean bl) {
        this._hash.putBoolean(AUTO_GENERATE_LEVELS, bl.booleanValue());
    }

    public boolean getAutoGenerateLevels() {
        return this._hash.getBoolean(AUTO_GENERATE_LEVELS, false);
    }
}

