/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.quickav;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.BaseRunnable;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.SourceMetadata;
import oracle.hcs.db.view.TransactionWaitCursorManager;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.quickav.QuickAVDataPanel;
import oracle.hcs.quickav.QuickAVDataTableHelper;
import oracle.hcs.quickav.QuickAVDimensionEditor;
import oracle.hcs.quickav.QuickAVDimensionGenerator;
import oracle.hcs.quickav.QuickAVMeasureEditor;
import oracle.hcs.quickav.QuickAVSaveDDL;
import oracle.hcs.quickav.model.TableCol;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.help.HelpSystem;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class QuickAVDialog
extends JDialog
implements QuickAVDataTableHelper,
ActionListener {
    private QuickAVDataPanel dataPanel;
    private QuickAVMeasureEditor measuresEditor;
    private QuickAVDimensionEditor dimensionsEditor;
    private JTabbedPane tabs;
    private static final int FACT_TABLE_TAB = 0;
    private static final int MEASURES_TAB = 1;
    private static final int DIMENSIONS_TAB = 2;
    private static final int DDL_TAB = 3;
    private static final String FACT_TABLE_TAB_HELP_ID = "av_quick_av";
    private static final String MEASURES_TAB_HELP_ID = "quick_av_measures";
    private static final String DIMENSIONS_TAB_HELP_ID = "quick_av_attr_dims";
    private static final String DDL_TAB_HELP_ID = "quick_av_ddl";
    private boolean queryChanged;
    private boolean metadataChanged;
    private BasicEditorPane ddlPane;
    private List<String> ddlStatements;
    private boolean avCreated;
    private DBObject dbObject;
    private HCSSchema schema;
    private JButton saveBtn;
    private JButton okBtn;
    private QuickAVDimensionGenerator dimGen;
    private List<String> existingObjects;
    private JPanel ddlPanel;
    private final String OK_COMMAND = "OK_ID";
    private final String CANCEL_COMMAND = "CANCEL_ID";
    private final String HELP_COMMAND = "HELP_ID";

    public QuickAVDialog(DBObject dBObject, HCSSchema hCSSchema, SourceMetadata sourceMetadata, List<DatabaseSource> list) throws Exception {
        super((Frame)Ide.getMainWindow());
        this.setTitle(HCSArb.getString("QUICK_AV_DIALOG_TITLE"));
        this.setMinimumSize(new Dimension(800, 600));
        this.setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo((Component)Ide.getMainWindow());
        this.dbObject = dBObject;
        this.schema = hCSSchema;
        this.tabs = new JTabbedPane(){

            @Override
            public void setSelectedIndex(int n) {
                int n2 = this.getSelectedIndex();
                if (n2 == 0) {
                    if (!QuickAVDialog.this.isAVNameValid()) {
                        super.setSelectedIndex(0);
                        return;
                    }
                } else if (n2 == 1) {
                    if (!QuickAVDialog.this.measuresEditor.commitCellEdit()) {
                        super.setSelectedIndex(1);
                        return;
                    }
                } else if (n2 == 2 && !QuickAVDialog.this.dimensionsEditor.commitCellEdit()) {
                    super.setSelectedIndex(2);
                    return;
                }
                super.setSelectedIndex(n);
            }
        };
        this.dimGen = new QuickAVDimensionGenerator(list.get(0), hCSSchema, dBObject.getDatabase());
        this.existingObjects = this.dimGen.getExistingTableAndViewNames();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.tabs, FACT_TABLE_TAB_HELP_ID);
        this.dataPanel = new QuickAVDataPanel(this, dBObject.getConnection(), hCSSchema, this, sourceMetadata, list, dBObject.getDatabase(), this.dimGen);
        this.measuresEditor = new QuickAVMeasureEditor(null, (QuickAVDataTableHelper)this, (DBObjectProvider)dBObject.getDatabase());
        this.dimensionsEditor = new QuickAVDimensionEditor(null, this, (DBObjectProvider)dBObject.getDatabase(), hCSSchema, this.existingObjects);
        this.ddlPane = new BasicEditorPane();
        this.ddlPanel = new JPanel(new GridBagLayout());
        this.ddlPanel.add((Component)new JScrollPane((Component)this.ddlPane), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.saveBtn = new JButton(StringUtils.stripMnemonic((String)HCSArb.getString("QUICK_AV_SAVE_BTN")));
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    QuickAVSaveDDL.saveDDLToFile(QuickAVDialog.this, QuickAVDialog.this.ddlPane.getText(), String.format("%s.sql", QuickAVDialog.this.dataPanel.getAVName()));
                }
                catch (Exception exception) {
                    Logger.getLogger(QuickAVDialog.class.getName()).log(Level.SEVERE, "Error saving ddl for quick analytic view", exception);
                }
            }
        });
        this.saveBtn.setMnemonic(StringUtils.getMnemonicKeyCode((String)HCSArb.get("QUICK_AV_SAVE_BTN")));
        this.saveBtn.setEnabled(false);
        this.ddlPanel.add((Component)this.saveBtn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.ddlStatements = Collections.emptyList();
        this.ddlPane.setDocument((Document)new BasicDocument("foo.plsql"));
        this.tabs.add(HCSArb.getString("QUICK_AV_DIALOG_SRC_TABLE_ANALYSIS_TAB"), this.dataPanel);
        this.tabs.add(HCSArb.getString("MEASURES.TITLE"), this.measuresEditor);
        this.tabs.add(HCSArb.getString("MODIFY_ATTR_DIMENSIONS_PROPS_DIMS_VIEW"), this.dimensionsEditor);
        this.tabs.add(HCSArb.getString("QUICK_AV_DIALOG_AV_DDL_TAB"), this.ddlPanel);
        this.tabs.setEnabledAt(1, false);
        this.tabs.setEnabledAt(2, false);
        this.tabs.setEnabledAt(3, false);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = QuickAVDialog.this.tabs.getSelectedIndex();
                QuickAVDialog.this.dataPanel.commitCellEdit();
                try {
                    if (n == 3) {
                        if (QuickAVDialog.this.metadataChanged || QuickAVDialog.this.queryChanged) {
                            if (QuickAVDialog.this.queryChanged) {
                                QuickAVDialog.this.manageDDL(true, true);
                            } else {
                                QuickAVDialog.this.manageDDL(false, true);
                            }
                            QuickAVDialog.this.metadataChanged = false;
                        }
                        QuickAVDialog.this.setDDLEditable(true);
                        if (!QuickAVDialog.this.ddlStatements.isEmpty()) {
                            StringBuilder stringBuilder = new StringBuilder();
                            for (String string : QuickAVDialog.this.ddlStatements) {
                                if (string.startsWith("/*") && string.endsWith("*/") || string.startsWith("--")) {
                                    stringBuilder.append(String.format("%s \n\n", string));
                                    continue;
                                }
                                stringBuilder.append(String.format("%s ;\n\n", string));
                            }
                            QuickAVDialog.this.ddlPane.setText(stringBuilder.toString());
                            QuickAVDialog.this.saveBtn.setEnabled(true);
                        } else {
                            QuickAVDialog.this.notifyEmptyDDL();
                            QuickAVDialog.this.tabs.setSelectedIndex(0);
                            QuickAVDialog.this.ddlPane.setText("");
                            QuickAVDialog.this.saveBtn.setEnabled(false);
                        }
                        QuickAVDialog.this.setDDLEditable(false);
                    } else if (n == 1 || n == 2) {
                        if (QuickAVDialog.this.queryChanged) {
                            QuickAVDialog.this.manageDDL(true, false);
                            QuickAVDialog.this.measuresEditor.setMetadataObjectList(QuickAVDialog.this.dataPanel.getMeasures());
                            QuickAVDialog.this.dimensionsEditor.setMetadataObjectList(QuickAVDialog.this.dataPanel.getDimensions());
                            QuickAVDialog.this.dimensionsEditor.setAllModelHierarchies(QuickAVDialog.this.dataPanel.getHierarchies());
                            QuickAVDialog.this.queryChanged = false;
                        }
                        if (QuickAVDialog.this.dataPanel.getMeasures().isEmpty() || QuickAVDialog.this.dataPanel.getDimensions().isEmpty()) {
                            QuickAVDialog.this.notifyEmptyDDL();
                            QuickAVDialog.this.tabs.setSelectedIndex(0);
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(QuickAVDialog.class.getName()).log(Level.SEVERE, "Error generating ddl for quick analytic view", exception);
                }
            }
        });
        this.add((Component)this.tabs, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JButton jButton = new JButton(StringUtils.stripMnemonic((String)HCSArb.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.okBtn = new JButton(HCSArb.getString("DIALOG_OK_BUTTON_TEXT"));
        this.okBtn.addActionListener(this);
        this.okBtn.setActionCommand("OK_ID");
        this.getRootPane().setDefaultButton(this.okBtn);
        JButton jButton2 = new JButton(HCSArb.getString("DIALOG_CANCEL_BUTTON_TEXT"));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("CANCEL_ID");
        jButton.addActionListener(this);
        jButton.setActionCommand("HELP_ID");
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)jButton, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)this.okBtn, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)jButton2, DialogButtonBar.CONSTRAINT_CANCEL);
        this.add((Component)dialogButtonBar, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.registerKeyboardActions();
    }

    private void showHelp(JComponent jComponent, String string) {
        HelpSystem.getHelpSystem().registerTopic(jComponent, string);
        HelpSystem.getHelpSystem().showHelp(jComponent);
    }

    private void manageDDL(final boolean bl, final boolean bl2) throws Exception {
        BaseRunnable baseRunnable = new BaseRunnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        QuickAVDialog.this.dataPanel.createMetadataObjects();
                    }
                    if (bl2) {
                        QuickAVDialog.this.ddlStatements = QuickAVDialog.this.dataPanel.generateAVDDL();
                    }
                }
                catch (Exception exception) {
                    this.setException(exception);
                }
                finally {
                    this.getProgressBar().setDoneStatus();
                }
            }
        };
        ProgressBar progressBar = new ProgressBar((Component)this, HCSArb.getString("QUICK_AV_DIALOG_TITLE"), (Runnable)baseRunnable, true);
        progressBar.setCancelable(false);
        baseRunnable.setProgressBar(progressBar);
        progressBar.start(HCSArb.getString("QUICK_AV_PROCESSING_METADATA"), null);
        if (baseRunnable.getException() != null) {
            throw baseRunnable.getException();
        }
    }

    private boolean checkTimeBasedDimLevelsTypeNotSet() {
        List<AttributeDimension> list = this.dataPanel.getDimensions();
        for (AttributeDimension attributeDimension : list) {
            if (!attributeDimension.isTime()) continue;
            for (DimensionLevel dimensionLevel : attributeDimension.getLevels()) {
                if (dimensionLevel.getLevelType() != null && !dimensionLevel.getLevelType().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void setDDLEditable(boolean bl) {
        this.ddlPane.setEditable(bl);
    }

    private void notifyEmptyDDL() {
        if (this.dataPanel.getMeasures().isEmpty() || this.dataPanel.getDimensions().isEmpty()) {
            JOptionPane.showMessageDialog(this, HCSArb.getString("QUICK_AV_NO_MEASURES_OR_DIMENSIONS_ERROR"), this.getTitle(), 0);
        }
    }

    private boolean isAVNameValid() {
        boolean bl = true;
        try {
            this.dbObject.getDatabase().validateName("ANALYTIC VIEW", this.dataPanel.getAVName());
        }
        catch (InvalidNameException invalidNameException) {
            bl = false;
            String string = invalidNameException.getMessage();
            MessageDialog.error((Component)this, (Object)string, (String)HCSArb.getString("QUICK_AV_INVALID_NAME_TITLE"), null);
            return bl;
        }
        AnalyticView analyticView = this.schema.findAV(this.dataPanel.getAVName());
        if (analyticView != null) {
            bl = false;
            MessageDialog.error((Component)this, (Object)HCSArb.getString("QUICK_AV_ALREADY_EXISTS_ERROR"), (String)HCSArb.getString("QUICK_AV_INVALID_NAME_TITLE"), null);
            return bl;
        }
        if (this.existingObjects.contains(this.dbObject.getDatabase().getInternalName(this.dbObject.getDatabase().getExternalName(this.dataPanel.getAVName())))) {
            bl = false;
            MessageDialog.error((Component)this, (Object)HCSArb.format("QUICK_AV_OBJECT_NAME_VALIDATION_ERROR", this.dataPanel.getAVName()), (String)HCSArb.getString("QUICK_AV_INVALID_NAME_TITLE"), null);
            return bl;
        }
        return bl;
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    protected static String qualifyName(HCSSchema hCSSchema, String string, String string2) {
        if (hCSSchema.getName().equalsIgnoreCase(string2)) {
            return string;
        }
        return String.format("%s.%s", string2, string);
    }

    @Override
    public void quickAVDataTableChanged() {
        this.tabs.setEnabledAt(1, true);
        this.tabs.setEnabledAt(2, true);
        this.tabs.setEnabledAt(3, true);
        this.queryChanged = true;
    }

    @Override
    public void quickAVMetadataChanged() {
        this.metadataChanged = true;
    }

    @Override
    public void predictColumnsType(List<TableCol> list) {
        double d = this.getColumnsMedianCardinality(list);
        for (TableCol tableCol : list) {
            List<AttributeDimension> list2 = this.dimGen.findDimForMapExpression(tableCol.getFieldName());
            if (this.dimGen.sourceTableHasConstraints()) {
                String string = this.dimGen.findDimensionTableSourceForColumn(tableCol.getFieldName());
                if (!list2.isEmpty() || string != null) {
                    tableCol.setFieldType(HCSArb.getString("QUICK_AV_DIALOG_DIMENSION").toUpperCase());
                    tableCol.setMatchingDimension(HCSArb.getString("QUICK_AV_CREATE_NEW_DIM"));
                    continue;
                }
                tableCol.setFieldType(HCSArb.getString("QUICK_AV_DIALOG_MEASURE").toUpperCase());
                continue;
            }
            if (!list2.isEmpty() || (double)tableCol.getCardinality() <= d) {
                tableCol.setFieldType(HCSArb.getString("QUICK_AV_DIALOG_DIMENSION").toUpperCase());
                tableCol.setMatchingDimension(HCSArb.getString("QUICK_AV_CREATE_NEW_DIM"));
                continue;
            }
            tableCol.setFieldType(HCSArb.getString("QUICK_AV_DIALOG_MEASURE").toUpperCase());
        }
    }

    public boolean isAVCreated() {
        return this.avCreated;
    }

    private double getColumnsMedianCardinality(List<TableCol> list) {
        int n = list.size() / 2;
        if (list.size() % 2 == 0) {
            return (double)(list.get(n - 1).getCardinality() + list.get(n).getCardinality()) / 2.0;
        }
        return list.get(n).getCardinality();
    }

    private void create() {
        String string = this.dataPanel.getFactTable();
        if (string != null && !string.isEmpty()) {
            if (!this.isAVNameValid()) {
                return;
            }
            if (this.ddlStatements == null || this.ddlStatements.isEmpty() || this.queryChanged || this.metadataChanged) {
                try {
                    this.manageDDL(false, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.dbObject.getConnection());
            if (!this.ddlStatements.isEmpty()) {
                try {
                    if (this.checkTimeBasedDimLevelsTypeNotSet()) {
                        JOptionPane.showMessageDialog(this, HCSArb.getString("QUICK_AV_INVALID_DIMENSION_LEVELS"), this.getTitle(), 0);
                        return;
                    }
                    for (String string2 : this.ddlStatements) {
                        if (string2.startsWith("/*") || string2.endsWith("*/") || string2.startsWith("--")) continue;
                        dBUtil.execute(string2);
                        SQLException sQLException = dBUtil.getLastException();
                        if (sQLException == null) continue;
                        throw sQLException;
                    }
                    this.avCreated = true;
                    this.close();
                }
                catch (Exception exception) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)HCSArb.getString("QUICK_AV_DIALOG_TITLE"), (String)"");
                    return;
                }
            } else {
                this.notifyEmptyDDL();
            }
        }
    }

    private void showHelp() {
        int n = this.tabs.getSelectedIndex();
        switch (n) {
            case 0: {
                this.showHelp(this.dataPanel, FACT_TABLE_TAB_HELP_ID);
                break;
            }
            case 1: {
                this.showHelp(this.measuresEditor, MEASURES_TAB_HELP_ID);
                break;
            }
            case 2: {
                this.showHelp(this.dimensionsEditor, DIMENSIONS_TAB_HELP_ID);
                break;
            }
            case 3: {
                this.showHelp(this.ddlPanel, DDL_TAB_HELP_ID);
            }
        }
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(156, 0), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("OK_ID")) {
            if (this.isAVNameValid() && this.okBtn.hasFocus()) {
                TransactionWaitCursorManager transactionWaitCursorManager = TransactionWaitCursorManager.getInstance();
                try {
                    transactionWaitCursorManager.setDialog(this);
                    transactionWaitCursorManager.showWaitCursor();
                    this.okBtn.setEnabled(false);
                    this.create();
                }
                catch (Throwable throwable) {
                    Logger.getLogger(QuickAVDialog.class.getName()).log(Level.SEVERE, throwable.getMessage(), throwable);
                }
                finally {
                    transactionWaitCursorManager.showDefaultCursor();
                    transactionWaitCursorManager.reset();
                }
            }
        } else if (string.equalsIgnoreCase("CANCEL_ID")) {
            this.close();
        } else if (string.equalsIgnoreCase("HELP_ID")) {
            this.showHelp();
        }
    }
}

