/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import java.util.List;
import oracle.hcs.syntax.Expression;
import oracle.hcs.syntax.FunctionArgument;
import oracle.hcs.syntax.FunctionDescriptor;
import oracle.hcs.syntax.FunctionDescriptorCatalog;
import oracle.hcs.syntax.KeywordArgument;
import oracle.hcs.syntax.KeywordCatalog;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;

public final class OLAPFunctionExpression
extends TypedExpression {
    private String m_FunctionName;
    private FunctionDescriptor m_FunctionDescriptor;
    private FunctionArgument[] m_Arguments;
    private FunctionArgument[] m_HierarchyArguments;

    private FunctionArgument[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    private FunctionArgument[] getHierarchyClauseArgumentsInternal() {
        return this.m_HierarchyArguments;
    }

    private FunctionArgument[] stripOLAPFunctionKeywords(FunctionArgument[] functionArgumentArray, SyntaxPrintingContext syntaxPrintingContext) {
        if (syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("1.2")) {
            return functionArgumentArray;
        }
        int n = 0;
        for (int i = 0; i < functionArgumentArray.length; ++i) {
            if (KeywordCatalog.DIMENSION == functionArgumentArray[i] || KeywordCatalog.HIERARCHY == functionArgumentArray[i] || KeywordCatalog.OPTIMIZE == functionArgumentArray[i] || KeywordCatalog.YES == functionArgumentArray[i] || KeywordCatalog.NO == functionArgumentArray[i] || KeywordCatalog.FORCE == functionArgumentArray[i]) continue;
            ++n;
        }
        if (functionArgumentArray.length == n) {
            return functionArgumentArray;
        }
        FunctionArgument[] functionArgumentArray2 = new FunctionArgument[n];
        int n2 = 0;
        for (int i = 0; i < functionArgumentArray.length; ++i) {
            if (KeywordCatalog.DIMENSION == functionArgumentArray[i] || KeywordCatalog.HIERARCHY == functionArgumentArray[i] || KeywordCatalog.OPTIMIZE == functionArgumentArray[i] || KeywordCatalog.YES == functionArgumentArray[i] || KeywordCatalog.NO == functionArgumentArray[i] || KeywordCatalog.FORCE == functionArgumentArray[i]) continue;
            functionArgumentArray2[n2++] = functionArgumentArray[i];
        }
        return functionArgumentArray2;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        FunctionArgument[] functionArgumentArray;
        syntaxPrintingContext.append(this.getFunctionName());
        boolean bl = this.hasHierarchyClause();
        FunctionArgument[] functionArgumentArray2 = functionArgumentArray = this.stripOLAPFunctionKeywords(this.getArgumentsInternal(), syntaxPrintingContext);
        KeywordArgument keywordArgument = new KeywordArgument("OVER");
        if (functionArgumentArray.length == 2 && functionArgumentArray[1].equals(keywordArgument)) {
            functionArgumentArray2 = new FunctionArgument[]{functionArgumentArray[0]};
        }
        if (functionArgumentArray.length == 1 && functionArgumentArray[0].equals(keywordArgument)) {
            functionArgumentArray2 = new FunctionArgument[]{};
        }
        Expression.printExpressions(functionArgumentArray2, syntaxPrintingContext, bl);
        if (bl) {
            FunctionArgument[] functionArgumentArray3 = this.stripOLAPFunctionKeywords(this.getHierarchyClauseArgumentsInternal(), syntaxPrintingContext);
            boolean bl2 = true;
            if (syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("1.2") && functionArgumentArray3.length > 0 && (KeywordCatalog.DIMENSION == functionArgumentArray3[0] || KeywordCatalog.HIERARCHY == functionArgumentArray3[0])) {
                bl2 = false;
            }
            syntaxPrintingContext.append(" OVER ");
            if (bl2) {
                syntaxPrintingContext.append("HIERARCHY ");
            }
            Expression.printExpressions(functionArgumentArray3, syntaxPrintingContext);
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        FunctionArgument[] functionArgumentArray = new FunctionArgument[this.getArgumentsInternal().length];
        FunctionArgument[] functionArgumentArray2 = null;
        if (null != this.getHierarchyClauseArgumentsInternal()) {
            functionArgumentArray2 = new FunctionArgument[this.getHierarchyClauseArgumentsInternal().length];
        }
        this.m_FunctionDescriptor = FunctionDescriptorCatalog.getValidFunctionDescriptor(this.getFunctionName(), this.getArgumentsInternal(), functionArgumentArray, this.getHierarchyClauseArgumentsInternal(), functionArgumentArray2, 12, "UnknownOLAPFunction", validationContext);
        this.m_Arguments = functionArgumentArray;
        this.m_HierarchyArguments = functionArgumentArray2;
        validationContext.pop();
        this.setDataType(validationContext.getCurrentDataType());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        boolean bl = this.areComponentsComplete(this.getArgumentsInternal());
        if (null != this.getHierarchyClauseArgumentsInternal()) {
            bl &= this.areComponentsComplete(this.getHierarchyClauseArgumentsInternal());
        }
        return bl;
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitOLAPFunctionExpression(this, object);
    }

    public OLAPFunctionExpression(String string, FunctionArgument[] functionArgumentArray, FunctionArgument[] functionArgumentArray2) {
        OLAPFunctionExpression.validateValue(string);
        this.m_FunctionName = string;
        this.m_Arguments = OLAPFunctionExpression.getFunctionArgumentArrayClone(functionArgumentArray);
        this.m_HierarchyArguments = null == functionArgumentArray2 ? null : OLAPFunctionExpression.getFunctionArgumentArrayClone(functionArgumentArray2);
        this.initialize();
    }

    public OLAPFunctionExpression(String string, List<FunctionArgument> list, List<FunctionArgument> list2) {
        OLAPFunctionExpression.validateValue(string);
        this.m_FunctionName = string;
        this.m_Arguments = OLAPFunctionExpression.getFunctionArgumentArrayClone(list);
        this.m_HierarchyArguments = null == list2 ? null : OLAPFunctionExpression.getFunctionArgumentArrayClone(list2);
        this.initialize();
    }

    public OLAPFunctionExpression(String string, FunctionArgument[] functionArgumentArray) {
        this(string, functionArgumentArray, null);
    }

    public OLAPFunctionExpression(String string, FunctionArgument functionArgument) {
        this(string, new FunctionArgument[]{functionArgument});
    }

    public OLAPFunctionExpression(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2});
    }

    public OLAPFunctionExpression(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2, FunctionArgument functionArgument3) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2, functionArgument3});
    }

    public OLAPFunctionExpression(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2, FunctionArgument functionArgument3, FunctionArgument functionArgument4) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2, functionArgument3, functionArgument4});
    }

    public FunctionArgument[] getArguments() {
        return (FunctionArgument[])this.getArgumentsInternal().clone();
    }

    public boolean hasHierarchyClause() {
        return this.m_HierarchyArguments != null;
    }

    public FunctionArgument[] getHierarchyClauseArguments() {
        return (FunctionArgument[])this.getHierarchyClauseArgumentsInternal().clone();
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.m_FunctionDescriptor;
    }

    public String getFunctionName() {
        return this.m_FunctionName;
    }

    @Override
    public boolean isCompositeObject() {
        return true;
    }
}

