/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.SyntaxException;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;

public final class SQLDataType
extends SyntaxObject {
    private DataType m_DataType;
    private String m_SQLText;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
    }

    public SQLDataType(String string, DataType dataType) {
        this.m_SQLText = string;
        this.m_DataType = dataType;
    }

    public SQLDataType(String string) {
        SyntaxObject.validateValue(string);
        this.m_SQLText = string.toUpperCase();
        SQLDataType sQLDataType = SQLDataType.getSQLDataType(this.m_SQLText);
        this.m_DataType = sQLDataType.getDataType();
    }

    public SQLDataType(DataType dataType) {
        this.m_SQLText = dataType.getName();
        this.m_DataType = dataType;
    }

    public static SQLDataType getSQLDataType(String string) {
        SQLDataType sQLDataType = null;
        try {
            sQLDataType = (SQLDataType)SyntaxObject.fromSyntax("DATATYPE " + string, null);
        }
        catch (Exception exception) {
            throw new SyntaxException("UnknownDataType", string);
        }
        if (null == sQLDataType) {
            throw new SyntaxException("UnknownDataType", string);
        }
        return sQLDataType;
    }

    public static SQLDataType convertDMLDataType(String string) {
        String string2 = "";
        string2 = 0 == string.compareTo("NTEXT") ? "NVARCHAR2(100)" : (0 == string.compareTo("TEXT") ? "VARCHAR2" : (0 == string.compareTo("DATETIME") ? "DATE" : (0 == string.compareTo("SHORT") ? "BINARY_FLOAT" : (0 == string.compareTo("DECIMAL") ? "BINARY_DOUBLE" : (0 == string.compareTo("TIMESTAMP_TZ") ? "TIMESTAMP WITH TIME ZONE" : (0 == string.compareTo("TIMESTAMP_LTZ") ? "TIMESTAMP WITH LOCAL TIME ZONE" : (0 == string.compareTo("YMINTERVAL") ? "INTERVAL YEAR TO MONTH" : (0 == string.compareTo("DSINTERVAL") ? "INTERVAL DAY TO SECOND" : (0 == string.compareTo("INTEGER") ? "DECIMAL" : (0 == string.compareTo("BOOLEAN") ? "NUMBER(1)" : (0 == string.compareTo("SHORTINTEGER") || 0 == string.compareTo("LONGINTEGER") || 0 == string.compareTo("SHORTDECIMAL") ? "NUMBER" : string)))))))))));
        return SQLDataType.getSQLDataType(string2);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitSQLDataType(this, object);
    }

    public DataType getDataType() {
        return this.m_DataType;
    }

    public String getSQLText() {
        return this.m_SQLText;
    }
}

