/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax.hcsgen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.hcs.syntax.hcsgen.ArgumentOwnerState;
import oracle.hcs.syntax.hcsgen.CategoryState;
import oracle.hcs.syntax.hcsgen.GeneratorState;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

final class FunctionState
extends ArgumentOwnerState {
    public static final int SQL_ROW = 0;
    public static final int OLAP = 1;
    public static final int QUERY = 2;
    public static final int CONDITION = 3;
    public static final int AGGREGATION = 4;
    public static final int ALLOCATION = 5;
    public static final int FORECAST = 6;
    public static final int SQL_PSEUDO_COLUMN = 7;
    public static final int AGG_EXP = 8;
    private int m_Type = -1;
    boolean m_IsPseudoColumn = false;
    boolean m_HasHierarchyClause = false;
    List m_FunctionNames = new ArrayList();
    StringBuffer m_OuterBuffer = null;

    FunctionState(int n) {
        this.m_Type = n;
    }

    int getType() {
        return this.m_Type;
    }

    boolean isPseudoColumn() {
        return this.m_IsPseudoColumn;
    }

    boolean hasHierarchyClause() {
        return this.m_HasHierarchyClause;
    }

    void addFunctionName(String string, String string2, String string3) {
        this.m_FunctionNames.add(string);
        this.m_FunctionNames.add(string2);
        this.m_FunctionNames.add(string3);
        this.getGenerator().addFunction(string, string3);
    }

    @Override
    GeneratorState transition(String string, Attributes attributes) throws SAXException {
        if (this.getType() == 1 && "HIERARCHY_CLAUSE".equalsIgnoreCase(string)) {
            this.m_HasHierarchyClause = true;
            return this.getGenerator().HIERARCHY_CLAUSE;
        }
        if ("ADDITIONAL_FUNCTION".equalsIgnoreCase(string)) {
            return this.getGenerator().ADDITIONAL_FUNCTION;
        }
        return super.transition(string, attributes);
    }

    @Override
    void initialize(Attributes attributes) throws SAXException {
        super.initialize(attributes);
        String string = this.getAttributeValue("NAME", attributes, false).toUpperCase();
        String string2 = this.getAttributeValue("VARIABLE", attributes, false);
        if (null == string2) {
            string2 = string;
        }
        String string3 = this.getAttributeValue("TYPE", attributes, false);
        boolean bl = this.getBoolean("IsAWFunction", attributes);
        this.m_FunctionNames.clear();
        this.addFunctionName(string, string3, string2);
        this.m_IsPseudoColumn = this.getBoolean("IsPseudoColumn", attributes);
        this.m_HasHierarchyClause = false;
        this.m_OuterBuffer = this.getGenerator().getCurrentBuffer();
        this.getGenerator().setCurrentBuffer(new StringBuffer());
        this.incrementIndent();
        this.incrementIndent();
        this.appendLine(((CategoryState)this.getParent()).getCategory());
        this.append(",");
        this.printIsAWFunction(bl);
        if (this.m_IsPseudoColumn) {
            this.appendLine("true,");
        } else {
            this.appendLine("false,");
        }
        this.append(" /* is pseudo column */");
        this.appendLine("new FunctionDescriptorArgument[]");
        this.appendLine("{");
        this.incrementIndent();
    }

    @Override
    void exit() throws SAXException {
        this.decrementIndent();
        this.appendLine("}");
        if (!this.hasHierarchyClause()) {
            this.append(",");
            this.newLineAndIndent();
            this.append("null /* hierarchy clause */");
        }
        this.decrementIndent();
        this.decrementIndent();
        StringBuffer stringBuffer = this.getGenerator().getCurrentBuffer();
        this.getGenerator().setCurrentBuffer(this.m_OuterBuffer);
        Iterator iterator = this.m_FunctionNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)iterator.next();
            String string3 = (String)iterator.next();
            this.appendLine("/**");
            this.appendLine(" * A static constant <CODE>FunctionDescriptor</CODE> representing the function <CODE>");
            this.append(string);
            this.append("</CODE>.");
            this.appendLine(" */");
            this.appendLine("public final static FunctionDescriptor ");
            this.append(string3);
            this.append(" = ");
            this.incrementIndent();
            this.appendLine("new FunctionDescriptor(");
            this.incrementIndent();
            this.appendLine("\"");
            this.append(string);
            this.append("\",");
            this.appendLine("FunctionDescriptor.");
            this.append(this.getFunctionType());
            this.append(", ");
            if (null != string2) {
                this.appendLine("DataType.");
                this.append(string2);
            } else {
                this.appendLine("null /*DataType*/");
            }
            this.append(", ");
            this.append(stringBuffer.toString());
            this.append(");");
            this.decrementIndent();
            this.decrementIndent();
            this.newLine();
            this.getGenerator().addFunctionType(string, this.getFunctionType());
        }
    }

    private void printIsAWFunction(boolean bl) {
        switch (this.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                this.appendLine("true,");
                break;
            }
            case 0: 
            case 3: 
            case 7: 
            case 8: {
                if (bl) {
                    this.appendLine("true,");
                    break;
                }
                this.appendLine("false,");
            }
        }
        this.append(" /* is aw function */");
    }

    String getFunctionType() {
        switch (this.getType()) {
            case 0: {
                if (this.isPseudoColumn()) {
                    return "PSEUDO_COLUMN_FUNCTION";
                }
                return "ROW_FUNCTION";
            }
            case 3: {
                return "CONDITION_FUNCTION";
            }
            case 2: {
                return "QUERY_FUNCTION";
            }
            case 1: {
                if (this.hasHierarchyClause()) {
                    return "OLAP_HIER_FUNCTION";
                }
                return "OLAP_FUNCTION";
            }
            case 4: {
                return "AGGREGATION_FUNCTION";
            }
            case 5: {
                return "ALLOCATION_FUNCTION";
            }
            case 6: {
                return "FORECAST_FUNCTION";
            }
            case 8: {
                return "AGGREGATION_EXPRESSION_FUNCTION";
            }
        }
        throw new RuntimeException();
    }
}

