/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.hcs.syntaxbuilder.DelayedTask;

public class DelayedTimer
extends Thread {
    private long lastRun = Long.MAX_VALUE;
    private boolean checked = true;
    private boolean canceled = false;
    private boolean running = true;
    private final long waitTime;
    private final DelayedTask task;
    private static Logger LOG = Logger.getLogger(DelayedTimer.class.getName());

    public DelayedTimer(DelayedTask delayedTask, long l) {
        this.task = delayedTask;
        this.waitTime = l;
    }

    public synchronized void requestTask(boolean bl) {
        this.canceled = false;
        if (bl) {
            this.checked = false;
            this.lastRun = 0L;
            this.notify();
            return;
        }
        this.lastRun = System.currentTimeMillis();
        if (this.checked) {
            this.checked = false;
            this.notify();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.canceled = true;
                this.lastRun = System.currentTimeMillis();
                this.checked = true;
                this.worker();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                LOG.log(Level.FINER, String.format("Unhandled Exception in DelayedTimer for %s", this.task.getClass().getName()), throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void worker() throws InterruptedException {
        long l = 0L;
        long l2 = 0L;
        DelayedTimer delayedTimer = this;
        synchronized (delayedTimer) {
            while (this.running) {
                l = System.currentTimeMillis() - this.lastRun;
                if (this.canceled) {
                    this.canceled = false;
                    l2 = 0L;
                } else if (l >= this.waitTime && !this.checked) {
                    l2 = 0L;
                    this.checked = true;
                    this.task.doTask();
                } else {
                    l2 = this.waitTime - l;
                }
                this.wait(l2);
            }
        }
    }

    public synchronized void endTask() {
        this.canceled = true;
        this.running = false;
    }

    public synchronized void cancelTask() {
        this.canceled = true;
    }
}

