/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.sql.Connection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.table.Queries;
import oracle.hcs.util.JavaXMLBind;
import oracle.hcs.util.Version;
import oracle.javatools.db.DBException;

public class FeatureMap {
    private static FeatureMap instance;
    private static HashMap<String, HashMap<String, Boolean>> maps;
    private static Queries queries;
    private static final Logger LOG;
    private static final String XMLFILE = "/oracle/hcs/util/featureQueries.xml";
    private static final String QUERIES_PACKAGE = "oracle.hcs.table";
    private static final String DB_VERSION_QUERY = "dbVersion";

    private FeatureMap() {
    }

    public static synchronized FeatureMap getInstance() {
        if (instance == null) {
            instance = new FeatureMap();
        }
        return instance;
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = QUERIES_PACKAGE;
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        FeatureMap.queries = queries;
    }

    public boolean isSupported(String string, String string2) {
        Boolean bl;
        HashMap<String, Boolean> hashMap = maps.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.initialize(string, hashMap);
            maps.put(string, hashMap);
        }
        return (bl = hashMap.get(string2)) != null && bl != false;
    }

    private void initialize(String string, HashMap<String, Boolean> hashMap) {
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            String string2 = this.getQuery(DB_VERSION_QUERY);
            String string3 = dBUtil.executeOracleReturnOneCol(string2, null);
            Version version = new Version(string3);
            this.loadFeatures(version, hashMap);
        }
        catch (DBException dBException) {
            LOG.log(Level.SEVERE, dBException.getLocalizedMessage(), dBException);
        }
    }

    private void loadFeatures(Version version, HashMap<String, Boolean> hashMap) {
    }

    static {
        maps = new HashMap();
        LOG = Logger.getLogger(FeatureMap.class.getName());
    }
}

