/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.share.event.ListenerManager;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.view.SynonymFolderNode;
import oracle.hcs.db.view.SynonymNode;
import oracle.hcs.db.view.TableFolderNode;
import oracle.hcs.db.view.TableNode;
import oracle.hcs.db.view.ViewFolderNode;
import oracle.hcs.db.view.ViewNode;
import oracle.hcs.util.ObjectSelection;
import oracle.hcs.util.SelectionTree;
import oracle.hcs.util.SourceObjectTree;
import oracle.hcs.util.SourceSelectionDialog;

public class TreePicker
implements ItemPicker,
PropertyChangeListener {
    JTree tree;
    Component display = null;
    SourceSelectionDialog dialog;
    private ListenerManager m_manager = new ListenerManager();
    private ActionListener actionListener;
    DataFlavor nodeFlavor = new DataFlavor(DefaultMutableTreeNode.class, "Tree Node");
    private final DataFlavor[] flavors = new DataFlavor[]{this.nodeFlavor};
    private List<TreeNode> toRemove = new ArrayList<TreeNode>();
    private boolean singleSelection = false;
    private boolean disableMove = false;

    public TreePicker(JTree jTree, Component component, SourceSelectionDialog sourceSelectionDialog) {
        this(jTree, component, sourceSelectionDialog, false);
    }

    public TreePicker(JTree jTree, Component component, SourceSelectionDialog sourceSelectionDialog, boolean bl) {
        this.tree = jTree;
        this.display = component;
        this.dialog = sourceSelectionDialog;
        this.singleSelection = bl;
        jTree.addPropertyChangeListener(this);
        jTree.addMouseListener(new DoubleClickHandler());
        jTree.setDragEnabled(true);
        jTree.setTransferHandler(new DragAndDropHandler());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_manager.addListener((EventListener)propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_manager.removeListener((EventListener)propertyChangeListener);
    }

    public boolean isSelectableItemPresent() {
        if (this.disableMove) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        return defaultMutableTreeNode != null && defaultMutableTreeNode.getChildCount() > 0;
    }

    public boolean isItemSelected() {
        if (this.tree == null || this.tree.getSelectionPaths() == null) {
            return false;
        }
        if (this.disableMove) {
            return false;
        }
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (defaultMutableTreeNode != null && (defaultMutableTreeNode instanceof TableNode || defaultMutableTreeNode instanceof ViewNode || defaultMutableTreeNode instanceof SynonymNode)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void deselectAll() {
    }

    public boolean addInitialSelection(List<DefaultMutableTreeNode> list) {
        if (this.tree instanceof SourceObjectTree && list != null && list.size() > 0) {
            for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
                if (!(defaultMutableTreeNode.getUserObject() instanceof DatabaseSource)) continue;
                this.dialog.addColumns((DatabaseSource)defaultMutableTreeNode.getUserObject());
                ((SourceObjectTree)this.tree).addNode(defaultMutableTreeNode);
                if (!this.singleSelection) continue;
                break;
            }
            return true;
        }
        return false;
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        for (Transferable object : transferableArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            try {
                defaultMutableTreeNode = (DefaultMutableTreeNode)object.getTransferData(this.nodeFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            arrayList.add(defaultMutableTreeNode);
        }
        if (this.tree instanceof SourceObjectTree) {
            for (DefaultMutableTreeNode defaultMutableTreeNode : arrayList) {
                if (!(defaultMutableTreeNode.getUserObject() instanceof DatabaseSource)) continue;
                this.dialog.addColumns((DatabaseSource)defaultMutableTreeNode.getUserObject());
                ((SourceObjectTree)this.tree).addNode(defaultMutableTreeNode);
            }
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        if (this.tree instanceof SelectionTree) {
            for (DefaultMutableTreeNode defaultMutableTreeNode : arrayList) {
                SelectionTree selectionTree = (SelectionTree)this.tree;
                this.expandNodes(selectionTree, defaultMutableTreeNode);
                selectionTree.removeSelectionNode(defaultMutableTreeNode);
                selectionTree.addNode(defaultMutableTreeNode);
                defaultTreeModel.reload(defaultMutableTreeNode.getParent());
            }
        }
        if (this.singleSelection) {
            this.disableMove = false;
        }
        return true;
    }

    private void expandNodes(SelectionTree selectionTree, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        TreeNode treeNode = (TreeNode)selectionTree.getModel().getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode3 = selectionTree.findOwnerNode(defaultMutableTreeNode, treeNode);
        if (defaultMutableTreeNode3 != null) {
            this.expandNode(defaultMutableTreeNode3);
        }
        if ((defaultMutableTreeNode2 = this.getDirectParentNode(defaultMutableTreeNode3, defaultMutableTreeNode)) != null) {
            this.expandNode(defaultMutableTreeNode2);
        }
    }

    private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        if (this.tree.isCollapsed(treePath)) {
            this.tree.expandPath(treePath);
        }
    }

    private DefaultMutableTreeNode getDirectParentNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2 instanceof TableNode && defaultMutableTreeNode3 instanceof TableFolderNode) {
                return defaultMutableTreeNode3;
            }
            if (defaultMutableTreeNode2 instanceof ViewNode && defaultMutableTreeNode3 instanceof ViewFolderNode) {
                return defaultMutableTreeNode3;
            }
            if (!(defaultMutableTreeNode2 instanceof SynonymNode) || !(defaultMutableTreeNode3 instanceof SynonymFolderNode)) continue;
            return defaultMutableTreeNode3;
        }
        return null;
    }

    public void removeSelectedItems() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        for (TreeNode treeNode : this.toRemove) {
            defaultTreeModel.reload(treeNode);
        }
        this.tree.clearSelection();
        this.toRemove.clear();
        if (this.singleSelection) {
            this.disableMove = true;
        }
    }

    public void removeAllSelectableItems() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.reload();
        this.toRemove.clear();
    }

    private void visitAllNodes(DefaultMutableTreeNode defaultMutableTreeNode, List<ObjectSelection> list) {
        if (defaultMutableTreeNode instanceof TableNode || defaultMutableTreeNode instanceof ViewNode || defaultMutableTreeNode instanceof SynonymNode) {
            ObjectSelection objectSelection = new ObjectSelection(defaultMutableTreeNode);
            list.add(objectSelection);
            if (!this.toRemove.contains(defaultMutableTreeNode)) {
                this.toRemove.add(defaultMutableTreeNode);
            }
        }
        if (defaultMutableTreeNode.getChildCount() > 0) {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                this.visitAllNodes(defaultMutableTreeNode2, list);
            }
        }
    }

    public Transferable[] getSelectedItems() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        ArrayList<ObjectSelection> arrayList = new ArrayList<ObjectSelection>();
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (defaultMutableTreeNode2 == null) continue;
                ObjectSelection objectSelection = new ObjectSelection(defaultMutableTreeNode2);
                arrayList.add(objectSelection);
                if (!this.toRemove.contains(defaultMutableTreeNode2.getParent())) {
                    this.toRemove.add(defaultMutableTreeNode2.getParent());
                }
                if (!(this.tree instanceof SelectionTree)) continue;
                ((SelectionTree)this.tree).addSelectionNode(defaultMutableTreeNode2);
            }
        } else if (this.tree instanceof SourceObjectTree && (object = this.tree.getModel().getRoot()) != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)object).getChildCount() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
            ObjectSelection objectSelection = new ObjectSelection(defaultMutableTreeNode3);
            arrayList.add(objectSelection);
            if (!this.toRemove.contains(defaultMutableTreeNode3.getParent())) {
                this.toRemove.add(defaultMutableTreeNode3.getParent());
            }
        }
        return arrayList.toArray(new ObjectSelection[arrayList.size()]);
    }

    public Transferable[] getAllSelectableItems() {
        ArrayList<ObjectSelection> arrayList = new ArrayList<ObjectSelection>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        if (defaultMutableTreeNode != null) {
            this.visitAllNodes(defaultMutableTreeNode, arrayList);
        }
        return arrayList.toArray(new ObjectSelection[arrayList.size()]);
    }

    public DataFlavor[] getSelectionDataFlavors() {
        return this.flavors;
    }

    public boolean canAcceptFlavors(DataFlavor[] dataFlavorArray) {
        return true;
    }

    public Component getComponent() {
        return this.display != null ? this.display : this.tree;
    }

    public void disableMove() {
        this.disableMove = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Enumeration enumeration = this.m_manager.getListeners();
        if (enumeration != null) {
            propertyChangeEvent = new PropertyChangeEvent(this, "selection", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            while (enumeration.hasMoreElements()) {
                ((PropertyChangeListener)enumeration.nextElement()).propertyChange(propertyChangeEvent);
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void removeActionListener(ActionListener actionListener) {
    }

    class DragAndDropHandler
    extends TransferHandler {
        DragAndDropHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return transferSupport.isDataFlavorSupported(TreePicker.this.nodeFlavor);
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (!transferSupport.isDrop()) {
                return false;
            }
            JTree jTree = (JTree)transferSupport.getComponent();
            TreePicker treePicker = null;
            if (jTree instanceof SourceObjectTree) {
                treePicker = TreePicker.this.dialog.getFromPicker();
            } else if (jTree instanceof SelectionTree) {
                treePicker = TreePicker.this.dialog.getToPicker();
            }
            TreePicker.this.actionListener.actionPerformed(new ActionEvent(treePicker, 500, null, 16));
            return true;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            Transferable[] transferableArray = TreePicker.this.getSelectedItems();
            return transferableArray[0];
        }
    }

    class DoubleClickHandler
    extends MouseAdapter {
        DoubleClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                TreePicker.this.actionListener.actionPerformed(new ActionEvent(TreePicker.this, mouseEvent.getID(), null, mouseEvent.getModifiers()));
            }
        }
    }
}

