/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.history.LocalState;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.history.HistoryManagerImpl2;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.StringFactory;

public class LocalStateImpl2
extends LocalState
implements Comparable {
    static final String FIELD_SEPARATOR = "|";
    private final Integer _nodeId;
    private final Date _timestamp;
    private final URL _stateURL;
    private final String _description;
    private final String _key;
    private URL _dataURL;
    private int _hashcode = -1;
    private URL _nodeURL;
    private static Logger logger = Logger.getLogger(LocalStateImpl2.class.getName());
    private static final AssemblyFactory ASSEMBLY_FACTORY = new ObjectFactory(){

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            Integer nodeId = input.readInt();
            Date timestamp = new Date(input.readLong());
            String nodeUrlStr = (String)StringFactory.STRING_FACTORY.assemble(input);
            String stateUrlStr = (String)StringFactory.STRING_FACTORY.assemble(input);
            String description = (String)StringFactory.STRING_FACTORY.assemble(input);
            URL nodeUrl = URLFactory.newURL((String)nodeUrlStr);
            if (nodeUrl == null) {
                throw new NullPointerException("Invalid node URL spec: " + nodeUrlStr);
            }
            URL stateUrl = URLFactory.newURL((String)stateUrlStr);
            if (stateUrl == null) {
                throw new NullPointerException("Invalid state URL spec: " + stateUrlStr);
            }
            return new LocalStateImpl2(nodeId, timestamp, nodeUrl, stateUrl, description);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            LocalStateImpl2 state = (LocalStateImpl2)object;
            output.writeInt(state._nodeId);
            output.writeLong(state._timestamp.getTime());
            StringFactory.STRING_FACTORY.disassemble((Object)state._nodeURL.toString(), output);
            StringFactory.STRING_FACTORY.disassemble((Object)state._stateURL.toString(), output);
            StringFactory.STRING_FACTORY.disassemble((Object)state._description.toString(), output);
        }
    };

    static String asKey(Integer nodeId) {
        return String.valueOf(nodeId + FIELD_SEPARATOR);
    }

    static String asKey(Integer nodeId, URL url) {
        return nodeId.toString() + FIELD_SEPARATOR + url.toString() + FIELD_SEPARATOR;
    }

    static String asKey(Integer nodeId, URL url, Date timestamp) {
        return nodeId.toString() + FIELD_SEPARATOR + url.toString() + FIELD_SEPARATOR + String.valueOf(timestamp.getTime());
    }

    public LocalStateImpl2(Integer nodeId, Date timestamp, URL nodeURL, URL stateURL, String description) {
        if (nodeId == null) {
            throw new IllegalArgumentException("nodeId can't be null");
        }
        if (timestamp == null) {
            throw new IllegalArgumentException("timestamp can't be null");
        }
        if (stateURL == null) {
            throw new IllegalArgumentException("stateURL can't be null");
        }
        if (nodeURL == null) {
            nodeURL = stateURL;
        }
        if (description == null) {
            description = "";
        }
        this._nodeId = nodeId;
        this._timestamp = timestamp;
        this._nodeURL = nodeURL;
        this._stateURL = stateURL;
        this._description = description;
        this._key = LocalStateImpl2.asKey(nodeId, stateURL, timestamp);
    }

    public Date getDate() {
        return this._timestamp;
    }

    public Object getNodeId() {
        return this._nodeId;
    }

    public URL getNodeURL() {
        return this._nodeURL;
    }

    public URL getStateURL() {
        return this._stateURL;
    }

    public URL getDataURL() {
        if (this._dataURL == null) {
            URL url = URLFactory.newDirURL((String)(HistoryManagerImpl2.HISTORY_DIR + this._nodeId));
            this._dataURL = URLFactory.newFileURL((String)(url.getPath() + this._timestamp.getTime()));
        }
        return this._dataURL;
    }

    public String getDescription() {
        return this._description;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof LocalStateImpl2)) {
            return -1;
        }
        LocalStateImpl2 other = (LocalStateImpl2)obj;
        if (this._nodeId.equals(other._nodeId) && this._nodeURL.toString().equals(other._nodeURL.toString())) {
            return this._timestamp.compareTo(other._timestamp);
        }
        return this._nodeId - other._nodeId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalStateImpl2)) {
            return false;
        }
        LocalStateImpl2 other = (LocalStateImpl2)obj;
        return this._nodeId.equals(other._nodeId) && this._timestamp.equals(other._timestamp) && this._nodeURL.toString().equals(other._nodeURL.toString()) && this._stateURL.toString().equals(other._stateURL.toString());
    }

    public int hashCode() {
        if (this._hashcode == -1) {
            int seed = 851;
            this._hashcode = seed * this._nodeId.hashCode();
            this._hashcode = seed * this._hashcode + this._timestamp.hashCode();
            this._hashcode = seed * this._hashcode + this._nodeURL.hashCode();
            this._hashcode = seed * this._hashcode + this._stateURL.toString().hashCode();
        }
        return this._hashcode;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(super.toString()).append("[nodeId: ").append(this._nodeId).append(", timestamp: ").append(this._timestamp.getTime()).append(", nodeUrl: ").append(this._nodeURL).append(", stateUrl: ").append(this._stateURL).append(", dataUrl: ").append(this.getDataURL()).append(", description: ").append(this._description).append("]");
        return b.toString();
    }

    void setNodeUrl(URL nodeURL) {
        this._nodeURL = nodeURL;
    }

    String getKey() {
        return this._key;
    }

    URL createDataURL() {
        URLFileSystem.mkdirs((URL)URLFactory.newDirURL((String)(HistoryManagerImpl2.HISTORY_DIR + this._nodeId)));
        return this.getDataURL();
    }

    static byte[] disassemble(LocalStateImpl2 state) {
        try {
            return ASSEMBLY_FACTORY.disassemble((Object)state);
        }
        catch (AssemblyException e) {
            logger.log(Level.SEVERE, "An error occured while disassembling data, the record may be corrupted", e);
            return null;
        }
    }

    public static LocalStateImpl2 assemble(byte[] data) {
        try {
            return (LocalStateImpl2)ASSEMBLY_FACTORY.assemble(data);
        }
        catch (AssemblyException e) {
            logger.log(Level.SEVERE, "An error occured while assembling data, the record may be corrupted", e);
            return null;
        }
    }
}

