/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh;

import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.util.concurrent.Callable;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.ssh.SshSupportResources;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.javatools.dialogs.MessageDialog;

public class UserInfoImpl
implements UserInfo {
    private String mPassphrase;
    private String mPassword;

    private static String getAuthorization(final String string) {
        Worker<String> worker = new Worker<String>(){

            @Override
            public void run() {
                InputDialog inputDialog = new InputDialog();
                String string2 = inputDialog.show(SshSupportResources.getString("SSH_AUTHORIZATION_REQUIRED_TITLE"), string, null) ? inputDialog.getInputValue() : null;
                this.setResult(string2);
            }
        };
        String string2 = null;
        try {
            string2 = (String)worker.call();
        }
        catch (Exception exception) {
            Logger.severe(UserInfoImpl.class, (Throwable)exception);
        }
        return string2;
    }

    public String getPassphrase() {
        return this.mPassphrase;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public boolean promptPassword(String string) {
        this.mPassword = UserInfoImpl.getAuthorization(string);
        return this.mPassword != null;
    }

    public boolean promptPassphrase(String string) {
        this.mPassphrase = UserInfoImpl.getAuthorization(string);
        return this.mPassphrase != null;
    }

    public boolean promptYesNo(final String string) {
        Worker<Boolean> worker = new Worker<Boolean>(){

            @Override
            public void run() {
                this.setResult(MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)SshSupportResources.getString("SSH_AUTHORIZATION_TITLE"), null));
            }
        };
        boolean bl = false;
        try {
            bl = (Boolean)worker.call();
        }
        catch (Exception exception) {
            Logger.severe(UserInfoImpl.class, (Throwable)exception);
        }
        return bl;
    }

    public void showMessage(final String string) {
        Worker<Void> worker = new Worker<Void>(){

            @Override
            public void run() {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)SshSupportResources.getString("SSH_AUTHORIZATION_TITLE"), null);
            }
        };
        try {
            worker.call();
        }
        catch (Exception exception) {
            Logger.severe(UserInfoImpl.class, (Throwable)exception);
        }
    }

    private static abstract class Worker<V>
    implements Callable<V>,
    Runnable {
        private volatile V result;

        private Worker() {
        }

        protected void setResult(V v) {
            this.result = v;
        }

        @Override
        public V call() throws Exception {
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeAndWait(this);
            }
            return this.result;
        }
    }

    private static class InputDialog
    extends SimpleInputDialog {
        InputDialog() {
            super((Component)Ide.getMainWindow());
        }

        protected JTextComponent createInputComponent() {
            return new JPasswordField(15);
        }
    }
}

