/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.connections.OracleConnectionPanel;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.connections.OracleConnectionTypePanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.ssh.SshSupportResources;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.StoreListener;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.util.Pair;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;

public final class SSHConnectionPanel
extends JPanel
implements OracleConnectionTypePanel {
    public static final String SSH_HOST = "SshHost.NAME";
    public static final String SSH_TUNNEL = "SshTunnel.NAME";
    private static final OracleConnectionType SSH = OracleConnectionType.findType((String)"SSH");
    private OracleConnectionPanel mOwner;
    private Map<Pair<String, String>, PortForward> mTunnels = new HashMap<Pair<String, String>, PortForward>();
    private DefaultComboBoxModel<PortForward> mForwards = new DefaultComboBoxModel();
    private JComboBox<PortForward> mCmbForwards = new JComboBox<PortForward>(this.mForwards);
    private JButton mBtnAddHost = new JButton();
    private JRadioButton mRadSid = new JRadioButton();
    private JTextField mFldSid = new JTextField();
    private JRadioButton mRadSvc = new JRadioButton();
    private JTextField mFldSvc = new JTextField();
    private final Store mStore = Client.getInstance().getStore();

    private void createUI() {
        this.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, this.mCmbForwards, (String)SshSupportResources.getString("CONN_PANEL_SELECTOR"));
        this.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        this.add(this.mCmbForwards, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.mBtnAddHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.mBtnAddHost.setIcon(OracleIcons.getIcon((String)"add.png"));
        String string = SshSupportResources.getString("CONN_TOOLTIP_ADD");
        this.mBtnAddHost.setToolTipText(StringUtils.stripMnemonic((String)string));
        this.mBtnAddHost.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        IconicButtonUI.install((AbstractButton)this.mBtnAddHost);
        buttonGroup.add(this.mRadSid);
        this.mRadSid.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHConnectionPanel.this.markFieldEditable(SSHConnectionPanel.this.mFldSid, itemEvent.getStateChange() == 1);
            }
        });
        ResourceUtils.resButton((AbstractButton)this.mRadSid, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_SID"));
        this.markFieldEditable(this.mFldSid, false);
        this.add((Component)this.mRadSid, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.add((Component)this.mFldSid, LayoutControl.GBC.gbc((int)1, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        buttonGroup.add(this.mRadSvc);
        this.mRadSvc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHConnectionPanel.this.markFieldEditable(SSHConnectionPanel.this.mFldSvc, itemEvent.getStateChange() == 1);
            }
        });
        ResourceUtils.resButton((AbstractButton)this.mRadSvc, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_SERVICE"));
        this.markFieldEditable(this.mFldSvc, false);
        this.add((Component)this.mRadSvc, LayoutControl.GBC.gbc((int)0, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.add((Component)this.mFldSvc, LayoutControl.GBC.gbc((int)1, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.mRadSid.setSelected(true);
    }

    private void markFieldEditable(JTextField jTextField, boolean bl) {
        jTextField.setEditable(bl);
        jTextField.setBackground(bl ? Color.WHITE : Color.LIGHT_GRAY);
    }

    public void generateProperties(Properties properties) {
        PortForward portForward = (PortForward)this.mCmbForwards.getSelectedItem();
        if (portForward != null) {
            HostDescriptor hostDescriptor = portForward.getHost();
            TunnelDescriptor tunnelDescriptor = portForward.getTunnel();
            properties.setProperty(SSH_HOST, hostDescriptor.getName());
            properties.setProperty(SSH_TUNNEL, tunnelDescriptor.getName());
        }
        if (this.mRadSid.isSelected()) {
            properties.setProperty("sid", this.mFldSid.getText().trim());
        } else {
            properties.setProperty("serviceName", this.mFldSvc.getText().trim());
        }
        properties.remove("customUrl");
        properties.setProperty("OracleConnectionType", SSH.name());
    }

    public void clear() {
    }

    public void setDefaultPrompts() {
        this.mFldSid.setText("xe");
        this.mRadSid.setSelected(true);
    }

    public void updatePrompts(Properties properties) {
        Pair pair;
        PortForward portForward;
        String string = properties.getProperty("sid");
        this.mFldSid.setText(string);
        String string2 = properties.getProperty("serviceName");
        this.mFldSvc.setText(string2);
        if (ModelUtil.hasLength((String)string)) {
            this.mRadSid.setSelected(true);
        } else {
            this.mRadSvc.setSelected(true);
        }
        String string3 = properties.getProperty(SSH_HOST);
        String string4 = properties.getProperty(SSH_TUNNEL);
        if (string3 != null && string4 != null && (portForward = this.mTunnels.get(pair = new Pair((Object)string3, (Object)string4))) != null) {
            this.mCmbForwards.setSelectedItem(portForward);
        }
    }

    public Component getPanel() {
        if (this.getComponentCount() == 0) {
            this.createUI();
            this.populateHosts();
        }
        return this;
    }

    public OracleConnectionType getConnectionType() {
        return SSH;
    }

    public void setOwner(OracleConnectionPanel oracleConnectionPanel) {
        this.mOwner = oracleConnectionPanel;
    }

    private void populateHosts() {
        this.mStore.addStoreListener(new StoreListener(){});
        for (String string : this.mStore.listHosts()) {
            HostDescriptor hostDescriptor = this.mStore.getHostDescriptor(string);
            for (String string2 : this.mStore.listTunnels(string)) {
                TunnelDescriptor tunnelDescriptor = this.mStore.getTunnelDescriptor(string, string2);
                if (tunnelDescriptor.getType() != TunnelDescriptor.Type.LOCAL) continue;
                PortForward portForward = new PortForward(hostDescriptor, tunnelDescriptor);
                this.mTunnels.put((Pair<String, String>)new Pair((Object)string, (Object)string2), portForward);
                this.mForwards.addElement(portForward);
            }
        }
    }

    private static class PortForward {
        private final HostDescriptor mHost;
        private final TunnelDescriptor mTunnel;
        private final String mLabel;

        PortForward(HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor) {
            this.mHost = hostDescriptor;
            this.mTunnel = tunnelDescriptor;
            this.mLabel = MessageFormat.format("{0} ({1})", tunnelDescriptor.getName(), hostDescriptor.getName());
        }

        public String toString() {
            return this.mLabel;
        }

        public int hashCode() {
            return this.mLabel.hashCode();
        }

        public boolean equals(Object object) {
            return object == this || object instanceof PortForward && ModelUtil.areEqual((Object)this.mHost, (Object)((PortForward)object).mHost) && ModelUtil.areEqual((Object)this.mTunnel, (Object)((PortForward)object).mTunnel);
        }

        HostDescriptor getHost() {
            return this.mHost;
        }

        TunnelDescriptor getTunnel() {
            return this.mTunnel;
        }
    }
}

