/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc.entity;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Reflections;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.csv.CommaSeparatedValues;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityAccess;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.JDBCKey;
import oracle.dbtools.rt.jdbc.JDBCVersionNumber;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;

public class JDBCEntityMetaData<T extends TenantEntity> {
    private final JDBCEntityMetaData<?> childEntity;
    private final Column childEntityColumn;
    private final Class<T> entityType;
    private final JDBCEntityReader<T> reader;
    private final Table table;
    private final JDBCEntityWriter<T> writer;
    private static final Map<String, Column> METADATA_COLUMNS = JDBCEntityMetaData.columns(JDBCEntityMetaData.column("id", JDBCKey.class, "id"), JDBCEntityMetaData.column("security_group_id", JDBCKey.class, "tenantId"), JDBCEntityMetaData.column("created_by", String.class, "createdBy"), JDBCEntityMetaData.column("created_on", Timestamp.class, "created"), JDBCEntityMetaData.column("updated_by", String.class, "updatedBy"), JDBCEntityMetaData.column("updated_on", Timestamp.class, "updated"), JDBCEntityMetaData.column("row_version_number", JDBCVersionNumber.class, "version"));

    private JDBCEntityMetaData(Class<T> entityType, Table table, JDBCEntityReader<T> reader, JDBCEntityWriter<T> writer, JDBCEntityMetaData<?> childEntity, Column childEntityColumn) {
        this.entityType = entityType;
        this.table = table;
        this.reader = reader;
        this.writer = writer;
        this.childEntity = childEntity;
        this.childEntityColumn = childEntityColumn;
    }

    public JDBCEntityMetaData<?> childEntity() {
        return this.childEntity;
    }

    public Column childEntityColumn() {
        return this.childEntityColumn;
    }

    public Class<? extends TenantEntity> entityType() {
        return this.entityType;
    }

    public JDBCEntityReader<T> reader() {
        return this.reader;
    }

    public Table table() {
        return this.table;
    }

    public JDBCEntityWriter<T> writer() {
        return this.writer;
    }

    public static <T extends TenantEntity> Builder<T> builder(Class<T> entityType, String table, String label, TenantEntityAccess access) {
        return new Builder(entityType, table, label, access);
    }

    public static long internalTenantId() {
        return 10L;
    }

    public static TableProjection projection(Table table, String ... columns) {
        return new TableProjection(table, Iterables.iterable((Object[])columns));
    }

    static Iterable<String> allInsertColumns(Iterable<String> entityColumns) {
        ArrayList<String> all = new ArrayList<String>();
        Iterables.add(all, entityColumns);
        all.remove(0);
        all.remove(all.size() - 1);
        return all;
    }

    static Iterable<String> allUpdateColumns(Iterable<String> entityColumns) {
        ArrayList<String> all = new ArrayList<String>();
        Iterables.add(all, entityColumns);
        all.remove(0);
        all.remove(all.size() - 1);
        all.remove(all.size() - 3);
        all.remove(all.size() - 3);
        all.remove(all.size() - 3);
        return all;
    }

    private static Column column(String name, Class<?> type, String field) {
        return new Column(name, type, field);
    }

    private static Map<String, Column> columns(Column ... columns) {
        LinkedHashMap<String, Column> all = new LinkedHashMap<String, Column>();
        for (Column column : columns) {
            all.put(column.column(), column);
        }
        return all;
    }

    private static boolean isMetaDataColumn(String name) {
        return METADATA_COLUMNS.containsKey(name);
    }

    public static class TableProjection {
        private final List<String> columns = new ArrayList<String>();
        private final Table table;

        private TableProjection(Table table) {
            this(table, table.columnNames());
        }

        private TableProjection(Table table, Iterable<String> columns) {
            this.table = table;
            Iterables.add(this.columns, columns);
        }

        public Iterable<String> columns() {
            return this.columns;
        }

        public String label() {
            return this.table.label();
        }
    }

    public static class Table {
        private final TenantEntityAccess access;
        private final Map<String, Column> columns = new LinkedHashMap<String, Column>();
        private final String label;
        private final String name;
        private Column naturalKey;
        private Column parentColumn;
        private NaturalKeyScope naturalKeyScope = NaturalKeyScope.NONE;

        private Table(String name, String label, TenantEntityAccess access) {
            this.name = name;
            this.label = label;
            this.access = access;
        }

        public TenantEntityAccess access() {
            return this.access;
        }

        public TableProjection all() {
            return new TableProjection(this);
        }

        public Column column(String name) {
            Column c = this.columns.get(name);
            if (c == null) {
                throw new IllegalArgumentException(name);
            }
            return c;
        }

        public Iterable<String> columnNames() {
            return this.columns.keySet();
        }

        public String label() {
            return this.label;
        }

        public String name() {
            return this.name;
        }

        public Column parentColumn() {
            return this.parentColumn;
        }

        public Column naturalKey() {
            return this.naturalKey;
        }

        public NaturalKeyScope naturalKeyScope() {
            return this.naturalKeyScope;
        }
    }

    public static class Projections {
        private final List<TableProjection> projections = new ArrayList<TableProjection>();

        private Projections(Iterable<TableProjection> projections) {
            Iterables.add(this.projections, projections);
        }

        Iterable<TableProjection> projections() {
            return this.projections;
        }
    }

    public static interface JDBCEntityWriter<T extends TenantEntity>
    extends Transform<T, Map<String, Object>> {
    }

    public static interface JDBCEntityReader<T extends TenantEntity>
    extends Transform<ResultRow, T> {
    }

    public static class Column {
        private final String columnName;
        private final String entityField;
        private final Class<?> type;

        Column(String columnName, Class<?> type, String entityField) {
            this.columnName = columnName;
            this.type = type;
            this.entityField = entityField;
        }

        public String column() {
            return this.columnName;
        }

        public String field() {
            return this.entityField;
        }

        public Class<?> type() {
            return this.type;
        }
    }

    public static class Builder<T extends TenantEntity> {
        private JDBCEntityMetaData<?> childEntity;
        private Column childEntityColumn;
        private final Class<T> entityType;
        private JDBCEntityReader<T> reader;
        private final Table table;
        private JDBCEntityWriter<T> writer;

        private Builder(Class<T> entityType, String table, String label, TenantEntityAccess access) {
            this.entityType = entityType;
            this.table = new Table(table, label, access);
            Map.Entry id = (Map.Entry)Iterables.first(METADATA_COLUMNS.entrySet());
            this.table.columns.put(id.getKey(), id.getValue());
        }

        public JDBCEntityMetaData<T> build() {
            for (Map.Entry column : Iterables.subsequent(METADATA_COLUMNS.entrySet())) {
                this.table.columns.put(column.getKey(), column.getValue());
            }
            if (this.writer == null) {
                this.writer = new BaseWriter();
            }
            if (this.writer instanceof BaseWriter) {
                ((BaseWriter)this.writer).table(this.table);
            }
            if (this.reader == null) {
                this.reader = new BaseReader<T>(this.entityType);
            }
            if (this.reader instanceof BaseReader) {
                ((BaseReader)this.reader).projection(this.table.all());
            }
            JDBCEntityMetaData metadata = new JDBCEntityMetaData(this.entityType, this.table, this.reader, this.writer, this.childEntity, this.childEntityColumn);
            return metadata;
        }

        public Builder<T> child(JDBCEntityMetaData<?> childEntity, String childColumnName) {
            this.childEntity = childEntity;
            this.childEntityColumn = childEntity.table().column(childColumnName);
            return this;
        }

        public Builder<T> column(String column) {
            return this.column(column, String.class, NaturalKeyScope.NONE);
        }

        public Builder<T> column(String column, Class<?> type) {
            return this.column(column, type, NaturalKeyScope.NONE);
        }

        public Builder<T> column(String column, Class<?> type, NaturalKeyScope naturalKey) {
            return this.column(column, type, this.camelCase(column), naturalKey);
        }

        public Builder<T> column(String column, Class<?> type, String field) {
            return this.column(column, type, field, NaturalKeyScope.NONE);
        }

        public Builder<T> column(String column, Class<?> type, String field, NaturalKeyScope naturalKey) {
            Column c = new Column(column, type, field);
            this.table.columns.put(column, c);
            if (naturalKey != NaturalKeyScope.NONE) {
                this.table.naturalKeyScope = naturalKey;
                this.table.naturalKey = c;
            }
            return this;
        }

        public Builder<T> parentColumn(String name) {
            this.table.parentColumn = this.table.column(name);
            return this;
        }

        public Builder<T> reader(JDBCEntityReader<T> reader) {
            this.reader = reader;
            return this;
        }

        public Builder<T> writer(JDBCEntityWriter<T> writer) {
            this.writer = writer;
            return this;
        }

        private String camelCase(String column) {
            String[] segments = column.split("_");
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < segments.length; ++i) {
                String segment = segments[i];
                if (i > 0) {
                    b.append(Character.toUpperCase(segment.charAt(0)));
                    b.append(segment.substring(1));
                    continue;
                }
                b.append(segment);
            }
            return b.toString();
        }
    }

    public static class BaseWriter<T extends TenantEntity>
    implements JDBCEntityWriter<T> {
        private Table table;

        protected BaseWriter() {
        }

        public Map<String, Object> apply(T x) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            this.write(params, x);
            return params;
        }

        protected void unmappedColumn(Column column, Map<String, Object> params, T x) {
        }

        void table(Table table) {
            this.table = table;
        }

        private void write(Map<String, Object> params, Column column, Field field, Object value) {
            if (TenantIdentifier.class.isAssignableFrom(field.getType())) {
                this.write(params, column, (TenantIdentifier)value);
            } else if (Enum.class.isAssignableFrom(field.getType())) {
                this.writeEnum(params, column, (Enum)value);
            } else if (String[].class == field.getType() && String.class == column.type()) {
                value = CommaSeparatedValues.string((Object[])value);
                params.put(column.column(), value);
            } else {
                params.put(column.column(), value);
            }
        }

        private void write(Map<String, Object> params, Column column, TenantIdentifier value) {
            String firstParam = column.column();
            String secondParam = null;
            if ("id".equals(column.column())) {
                secondParam = "tenant_id";
            }
            this.write(params, value, firstParam, secondParam);
        }

        private void write(Map<String, Object> params, TenantIdentifier value, String firstParam, String secondParam) {
            if (value != null) {
                params.put(firstParam, JDBCIdentifiers.entityId(value));
                if (secondParam != null) {
                    params.put(secondParam, JDBCIdentifiers.id(value));
                }
            }
        }

        private void write(Map<String, Object> params, T x) {
            for (Column column : this.table.columns.values()) {
                if (JDBCEntityMetaData.isMetaDataColumn(column.column())) continue;
                String fieldName = column.field();
                if (NullOrEmpty.nullOrEmpty((CharSequence)fieldName)) {
                    this.unmappedColumn(column, params, x);
                    continue;
                }
                Class<?> clazz = x.getClass();
                try {
                    Field field = Reflections.field(clazz, (String)fieldName);
                    Object value = Reflections.fieldValue(x, (Field)field);
                    this.write(params, column, field, value);
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        private void writeEnum(Map<String, Object> params, Column column, Enum<?> value) {
            params.put(column.column(), value.name());
        }
    }

    public static class BaseReader<T extends TenantEntity>
    implements JDBCEntityReader<T> {
        private TableProjection projection;
        private int tenantIdIndex;
        private final Class<T> type;

        protected BaseReader(Class<T> type) {
            this.type = type;
        }

        public T apply(ResultRow x) {
            Table table = this.projection.table;
            TenantEntity instance = (TenantEntity)Reflections.newInstance(this.type);
            TenantIdentifier id = JDBCIdentifiers.valueOf(x, this.tenantIdIndex, 1);
            ColumnIterator columns = new ColumnIterator(x);
            columns.next();
            for (String c : this.projection.columns()) {
                Column column;
                String fieldName;
                if (JDBCEntityMetaData.isMetaDataColumn(c) || (fieldName = (column = table.column(c)).field()) == null) continue;
                try {
                    Field field = Reflections.field(this.type, (String)fieldName);
                    Class<?> fieldType = field.getType();
                    Object value = null;
                    if (fieldType == TenantIdentifier.class) {
                        value = JDBCIdentifiers.valueOf(columns, id);
                    } else {
                        value = columns.next();
                        value = BaseReader.massageValue(value, fieldType);
                    }
                    Reflections.fieldValue((Object)instance, (String)fieldName, (Object)value);
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
            }
            instance.id(id);
            columns.next();
            instance.metadata().createdBy((String)columns.next(String.class), this.readTimestamp(columns));
            instance.metadata().updatedBy((String)columns.next(String.class), this.readTimestamp(columns));
            instance.metadata().version((Number)columns.next(Number.class));
            return (T)this.entityRead(x, instance);
        }

        private static Object massageValue(Object value, Class<?> fieldType) {
            if (Enum.class.isAssignableFrom(fieldType)) {
                value = Enum.valueOf(fieldType, (String)value);
            } else if (value instanceof Number) {
                value = PrimitiveTypes.valueOf((Object)value, fieldType);
            } else if (String.class == fieldType && value instanceof Reader) {
                try {
                    value = StreamCopy.string((Readable)((Reader)value));
                }
                catch (IOException e) {
                    throw UnrecoverableException.unrecoverable((Throwable)e);
                }
            } else if (String[].class == fieldType && value instanceof String) {
                value = Text.commaDelimited((String)((String)value));
            }
            return value;
        }

        protected T entityRead(ResultRow row, T instance) {
            return instance;
        }

        protected long readTimestamp(ColumnIterator columns) {
            Timestamp ts = (Timestamp)columns.next(Timestamp.class);
            if (ts == null) {
                return 0L;
            }
            return ts.getTime();
        }

        void projection(TableProjection projection) {
            this.projection = projection;
            int columnCount = Iterables.size(projection.columns());
            int tenantIdOffset = METADATA_COLUMNS.size() - 2;
            this.tenantIdIndex = columnCount - tenantIdOffset;
        }
    }

    public static enum NaturalKeyScope {
        NONE,
        PARENT,
        TENANT;

    }
}

