/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.util.FormFields;
import oracle.dbtools.common.util.MissingFormFieldException;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

public class ApprovalRequest {
    private String clientId;
    private TenantIdentifier clientKey;
    private String clientSecret;
    private String description;
    private String email;
    private TenantIdentifier id;
    private TenantIdentifier pendingId;
    private String name;
    private String redirectUri;
    private ResponseType responseType = ResponseType.CODE;
    private final Set<Scope> scopes = new TreeSet<Scope>();
    private String state = null;
    private Status status = Status.PENDING;
    private String title;
    private String userId;

    private ApprovalRequest() {
    }

    public String clientId() {
        return this.clientId;
    }

    public TenantIdentifier clientKey() {
        return this.clientKey;
    }

    public ApprovalRequest clientKey(TenantIdentifier clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public ApprovalRequest clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ApprovalRequest description(String description) {
        this.description = description;
        return this;
    }

    public String email() {
        return this.email;
    }

    public ApprovalRequest email(String email) {
        this.email = email;
        return this;
    }

    public TenantIdentifier id() {
        return this.id;
    }

    public ApprovalRequest id(TenantIdentifier id) {
        this.id = id;
        return this;
    }

    public TenantIdentifier pendingId() {
        return this.pendingId;
    }

    public ApprovalRequest pendingId(TenantIdentifier id) {
        this.pendingId = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ApprovalRequest name(String name) {
        this.name = name;
        return this;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public ApprovalRequest redirectUri(String uri) {
        this.redirectUri = uri;
        return this;
    }

    public ResponseType responseType() {
        return this.responseType;
    }

    public Set<Scope> scopes() {
        return this.scopes;
    }

    public String state() {
        return this.state;
    }

    public ApprovalRequest state(String clientState) {
        this.state = clientState;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public ApprovalRequest status(Status status) {
        this.status = status;
        return this;
    }

    public String title() {
        return this.title;
    }

    public ApprovalRequest title(String title) {
        this.title = title;
        return this;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("ApprovalRequest [clientId=");
        builder2.append(this.clientId);
        builder2.append(", clientKey=");
        builder2.append(this.clientKey);
        builder2.append(", clientSecret=");
        builder2.append("******");
        builder2.append(", description=");
        builder2.append(this.description);
        builder2.append(", email=");
        builder2.append(this.email);
        builder2.append(", id=");
        builder2.append(this.id);
        builder2.append(", pendingId=");
        builder2.append(this.pendingId);
        builder2.append(", name=");
        builder2.append(this.name);
        builder2.append(", redirectUri=");
        builder2.append(this.redirectUri);
        builder2.append(", responseType=");
        builder2.append((Object)this.responseType);
        builder2.append(", scopes=");
        builder2.append(this.scopes);
        builder2.append(", state=");
        builder2.append(this.state);
        builder2.append(", status=");
        builder2.append((Object)this.status);
        builder2.append(", title=");
        builder2.append(this.title);
        builder2.append(", userId=");
        builder2.append(this.userId);
        builder2.append("]");
        return builder2.toString();
    }

    public String userId() {
        return this.userId;
    }

    public ApprovalRequest userId(String userId) {
        this.userId = userId;
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ApprovalRequest approvalRequest(RequestEntity request) {
        try {
            ApprovalRequest ar = new ApprovalRequest();
            FormFields formFields = Requests.formFields(request);
            String text = formFields.getRequiredField("response_type");
            ar.responseType = "token".equalsIgnoreCase(text) ? ResponseType.TOKEN : ("code".equalsIgnoreCase(text) ? ResponseType.CODE : ResponseType.UNKNOWN);
            ar.clientId = text = formFields.getRequiredField("client_id");
            text = (String)formFields.get((Object)"redirect_uri");
            if (text != null) {
                ar.redirectUri = text;
            }
            ar.state = text = formFields.getRequiredField("state");
            return ar;
        }
        catch (MissingFormFieldException e) {
            throw WebException.badRequest(e);
        }
    }

    public static ApprovalRequest approvalRequest(ResultRow row) {
        ApprovalRequest ar = new ApprovalRequest();
        ColumnIterator columns = new ColumnIterator(row);
        ar.id = JDBCIdentifiers.valueOf(columns);
        ar.userId = (String)columns.next(String.class);
        ar.clientKey = JDBCIdentifiers.valueOf(columns, ar.id);
        ar.status = Status.valueOf((String)columns.next(String.class));
        ar.name = (String)columns.next(String.class);
        ar.description = (String)columns.next(String.class);
        ar.responseType = ResponseType.valueOf((String)columns.next(String.class));
        ar.clientId = (String)columns.next(String.class);
        ar.clientSecret = (String)columns.next(String.class);
        ar.redirectUri = (String)columns.next(String.class);
        ar.email = (String)columns.next(String.class);
        ar.pendingId = JDBCIdentifiers.valueOf(columns, ar.id);
        ar.state = (String)columns.next(String.class);
        return ar;
    }

    public static Scope scope(String name, TenantIdentifier id) {
        Scope scope = new Scope(id);
        scope.name(name);
        return scope;
    }

    public static enum Status {
        APPROVED,
        DENIED,
        PENDING;

    }

    public static class Scope
    implements Comparable<Scope> {
        private String description;
        private final TenantIdentifier id;
        private String name;
        private String title;
        private static final Pattern PATTERN = Pattern.compile("^(-?\\d+\\.-?\\d+):(.+)");

        public Scope(TenantIdentifier id) {
            this.id = id;
        }

        @Override
        public int compareTo(Scope o) {
            return this.id.compareTo(o.id);
        }

        public String description() {
            return this.description;
        }

        public void description(String description) {
            this.description = description;
        }

        public TenantIdentifier id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public void name(String name) {
            this.name = name;
        }

        public String title() {
            return this.title;
        }

        public void title(String title) {
            this.title = title;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.id);
            builder.append(":");
            builder.append(this.name);
            return builder.toString();
        }
    }

    public static enum ResponseType {
        CODE,
        TOKEN,
        UNKNOWN;

    }

    public static class Builder {
        private final ApprovalRequest ar = new ApprovalRequest();

        private Builder() {
        }

        public ApprovalRequest build() {
            return this.ar;
        }

        public Builder clientId(String clientId) {
            this.ar.clientId = clientId;
            return this;
        }

        public Builder clientKey(TenantIdentifier clientKey) {
            this.ar.clientKey = clientKey;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.ar.clientSecret = clientSecret;
            return this;
        }

        public Builder description(String description) {
            this.ar.description = description;
            return this;
        }

        public Builder email(String email) {
            this.ar.email = email;
            return this;
        }

        public Builder id(TenantIdentifier id) {
            this.ar.id = id;
            return this;
        }

        public Builder name(String name) {
            this.ar.name = name;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.ar.redirectUri = redirectUri;
            return this;
        }

        public Builder responseType(ResponseType responseType) {
            this.ar.responseType = responseType;
            return this;
        }

        public Builder state(String state) {
            this.ar.state = state;
            return this;
        }

        public Builder status(Status status) {
            this.ar.status = status;
            return this;
        }

        public Builder title(String title) {
            this.ar.title = title;
            return this;
        }

        public Builder userId(String userId) {
            this.ar.userId = userId;
            return this;
        }

        public void scope(Scope scope) {
            this.ar.scopes.add(scope);
        }
    }

    public static enum AuthFlow {
        AUTH_TOKEN,
        CLIENT_CRED,
        IMPLICIT,
        PASSWORD,
        EXCHANGE,
        AUTH_CODE;

    }
}

