/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.HeaderCallback;
import oracle.dbtools.auth.SessionAuthenticatorBase;
import oracle.dbtools.auth.challenges.Challenges;
import oracle.dbtools.auth.challenges.ChallengesProvider;
import oracle.dbtools.auth.domain.IdentityDomain;
import oracle.dbtools.auth.domain.IdentityDomainCallback;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.plugin.api.security.AuthenticationChallenge;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.oauth.BearerTokenVerification;
import oracle.dbtools.rt.oauth.CompoundPrincipalCallback;
import oracle.dbtools.rt.oauth.OAuthProvider;
import oracle.dbtools.rt.oauth.ScopeAuthorizationPolicies;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

@Service(priority=3)
@Authenticates(value=AuthenticationRealm.RESOURCE_TEMPLATES)
public class BearerTokens
extends SessionAuthenticatorBase
implements RealmAuthenticator {
    public static final String BEARER = "Bearer";
    private static final Challenges _CHALLENGES = new ChallengesProvider(Iterables.empty());
    private static final AuthenticationChallenge UNKNOWN = _CHALLENGES.builder("Bearer").build();
    private static final String ERROR_INVALID_TOKEN = "invalid_token";
    private static final String ERROR_INSUFFICIENT_SCOPE = "insufficient_scope";
    private static final Translatable ERROR_INVALID_TOKEN_DESCRIPTION = new TranslatableMessage(ResourceTemplateMessages.class, "BearerTokens.0", "The provided token is expired, revoked, malformed, or invalid for other reasons", new Object[0]);
    private static final Translatable ERROR_INSUFFICENT_SCOPE_DESCRIPTION = new TranslatableMessage(ResourceTemplateMessages.class, "BearerTokens.1", "The provided token is not authorized to access this resource", new Object[0]);
    private static final AuthenticationChallenge INVALID_TOKEN = _CHALLENGES.builder("Bearer").error((CharSequence)"invalid_token", ERROR_INVALID_TOKEN_DESCRIPTION).build();
    private static final AuthenticationChallenge INSUFFICIENT_SCOPE = _CHALLENGES.builder("Bearer").error((CharSequence)"insufficient_scope", ERROR_INSUFFICENT_SCOPE_DESCRIPTION).build();

    public AuthenticationResult verify(CallbackHandler callbackHandler) {
        String token;
        HeaderCallback authorization = new HeaderCallback((CharSequence)HttpHeader.AUTHORIZATION.text());
        HeaderCallback p = new HeaderCallback((CharSequence)"X-APEX-PATH");
        CompoundPrincipalCallback cp = new CompoundPrincipalCallback();
        IdentityDomainCallback i = new IdentityDomainCallback();
        this.callback(callbackHandler, new Callback[]{authorization, p, cp, i});
        String path = p.getValue();
        CompoundPrincipal principal = cp.getPrincipal();
        IdentityDomain identityDomain = i.getIdentityDomain();
        String value = authorization.getValue();
        if (value != null && (token = BearerTokens.bearerToken(value)) != null) {
            TenantIdentifier scopeId = ScopeAuthorizationPolicies.scope(callbackHandler);
            if (scopeId == null) {
                return AuthenticationResult.publicResource();
            }
            for (OAuthProvider oauth : ServiceLocator.acquireAll(OAuthProvider.class, (String[])new String[0])) {
                try {
                    BearerTokenVerification verification = oauth.validateBearerToken(principal, scopeId, token);
                    switch (verification.status()) {
                        case UNKNOWN: {
                            break;
                        }
                        case EXPIRED: {
                            return AuthenticationResult.invalid((AuthenticationChallenge)INVALID_TOKEN);
                        }
                        case INSUFFICENT_AUTHORITY: {
                            return AuthenticationResult.notAuthorized((AuthenticationChallenge)INSUFFICIENT_SCOPE);
                        }
                        case VALID: {
                            return AuthenticationResult.valid((String)verification.user()).identityDomain(identityDomain).build();
                        }
                    }
                }
                catch (WebException e) {
                    if (HttpStatusCode.INTERNAL_SERVER_ERROR.equals(e.statusCode())) continue;
                    throw e;
                }
            }
            return AuthenticationResult.invalid((AuthenticationChallenge)INVALID_TOKEN);
        }
        return AuthenticationResult.unknown();
    }

    public static String bearerToken(RequestEntity request) {
        String bearerToken = null;
        EntityHeader authorization = request.headers().header(HttpHeader.AUTHORIZATION);
        if (authorization != null) {
            String value = authorization.value();
            bearerToken = BearerTokens.bearerToken(value);
        }
        return bearerToken;
    }

    private static String bearerToken(String value) {
        String bearerToken = null;
        if (value.toLowerCase().startsWith(BEARER.toLowerCase())) {
            bearerToken = value.substring(BEARER.length() + 1).trim();
        }
        return bearerToken;
    }
}

