/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.rt.resource.templates.cache.CachedResourceTemplateMatch;
import oracle.dbtools.rt.resource.templates.v2.ProtectedResourceTemplateMatch;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.uri.URITemplates;

class CachedResourceModule {
    private final ResourceModule module;
    private final Set<CachedResourceTemplateMatch> templates;

    private CachedResourceModule(Set<CachedResourceTemplateMatch> templates) {
        this.templates = templates;
        this.module = ((CachedResourceTemplateMatch)Iterables.first(templates)).module();
    }

    public Set<CachedResourceTemplateMatch> matches(String path) {
        String uriPrefix = this.module.uriPrefix();
        if (uriPrefix == null || path.startsWith(uriPrefix)) {
            return URITemplates.choose(this.templates, path);
        }
        return new TreeSet<CachedResourceTemplateMatch>();
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("CachedResourceModule [module=");
        builder2.append(this.module);
        builder2.append(", templates=");
        builder2.append(this.templates);
        builder2.append("]");
        return builder2.toString();
    }

    static class Builder {
        private final JDBCCallProvider jdbc;
        private final CompoundPrincipal principal;
        private final Set<CachedResourceTemplateMatch> templates;

        Builder(JDBCCallProvider jdbc, CompoundPrincipal principal) {
            this.jdbc = jdbc;
            this.principal = principal;
            this.templates = new LinkedHashSet<CachedResourceTemplateMatch>();
        }

        Builder add(ProtectedResourceTemplateMatch template) {
            this.templates.add(new CachedResourceTemplateMatch(this.jdbc, this.principal, template.module(), template.privilegeId(), template.template()));
            return this;
        }

        CachedResourceModule build() {
            return new CachedResourceModule(this.templates);
        }
    }
}

