/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.security.DefinersVersionedObject;
import oracle.aurora.rdbms.security.PolicyTableManager;
import oracle.aurora.rdbms.security.PolicyTableProxy;
import oracle.aurora.rdbms.security.PolicyTableQuery;
import oracle.aurora.rdbms.security.PolicyTableRow;
import oracle.aurora.rdbms.security.PolicyTableRows;
import oracle.aurora.rdbms.security.RowCache;
import oracle.aurora.rdbms.security.SchemaCodeSource;
import oracle.aurora.rdbms.security.SchemaPermissions;
import oracle.aurora.rdbms.security.TypeDescriptor;
import oracle.aurora.vm.Id;
import oracle.aurora.vm.IdManager;
import oracle.aurora.vm.IdNotFoundException;
import oracle.jdbc.driver.OracleDriver;

public class PolicyTable
extends Policy {
    static final String COLUMNS = "kind#, grantee#, type_schema#, type_name, name, action, status#, key";
    static final int KIND_COLUMN = 1;
    static final int SCHEMA_COLUMN = 2;
    static final int TYPE_SCHEMA_COLUMN = 3;
    static final int TYPE_NAME_COLUMN = 4;
    static final int NAME_COLUMN = 5;
    static final int ACTION_COLUMN = 6;
    static final int STATUS_COLUMN = 7;
    static final int KEY_COLUMN = 8;
    static final int LAST_COLUMN = 8;
    static final String KIND = "kind#";
    static final String SCHEMA = "grantee#";
    static final String TYPE_SCHEMA = "type_schema#";
    static final String TYPE_NAME = "type_name";
    static final String NAME = "name";
    static final String ACTION = "action";
    static final String STATUS = "status#";
    static final String KEY = "key";
    static final String[] columnNames = new String[]{"", "kind#", "grantee#", "type_schema#", "type_name", "name", "action", "status#", "key"};
    static final boolean[] isInt = new boolean[]{false, true, true, true, false, false, false, true, true};
    private static IdManager theManager;
    static Class jsPermissionClass;
    String tableName = "SYS.JAVA$POLICY$";
    private String sequenceName = "SYS.JAVA$POLICY$SEQUENCE$";
    private Map schemaCache;
    private Connection connection;
    private IdManager manager = theManager;
    private Collection all;
    private RowCache rowCache;
    private DefinersVersionedObject sharedRowCache = new DefinersVersionedObject(Schema.systemSchema, "JAVA$POLICY$SHARED", this.connection);
    private SQLException error;
    private String lastStatementString;
    private PreparedStatement lastStatement;
    boolean usingRowCache;
    private long timeStamp;
    private HashMap proxies;

    public static void initForHotLoading() {
        theManager = Schema.systemSchema;
        jsPermissionClass = Permission.class;
    }

    Connection connection() throws SQLException {
        if (this.connection == null) {
            this.connection = new OracleDriver().defaultConnection();
        }
        return this.connection;
    }

    static int debugLevel() {
        return PolicyTableManager.getDebugLevel();
    }

    public PolicyTable() throws SQLException {
        this.refresh(false);
    }

    private Id getId(String name) {
        Id id = null;
        try {
            id = this.manager.getId(name);
        }
        catch (IdNotFoundException idNotFoundException) {
            // empty catch block
        }
        return id;
    }

    String getTableName() {
        return this.tableName;
    }

    IdManager getManager() {
        return this.manager;
    }

    String getSequenceName() {
        return this.sequenceName;
    }

    PolicyTableProxy getProxy(Id schema) {
        PolicyTableProxy proxy = (PolicyTableProxy)this.proxies.get(schema);
        if (proxy == null) {
            final PolicyTable self = this;
            PolicyTableProxy.TableGetter getter = new PolicyTableProxy.TableGetter(){

                public PolicyTable table() {
                    return self;
                }
            };
            proxy = new PolicyTableProxy(schema, getter);
            this.proxies.put(schema, proxy);
        }
        return proxy;
    }

    PermissionCollection getPermissionsFor(Id schema) {
        return this.getSchemaPermissionsFor(schema);
    }

    synchronized SchemaPermissions getSchemaPermissionsFor(Id schema) {
        this.check();
        SchemaPermissions permissions = (SchemaPermissions)this.schemaCache.get(schema);
        if (permissions == null) {
            permissions = new SchemaPermissions(this, schema);
            this.schemaCache.put(schema, permissions);
        }
        return permissions;
    }

    PermissionCollection getPermissions(Id schema, Permission implicand) {
        return this.getSchemaPermissionsFor(schema).getTypePermissionsFor(implicand);
    }

    PermissionCollection getPermissions(SchemaCodeSource codeSource) {
        return this.getPermissionsFor(codeSource.getUser());
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection collection = codeSource instanceof SchemaCodeSource ? this.getPermissions((SchemaCodeSource)codeSource) : this.getPermissionsFor(Schema.publicSchema);
        return collection;
    }

    public void refresh() {
        this.refresh(true);
    }

    private synchronized void refresh(boolean alsoRefreshRowCache) {
        this.tick();
        this.all = null;
        this.rowCache = null;
        if (alsoRefreshRowCache && this.sharedRowCache != null) {
            this.sharedRowCache.refresh();
        }
        this.schemaCache = new HashMap();
        if (this.proxies == null) {
            this.proxies = new HashMap();
        }
        ++this.timeStamp;
    }

    synchronized SQLException getLastError() {
        return this.error;
    }

    synchronized SQLException getLastErrorAndClear() {
        SQLException result = this.error;
        this.error = null;
        return result;
    }

    synchronized void clearLastError() {
        this.error = null;
    }

    synchronized void noteError(SQLException error) {
        error.printStackTrace();
        this.error = error;
    }

    synchronized Iterator allRows() {
        if (this.all == null) {
            PolicyTableQuery allQuery = new PolicyTableQuery(this, "1 = 1", null, 0);
            PolicyTableRows iter = allQuery.rows();
            this.all = new LinkedList();
            while (iter.hasNext()) {
                PolicyTableRow r = iter.nextRow();
                this.all.add(r);
            }
        }
        return this.all.iterator();
    }

    synchronized RowCache getRowCache() {
        if (this.rowCache == null) {
            this.tick();
            if (this.sharedRowCache != null) {
                this.rowCache = (RowCache)this.sharedRowCache.get();
            }
            if (this.rowCache == null) {
                this.rowCache = this.computeRowCache();
            }
        }
        return this.rowCache;
    }

    private RowCache computeRowCache() {
        this.all = null;
        return new RowCache(this.allRows());
    }

    private void check() {
        if (this.tableHasChanged()) {
            this.refresh();
        }
    }

    boolean tableHasChanged() {
        return false;
    }

    long getTimeStamp() {
        if (!this.usingRowCache) {
            this.tick();
        }
        return this.timeStamp;
    }

    void tick() {
        ++this.timeStamp;
    }

    private void prepareUpdate() {
        if (this.sharedRowCache != null) {
            this.sharedRowCache.prepareForReplace();
        }
    }

    long insertRow(int kind, Id schema, TypeDescriptor type, String name, String action) {
        long key2;
        this.prepareUpdate();
        Statement statement = null;
        try {
            String insertCommand = "insert into " + this.tableName + "( " + COLUMNS + ") " + "values (?, ?, ?, ?, ?, ?, ?, " + this.sequenceName + ".nextval ) ";
            statement = this.connection().prepareStatement(insertCommand);
            statement.setInt(1, kind);
            statement.setLong(2, schema.getNumber());
            statement.setLong(3, type.getSchemaNumber());
            statement.setString(4, type.getName());
            statement.setString(5, name);
            statement.setString(6, action);
            statement.setInt(7, 2);
            Exec.insertRow((PreparedStatement)statement);
            statement.close();
            String seq = "select " + this.sequenceName + ".currval from dual";
            statement = this.connection().prepareStatement(seq);
            ResultSet r = Exec.query((PreparedStatement)statement);
            r.next();
            key2 = r.getLong(1);
            statement.close();
        }
        catch (SQLException ex) {
            this.noteError(ex);
            long key2 = -1L;
            throw new Error("Updater error on insert", ex);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ex) {}
            }
        }
        return key2;
    }

    long insertRow(int kind, Id schema, Id typeSchema, String typeName, String name, String action) {
        return this.insertRow(kind, schema, new TypeDescriptor(this, typeSchema, typeName), name, action);
    }

    boolean disableRow(long key) {
        this.prepareUpdate();
        boolean ok = true;
        Statement statement = null;
        try {
            String update = "update " + this.tableName + " set status# = " + 3 + " where " + KEY + " = " + key;
            statement = this.connection().createStatement();
            Exec.updateRow(statement, update);
        }
        catch (SQLException ex) {
            this.noteError(ex);
            ok = false;
            throw new Error("Updater disable failure", ex);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ex) {}
            }
        }
        return ok;
    }

    boolean enableRow(long key) {
        this.prepareUpdate();
        boolean ok = true;
        Statement statement = null;
        try {
            String update = "update " + this.tableName + " set status# = " + 2 + " where " + KEY + " = " + key;
            statement = this.connection().createStatement();
            Exec.updateRow(statement, update);
        }
        catch (SQLException ex) {
            this.noteError(ex);
            ok = false;
            throw new Error("Updater enable failure", ex);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ex) {}
            }
        }
        return ok;
    }

    boolean deleteRow(long key) {
        this.prepareUpdate();
        boolean ok = true;
        Statement statement = null;
        try {
            String del = "delete from " + this.tableName + " where " + KEY + " = " + key;
            statement = this.connection().createStatement();
            Exec.deleteRow(statement, del);
        }
        catch (SQLException ex) {
            this.noteError(ex);
            ok = false;
            throw new Error("Updater delete failure", ex);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ex) {}
            }
        }
        return ok;
    }

    void commit() {
        try {
            if (this.sharedRowCache != null) {
                RowCache r = this.computeRowCache();
                this.sharedRowCache.replace(r);
            }
            this.connection().commit();
            this.refresh();
        }
        catch (SQLException ex) {
            this.noteError(ex);
            throw new Error("Updater commit failure", ex);
        }
    }

    PolicyTableRows select(String where) {
        return new PolicyTableQuery(this, where, null, 0).rows();
    }

    boolean exists(String what) {
        return new PolicyTableQuery(this, what, null, 0).exists();
    }

    PolicyTableRows match(PolicyTableRow row, int flags) {
        return new PolicyTableQuery(this, this.makeWhere(row, flags), row, flags).rows();
    }

    boolean exists(PolicyTableRow row, int flags) {
        return new PolicyTableQuery(this, this.makeWhere(row, flags), row, flags).exists();
    }

    String makeWhere(PolicyTableRow row, int flags) {
        StringBuffer where = new StringBuffer();
        for (int x = 1; x <= 8; ++x) {
            if ((flags & 1 << x) == 0) continue;
            if (where.length() != 0) {
                where.append(" and ");
            }
            where.append(columnNames[x]);
            if (isInt[x] || row.getString(x) != null) {
                where.append(" = ? ");
                continue;
            }
            where.append(" is null ");
        }
        return where.toString();
    }

    static void output(String msg) {
        System.out.println(msg);
        System.out.flush();
    }

    private static class Exec {
        private Exec() {
        }

        private static void insertRow(PreparedStatement statement) throws SQLException {
            statement.executeUpdate();
        }

        static ResultSet query(PreparedStatement statement) throws SQLException {
            return statement.executeQuery();
        }

        private static void updateRow(Statement statement, String text) throws SQLException {
            statement.executeUpdate(text);
        }

        private static void deleteRow(Statement statement, String text) throws SQLException {
            statement.execute(text);
        }
    }
}

