/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.util.LinkedList;
import java.util.List;

public class Hint {
    String head;
    String queryBlock;
    List<String> elements;

    private Hint(String string, String string2, List<String> list) {
        this.head = string;
        this.queryBlock = string2;
        this.elements = list;
    }

    public static Hint parse(String string) {
        int n;
        if (string.startsWith("/*+")) {
            string = string.substring(3, string.length() - 2);
        }
        if ((n = (string = string.trim()).indexOf(40)) < 0) {
            return new Hint(string, null, null);
        }
        String string2 = string.substring(0, n).trim();
        String string3 = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string4 = string.substring(n + 1);
        while (true) {
            int n2;
            if ((n2 = string4.indexOf(32)) < 0) {
                n2 = string4.indexOf(41);
            }
            if (n2 < 0) break;
            String string5 = string4.substring(0, n2);
            string4 = string4.substring(n2 + 1);
            if (string5.startsWith("@")) {
                string3 = string5;
                continue;
            }
            linkedList.add(string5);
        }
        return new Hint(string2, string3, linkedList);
    }

    public boolean isModified(Hint hint) {
        if (this.head.startsWith("USE_") && !hint.head.startsWith("USE_")) {
            return false;
        }
        if (this.head.startsWith("LEADING") && !hint.head.startsWith("LEADING")) {
            return false;
        }
        if (this.head.startsWith("INDEX")) {
            return false;
        }
        if (this.queryBlock == null) {
            return hint.queryBlock == null;
        }
        if (!this.queryBlock.equals(hint.queryBlock)) {
            return false;
        }
        if (this.head.startsWith("USE_")) {
            return this.elements.get(0).equals(hint.elements.get(0));
        }
        return true;
    }

    public static void main(String[] stringArray) {
        Hint hint = Hint.parse("/*+ LEADING(@\"SEL$1\" \"D\"@\"SEL$1\" \"E\"@\"SEL$1\" \"C\"@\"SEL$1\") */");
        System.out.println(hint.elements.get(2));
        String string = "USE_NL(@\"SEL$1\" \"C\"@\"SEL$1\")";
        Hint hint2 = Hint.parse(string);
        String string2 = "USE_MERGE(@\"SEL$1\" \"C\"@\"SEL$1\")";
        Hint hint3 = Hint.parse(string2);
        String string3 = "USE_HASH(@\"SEL$1\" \"D\"@\"SEL$1\")";
        Hint hint4 = Hint.parse(string3);
        System.out.println(string + "=" + string2 + "   " + hint2.isModified(hint3));
        System.out.println(string + "=" + string3 + "   " + hint2.isModified(hint4));
    }
}

