/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.sqltuningadvisor;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JFrame;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningCommon;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningImplement;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningReport;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningTask;

public class SqlTuningAdvisor {
    private SqlTuningCommon m_sqlTuningCommon = null;
    private SqlTuningTask m_sqlTuningTask = null;
    private SqlTuningReport m_sqlTuningReport = null;
    private SqlTuningImplement m_sqlTuningImplement = null;
    private Hashtable<Integer, String[]> m_IndexesReport = new Hashtable();
    private Hashtable<Integer, String[]> m_StatisticsReport = new Hashtable();
    private Hashtable<Integer, String[]> m_ProfilesReport = new Hashtable();
    private Hashtable<Integer, String[]> m_RestructureSQLReport = new Hashtable();
    private ArrayList<String> m_IndexesSqlScript = null;
    private ArrayList<String> m_StatisticsSqlScript = null;
    private ArrayList<String> m_ProfilesSqlScript = null;
    private ArrayList<String> m_RestructureSqlScript = null;
    private ArrayList<String> m_AllSqlScript = null;

    public SqlTuningAdvisor() {
        this.initialize();
    }

    public void initialize() {
        this.m_sqlTuningCommon = new SqlTuningCommon(this);
        this.m_sqlTuningTask = new SqlTuningTask(this);
        this.m_sqlTuningReport = new SqlTuningReport(this);
        this.m_sqlTuningImplement = new SqlTuningImplement(this);
    }

    public boolean startSqlTuningAdvisor(Connection connection, String[] stringArray, String string) throws SQLException {
        if (stringArray.length == 1) {
            this.m_sqlTuningCommon.setSqlSetsCreation(false);
            this.m_sqlTuningCommon.checkForBindVariables(stringArray[0]);
        } else if (stringArray.length > 1) {
            this.m_sqlTuningCommon.setSqlSetsCreation(true);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.m_sqlTuningCommon.checkAndSetBindVariables(stringArray[i]);
            }
        }
        this.m_sqlTuningCommon.setConnection(connection);
        if (!this.m_sqlTuningCommon.getSqlSetsCreation()) {
            this.m_sqlTuningCommon.setSelectedSingleSQLScript(stringArray[0]);
            this.m_sqlTuningCommon.setOwnerName(string);
            this.m_sqlTuningCommon.sqlTuningNameResolver(this.m_sqlTuningTask.getAllTuningTaskNames());
            this.m_sqlTuningTask.createSqlTuningTask();
            this.m_sqlTuningTask.executeSQLTuningTask();
            this.m_sqlTuningTask.checkForTaskCompletion();
            this.m_sqlTuningReport.getClobObject();
            this.m_sqlTuningReport.getAllSqlTuningReport();
            this.runAllSQLScriptTask();
        } else {
            this.m_sqlTuningCommon.setSelectedSQLScriptsForSqlSets(stringArray);
            this.m_sqlTuningTask.executeSQLSqlScriptsForSqlId();
            this.m_sqlTuningCommon.setOwnerName(string);
            this.m_sqlTuningCommon.sqlSetNameResolver(this.m_sqlTuningTask.getAllSqlSetNames());
            this.m_sqlTuningTask.createSQLTuningSet();
            this.m_sqlTuningTask.loadSQLTuningSet();
            this.m_sqlTuningCommon.sqlTuningNameResolver(this.m_sqlTuningTask.getAllTuningTaskNames());
            this.m_sqlTuningTask.createSqlSetTuningTask();
            this.m_sqlTuningTask.executeSQLTuningTask();
            this.m_sqlTuningTask.checkForTaskCompletion();
            this.m_sqlTuningReport.getClobObject();
            this.m_sqlTuningReport.getAllSqlTuningReport();
            this.runAllSQLScriptTask();
        }
        return true;
    }

    public Connection setupTempConnection() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521:orcl", "XWEEK", "xweek");
        return connection;
    }

    public void runAllSQLScriptTask() {
        this.setSqlTuningAdvisorAllSqlScripts(this.m_sqlTuningImplement.getAllSqlTuningImplementScript());
        this.setSqlTuningAdvisorIndexesSqlScript(this.m_sqlTuningImplement.getSqlTuningImplementScript("INDEXES"));
        this.setSqlTuningAdvisorStatisticsSqlScript(this.m_sqlTuningImplement.getSqlTuningImplementScript("STATISTICS"));
        this.setSqlTuningAdvisorProfilesSqlScript(this.m_sqlTuningImplement.getSqlTuningImplementScript("PROFILES"));
        this.setSqlTuningAdvisorRestructureSqlScript(null);
    }

    public SqlTuningCommon getSqlTuningCommon() {
        return this.m_sqlTuningCommon;
    }

    public SqlTuningTask getSqlTuningTask() {
        return this.m_sqlTuningTask;
    }

    public SqlTuningReport getSqlTuningReport() {
        return this.m_sqlTuningReport;
    }

    public SqlTuningImplement getSqlTuningImplement() {
        return this.m_sqlTuningImplement;
    }

    public String[][] convertHashtableToString(Hashtable<Integer, String[]> hashtable) {
        String[][] stringArray = new String[hashtable.size()][3];
        if (hashtable == null) {
            return null;
        }
        Set<Integer> set = hashtable.keySet();
        int n = 0;
        Iterator<Integer> iterator = set.iterator();
        while (iterator.hasNext()) {
            String[] stringArray2 = hashtable.get(iterator.next());
            stringArray[n][0] = stringArray2[0];
            stringArray[n][1] = stringArray2[1];
            stringArray[n][2] = stringArray2[2];
            ++n;
        }
        return stringArray;
    }

    public Hashtable<Integer, String[]> getSqlTuningAdvisorIndexesReport() {
        return this.m_IndexesReport;
    }

    public String[][] getSqlTuningAdvisorIndexesReportArray() {
        return this.convertHashtableToString(this.m_IndexesReport);
    }

    public void setSqlTuningAdvisorIndexesReport(Hashtable<Integer, String[]> hashtable) {
        this.m_IndexesReport = hashtable;
    }

    public Hashtable<Integer, String[]> getSqlTuningAdvisorStatisticsReport() {
        return this.m_StatisticsReport;
    }

    public String[][] getSqlTuningAdvisorStatisticsReportArray() {
        return this.convertHashtableToString(this.m_StatisticsReport);
    }

    public void setSqlTuningAdvisorStatisticsReport(Hashtable<Integer, String[]> hashtable) {
        this.m_StatisticsReport = hashtable;
    }

    public Hashtable<Integer, String[]> getSqlTuningAdvisorProfilesReport() {
        return this.m_ProfilesReport;
    }

    public String[][] getSqlTuningAdvisorProfilesReportArray() {
        String[][] stringArray = this.convertHashtableToString(this.m_ProfilesReport);
        Hashtable<Integer, String[]> hashtable = new Hashtable<Integer, String[]>();
        int n = stringArray.length;
        String[] stringArray2 = new String[3];
        if (n == 0) {
            return null;
        }
        stringArray2[0] = stringArray[0][0];
        stringArray2[1] = stringArray[0][1];
        stringArray2[2] = stringArray[0][2];
        hashtable.put(new Integer(0), stringArray2);
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                stringArray2 = new String[3];
                for (int j = 0; j < i; ++j) {
                    if (stringArray[j][0].equals(stringArray[i][0]) || stringArray[j][1].equals(stringArray[i][1]) || stringArray[j][2].equals(stringArray[i][2])) continue;
                    stringArray2[0] = stringArray[i][0];
                    stringArray2[1] = stringArray[i][1];
                    stringArray2[2] = stringArray[i][2];
                    hashtable.put(new Integer(i), stringArray2);
                }
            }
        }
        return this.convertHashtableToString(hashtable);
    }

    public void setSqlTuningAdvisorProfilesReport(Hashtable<Integer, String[]> hashtable) {
        this.m_ProfilesReport = hashtable;
    }

    public Hashtable<Integer, String[]> getSqlTuningAdvisorRestructuresSQLReport() {
        return this.m_RestructureSQLReport;
    }

    public String[][] getSqlTuningAdvisorRestructuresSQLReportArray() {
        return this.convertHashtableToString(this.m_RestructureSQLReport);
    }

    public void setSqlTuningAdvisorRestructuresSQLReport(Hashtable<Integer, String[]> hashtable) {
        this.m_RestructureSQLReport = hashtable;
    }

    public String getStatisticsReport() {
        return this.m_sqlTuningReport.printSqlTuningAdvisorStatisticsReport();
    }

    public String getIndexesReport() {
        return this.m_sqlTuningReport.printSqlTuningAdvisorIndexesReport();
    }

    public String getSQLProfilesReport() {
        return this.m_sqlTuningReport.printSqlTuningAdvisorProfilesReport();
    }

    public String getRestructureSQLReport() {
        return this.m_sqlTuningReport.printSqlTuningAdvisorRestructuresSQLReport();
    }

    public String getDetailedReport() {
        return this.m_sqlTuningReport.getAllSummaryReport();
    }

    public String[][] getAllTableReport() {
        int n;
        int n2;
        String[][] stringArray = this.getSqlTuningAdvisorIndexesReportArray();
        String[][] stringArray2 = this.getSqlTuningAdvisorStatisticsReportArray();
        String[][] stringArray3 = this.getSqlTuningAdvisorProfilesReportArray();
        String[][] stringArray4 = this.getSqlTuningAdvisorRestructuresSQLReportArray();
        int n3 = 0;
        int n4 = 0;
        if (stringArray != null) {
            n4 = stringArray.length;
        }
        if (stringArray2 != null) {
            n4 += stringArray2.length;
        }
        if (stringArray3 != null) {
            n4 += stringArray3.length;
        }
        if (stringArray4 != null) {
            n4 += stringArray4.length;
        }
        String[][] stringArray5 = new String[n4][3];
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                for (n = 0; n < stringArray[n2].length; ++n) {
                    stringArray5[n2][n] = stringArray[n2][n];
                }
            }
            n3 = stringArray.length;
        }
        if (stringArray2 != null) {
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                for (n = 0; n < stringArray2[n2].length; ++n) {
                    stringArray5[n3][n] = stringArray2[n2][n];
                }
                ++n3;
            }
        }
        if (stringArray3 != null) {
            for (n2 = 0; n2 < stringArray3.length; ++n2) {
                for (n = 0; n < stringArray3[n2].length; ++n) {
                    stringArray5[n3][n] = stringArray3[n2][n];
                }
                ++n3;
            }
        }
        if (stringArray4 != null) {
            for (n2 = 0; n2 < stringArray4.length; ++n2) {
                for (n = 0; n < stringArray4[n2].length; ++n) {
                    stringArray5[n3][n] = stringArray4[n2][n];
                }
                ++n3;
            }
        }
        return stringArray5;
    }

    public void setSqlTuningAdvisorIndexesSqlScript(ArrayList<String> arrayList) {
        this.m_IndexesSqlScript = arrayList;
    }

    public ArrayList<String> getSqlTuningAdvisorIndexesSqlScript() {
        return this.m_IndexesSqlScript;
    }

    public void setSqlTuningAdvisorStatisticsSqlScript(ArrayList<String> arrayList) {
        this.m_StatisticsSqlScript = arrayList;
    }

    public ArrayList<String> getSqlTuningAdvisorStatisticsSqlScript() {
        return this.m_StatisticsSqlScript;
    }

    public void setSqlTuningAdvisorProfilesSqlScript(ArrayList<String> arrayList) {
        this.m_ProfilesSqlScript = arrayList;
    }

    public ArrayList<String> getSqlTuningAdvisorProfilesSqlScript() {
        return this.m_ProfilesSqlScript;
    }

    public void setSqlTuningAdvisorRestructureSqlScript(ArrayList<String> arrayList) {
        this.m_RestructureSqlScript = arrayList;
    }

    public ArrayList<String> getSqlTuningAdvisorRestructureSqlScript() {
        return this.m_RestructureSqlScript;
    }

    public void setSqlTuningAdvisorAllSqlScripts(ArrayList<String> arrayList) {
        this.m_AllSqlScript = arrayList;
    }

    public ArrayList<String> getSqlTuningAdvisorAllSqlScripts() {
        return this.m_AllSqlScript;
    }

    public static void main(String[] stringArray) throws Exception {
        JFrame jFrame = new JFrame("SQL Tuning Advisor");
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

