/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.adf.share.ADFContext;
import oracle.adf.share.ADFShareException;
import oracle.adf.share.Environment;
import oracle.adf.share.MetadataEnvironmentThread;
import oracle.adf.share.logging.ADFLogger;

public class MetadataEnvironmentShell {
    public static MetadataEnvironmentShell current() {
        Thread t = Thread.currentThread();
        if (t instanceof MetadataEnvironmentThread) {
            return ((MetadataEnvironmentThread)t).getMetadataEnvironmentShell();
        }
        return null;
    }

    public static <T> T getVariable(Variable<T> variable) {
        Thread t = Thread.currentThread();
        if (t instanceof MetadataEnvironmentThread) {
            return ((MetadataEnvironmentThread)t).get(variable);
        }
        return null;
    }

    public static <T> boolean isVariableSet(Variable<T> variable) {
        Thread t = Thread.currentThread();
        if (t instanceof MetadataEnvironmentThread) {
            return ((MetadataEnvironmentThread)t).isSet(variable);
        }
        return false;
    }

    protected MetadataEnvironmentThread.Resources newThreadResources() {
        return new ThreadResources();
    }

    protected MetadataEnvironmentThread newThread(Variables variables, ThreadGroup group, Runnable target, String name, long stackSize) {
        return new MetadataEnvironmentThread(this, variables, group, target, name, stackSize);
    }

    private static <V> Callable<V> callable(final Callable<V> operation, final MetadataEnvironmentThread.Resources resources) {
        return new Callable<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V call() throws Exception {
                if (resources != null) {
                    resources.initializeResources();
                }
                boolean succeeded = false;
                try {
                    Object r = operation.call();
                    succeeded = true;
                    Object v = r;
                    return v;
                }
                finally {
                    if (resources != null) {
                        if (succeeded) {
                            resources.finalizeResources();
                        } else {
                            try {
                                resources.finalizeResources();
                            }
                            catch (Throwable t) {
                                ADFLogger logger = ADFLogger.createADFLogger(MetadataEnvironmentThread.class);
                                logger.severe(t);
                            }
                        }
                    }
                }
            }
        };
    }

    public Future<?> execute(Runnable task) {
        return this.execute(task, null);
    }

    public Future<?> execute(Runnable task, Variables variables) {
        if (task == null) {
            throw new IllegalArgumentException("Invalid task: null.");
        }
        return this.execute(Executors.callable(task), variables);
    }

    public <V> Future<V> execute(Callable<V> task) {
        return this.execute(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Future<V> execute(Callable<V> task, Variables variables) {
        if (task == null) {
            throw new IllegalArgumentException("Invalid task: null.");
        }
        DefaultThreadFactory dtf = new DefaultThreadFactory(this, variables);
        MetadataEnvironmentThread.Resources resources = this.newThreadResources();
        ExecutorService es = Executors.newSingleThreadExecutor(dtf);
        try {
            Future<V> future = es.submit(MetadataEnvironmentShell.callable(task, resources));
            return future;
        }
        finally {
            es.shutdown();
        }
    }

    public <V> V call(Callable<V> task) throws ExecutionException {
        return this.call(task, null);
    }

    public <V> V call(Callable<V> task, Variables variables) throws ExecutionException {
        Future<V> r = this.execute(task, variables);
        try {
            return r.get();
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ADFShareException(t);
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final MetadataEnvironmentShell shell;
        private final Variables variables;

        DefaultThreadFactory(MetadataEnvironmentShell shell, Variables variables) {
            this.shell = shell;
            this.variables = variables;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "MetadataEnvironmentThread-" + poolNumber.getAndIncrement() + "-";
        }

        @Override
        public Thread newThread(Runnable r) {
            MetadataEnvironmentThread t = this.shell.newThread(this.variables, this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    protected class ThreadResources
    extends MetadataEnvironmentThread.Resources {
        private final Object adfcContext;
        private ADFContext oldAdfContext;

        protected ThreadResources() {
            ADFContext adfc = ADFContext.getCurrent();
            Environment env = adfc.getEnvironment();
            this.adfcContext = env != null ? env.getContext() : null;
        }

        @Override
        public void initializeResources() {
            this.initializeAdfContext();
        }

        protected void initializeAdfContext() {
            this.oldAdfContext = ADFContext.initADFContext(this.adfcContext, null, null, null);
        }

        @Override
        public void finalizeResources() {
            this.finalizeAdfContext();
        }

        protected void finalizeAdfContext() {
            if (this.oldAdfContext != null) {
                ADFContext.resetADFContext(this.oldAdfContext);
            }
        }
    }

    public static class Variables {
        private final HashMap<Variable, Object> values;

        public <T> Variables(Variable<T> var, T value) {
            this.values = new HashMap(1);
            this.put(var, value);
        }

        private Variables(Variables vars) {
            this.values = new HashMap<Variable, Object>(vars.values);
        }

        private void put(Variable var, Object value) {
            if (var == null) {
                throw new IllegalArgumentException("Invalid variable: null.");
            }
            if (var.prohibitsNullValue() && value == null) {
                throw new IllegalArgumentException("Invalid variable value: null.");
            }
            this.values.put(var, value);
        }

        public <T> T get(Variable<T> var) {
            return (T)this.values.get(var);
        }

        public <T> void set(Variable<T> var, T value) {
            this.put(var, value);
        }

        public boolean contains(Variable var) {
            return this.values.containsKey(var);
        }

        public static Variables copy(Variables vars) {
            return vars == null ? null : new Variables(vars);
        }
    }

    public static class Variable<T> {
        private final boolean prohibitsNullValue;

        public Variable() {
            this.prohibitsNullValue = false;
        }

        public Variable(boolean prohibitsNullValue) {
            this.prohibitsNullValue = prohibitsNullValue;
        }

        public final boolean prohibitsNullValue() {
            return this.prohibitsNullValue;
        }
    }
}

