/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import javax.naming.StringRefAddr;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.util.ADFElHelper;
import oracle.adf.share.logging.ADFLogger;

public class StringELRefAddr
extends StringRefAddr {
    private static final long serialVersionUID = 1L;
    private boolean isEL = false;
    private static final ADFLogger mLogger = ADFLogger.createADFLogger((String)StringELRefAddr.class.getName());

    public StringELRefAddr(String addrType, String addr) {
        super(addrType, addr);
    }

    public Object getRawContent() {
        return super.getContent();
    }

    @Override
    public Object getContent() {
        String content;
        block3: {
            content = (String)super.getContent();
            try {
                if (this.isEL || ADFElHelper.isElExpression((String)content)) {
                    this.isEL = true;
                    ADFContext aDFContext = ADFContext.getCurrent();
                    content = (String)aDFContext.getExpressionEvaluator().evaluate(content);
                }
            }
            catch (Exception e) {
                if (!StringELRefAddr.getLogger().isFine()) break block3;
                StringELRefAddr.getLogger().fine("Exception trying to getContent", (Throwable)e);
            }
        }
        return content;
    }

    private static ADFLogger getLogger() {
        return mLogger;
    }

    public static Object checkAndResolveExpression(String expression) {
        block3: {
            try {
                if (expression != null && ADFElHelper.isElExpression((String)expression)) {
                    return ADFContext.getCurrent().getExpressionEvaluator().evaluate(expression);
                }
            }
            catch (Exception e) {
                if (!StringELRefAddr.getLogger().isFine()) break block3;
                StringELRefAddr.getLogger().fine("Exception trying to getContent", (Throwable)e);
            }
        }
        return expression;
    }
}

