/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.sandbox;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import oracle.adf.share.sandbox.MetadataRevision;
import oracle.adf.share.sandbox.MetadataRevisionNoteURI;
import oracle.adf.share.sandbox.MetadataRevisionSupport;

public class MetadataRevisionPortable
extends MetadataRevision {
    private static final String PREFIX = "mdrev:";
    private static final String ENC = "UTF-8";

    MetadataRevisionPortable(MetadataRevision revision) {
        super(revision.getId(), revision.getHostId(), MetadataRevisionPortable.getLocalHostId());
    }

    private MetadataRevisionPortable(String revisionId, String hostId, String fromHostId) {
        super(revisionId, hostId, fromHostId);
    }

    public boolean exists() {
        return MetadataRevisionSupport.getInstance().exists(this);
    }

    public void publish(String noteURI) {
        if (this.exists()) {
            throw new IllegalStateException("This metadata revision exists in the local host: " + this);
        }
        MetadataRevisionSupport.getInstance().publish(this, noteURI);
    }

    public void publish(MetadataRevisionNoteURI noteURI) {
        this.publish(noteURI == null ? null : noteURI.toString());
    }

    public boolean isEligibleForUnpublish() {
        return MetadataRevisionSupport.getInstance().isEligibleForUnpublish(this);
    }

    public boolean unpublish() {
        return MetadataRevisionSupport.getInstance().unpublish(this);
    }

    public String toString() {
        return MetadataRevisionPortable.encode(this.getId(), this.getHostId(), this.getFromHostId());
    }

    private static void parseError(String reason, String str) {
        throw new IllegalArgumentException("Invalid textual representation of " + MetadataRevisionPortable.class.getName() + ": " + str + ": " + reason);
    }

    public static MetadataRevisionPortable parse(String str) {
        String fromHostId;
        String hostId;
        int pLen;
        int index;
        if (!str.startsWith(PREFIX)) {
            MetadataRevisionPortable.parseError("Unrecognized scheme.", str);
        }
        if ((index = str.indexOf("@", pLen = PREFIX.length())) < 0) {
            MetadataRevisionPortable.parseError("Missing host ID.", str);
        } else if (index == pLen) {
            MetadataRevisionPortable.parseError("Missing revision ID.", str);
        }
        String id = str.substring(pLen, index);
        int aIndex = index;
        index = str.indexOf("?", aIndex);
        if (index == aIndex + 1) {
            MetadataRevisionPortable.parseError("Missing host ID.", str);
        }
        if (index < 0) {
            hostId = str.substring(aIndex + 1);
            fromHostId = null;
        } else {
            hostId = str.substring(aIndex + 1, index);
            fromHostId = str.substring(index + 1);
            if (fromHostId.length() == 0) {
                fromHostId = null;
            }
        }
        if (hostId.length() == 0) {
            MetadataRevisionPortable.parseError("Missing host ID.", str);
        }
        if (fromHostId == null) {
            MetadataRevisionPortable.parseError("Missing from-host ID.", str);
        }
        try {
            id = URLDecoder.decode(id, ENC);
            hostId = URLDecoder.decode(hostId, ENC);
            fromHostId = URLDecoder.decode(fromHostId, ENC);
        }
        catch (IllegalArgumentException e) {
            MetadataRevisionPortable.parseError("Incorrectly encoded: " + e.getMessage(), str);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        return new MetadataRevisionPortable(id, hostId, fromHostId);
    }

    private static String encode(String id, String host, String fromHost) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(PREFIX).append(URLEncoder.encode(id, ENC));
            sb.append("@").append(URLEncoder.encode(host, ENC));
            if (fromHost != null) {
                sb.append("?").append(URLEncoder.encode(fromHost, ENC));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

