/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.sandbox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.adf.share.sandbox.XmlArchivedProperties;

public class SandboxConstraints {
    public static final SandboxConstraints SITE_WORKSPACE = new SandboxConstraints(ContentLevel.SITES);
    public static final SandboxConstraints VERTICAL_WORKSPACE = new SandboxConstraints(ContentLevel.VERTICALS);
    public static final SandboxConstraints ANY_WORKSPACE = new SandboxConstraints(ContentLevel.ANY);
    public static final SandboxConstraints PROGRAMMATIC_WORKSPACE = new SandboxConstraints(ContentLevel.PROGRAMMATIC);
    private final List<ContentLevel> dependents;
    private final ContentLevel workspace;
    private final Map<String, String> attributes;

    public static boolean isWorkspaceProgrammatic(SandboxConstraints sc) {
        if (sc == null) {
            return false;
        }
        return ContentLevelType.PROGRAMMATIC.equals((Object)sc.getWorkspaceLevel().getType());
    }

    public SandboxConstraints(ContentLevel workspaceLevel) {
        this(workspaceLevel, null);
    }

    public SandboxConstraints(ContentLevel workspaceLevel, List<ContentLevel> dependentLevels) {
        this(workspaceLevel, dependentLevels, null);
    }

    public SandboxConstraints(ContentLevel workspaceLevel, List<ContentLevel> dependentLevels, Map<String, String> attrs) {
        if (workspaceLevel == null) {
            throw new IllegalArgumentException("Invalid workspace level: null.");
        }
        this.workspace = workspaceLevel;
        this.dependents = dependentLevels == null ? Collections.EMPTY_LIST : dependentLevels;
        this.attributes = attrs == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(attrs);
    }

    public final List<ContentLevel> getDependentLevels() {
        return this.dependents;
    }

    public final ContentLevel getWorkspaceLevel() {
        return this.workspace;
    }

    public final Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.workspace + " " + this.dependents + " " + this.attributes;
    }

    static boolean includes(List<SandboxConstraints> constraints1, SandboxConstraints constraints2) {
        if (constraints1 == null || constraints1.isEmpty()) {
            return true;
        }
        for (SandboxConstraints sc : constraints1) {
            if (!SandboxConstraints.includes(sc, constraints2)) continue;
            return true;
        }
        return false;
    }

    static boolean includes(SandboxConstraints constraints1, SandboxConstraints constraints2) {
        ContentLevel wsp2;
        if (constraints1 == null) {
            return true;
        }
        if (constraints2 == null) {
            return false;
        }
        ContentLevel wsp1 = constraints1.getWorkspaceLevel();
        if (!wsp1.typeMatches(wsp2 = constraints2.getWorkspaceLevel())) {
            return false;
        }
        List<ContentLevel> deps1 = constraints1.getDependentLevels();
        List<ContentLevel> deps2 = constraints2.getDependentLevels();
        if (!deps1.isEmpty()) {
            if (deps2.isEmpty()) {
                return false;
            }
            for (ContentLevel dep1 : deps1) {
                boolean found = false;
                for (ContentLevel dep2 : deps2) {
                    if (!dep1.typeMatches(dep2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public String toXml() {
        AsProperties ap = new AsProperties(this);
        return ap.toXml();
    }

    public static SandboxConstraints fromXml(String xml) {
        if (xml == null) {
            throw new IllegalArgumentException("Invalid XML string: null.");
        }
        return AsProperties.valueOf(xml);
    }

    public static class ContentLevel {
        public static final ContentLevel ANY = new ContentLevel(null);
        public static final ContentLevel SITES = new ContentLevel(ContentLevelType.SITE);
        public static final ContentLevel VERTICALS = new ContentLevel(ContentLevelType.VERTICAL);
        public static final ContentLevel PROGRAMMATIC = new ContentLevel(ContentLevelType.PROGRAMMATIC);
        public static final String MDS_CC_CLASS_NAME = "oracle.mds.cust.CustomizationClass#Name";
        private final ContentLevelType _type;
        private final String _name;
        private final String _value;
        private final Map<String, String> _attrs;

        private ContentLevel(ContentLevelType type) {
            this._type = type;
            this._name = null;
            this._value = null;
            this._attrs = Collections.EMPTY_MAP;
        }

        public ContentLevel(String name, String value) {
            this((ContentLevelType)null, name, value, null);
        }

        public ContentLevel(String name, String value, String attrName, String attrValue) {
            this(null, name, value, ContentLevel.map(attrName, attrValue));
        }

        public ContentLevel(ContentLevelType type, String name, String value, String attrName, String attrValue) {
            this(type, name, value, ContentLevel.map(attrName, attrValue));
        }

        private static Map<String, String> map(String attrName, String attrValue) {
            if (attrName == null) {
                throw new IllegalArgumentException("Invalid attribute name: null.");
            }
            HashMap<String, String> r = new HashMap<String, String>(1);
            r.put(attrName, attrValue);
            return r;
        }

        public ContentLevel(ContentLevelType type, String name, String value, Map<String, String> attrs) {
            if (name == null) {
                throw new IllegalArgumentException("Invalid level name: null.");
            }
            this._type = type;
            this._name = name;
            this._attrs = attrs == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(attrs);
            this._value = value == null ? null : value;
        }

        public final ContentLevelType getType() {
            return this._type;
        }

        public final String getName() {
            return this._name;
        }

        public final String getValue() {
            return this._value;
        }

        public final Map<String, String> getAttributes() {
            return this._attrs;
        }

        public final String getAttribute(String attrName) {
            if (this._attrs == null) {
                return null;
            }
            return this._attrs.get(attrName);
        }

        public boolean typeMatches(ContentLevel level) {
            if (level == null) {
                return false;
            }
            if (this._type == null) {
                return true;
            }
            return this._type.equals((Object)level._type);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append((Object)this._type);
            sb.append(", ").append(this._name);
            sb.append(", ").append(this._value);
            sb.append(", ").append(this._attrs).append("}");
            return sb.toString();
        }

        static String[] encode(ContentLevel level) {
            Map<String, String> attrs = level.getAttributes();
            String[] r = new String[3 + attrs.size() * 2];
            r[0] = level.getType() == null ? null : level.getType().toString();
            r[1] = level.getName();
            r[2] = level.getValue();
            int index = 3;
            Iterator<String> iterator = attrs.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                r[index] = key = iterator.next();
                r[++index] = attrs.get(key);
                ++index;
            }
            return r;
        }

        static ContentLevel decode(String[] s) {
            HashMap<String, String> attrs;
            ContentLevelType type = s[0] == null ? null : ContentLevelType.valueOf(s[0]);
            if (s.length > 3) {
                attrs = new HashMap<String, String>((s.length - 3) / 2);
                for (int i = 3; i < s.length; i += 2) {
                    attrs.put(s[i], s[i + 1]);
                }
            } else {
                attrs = null;
            }
            if (s[1] == null) {
                return new ContentLevel(type);
            }
            return new ContentLevel(type, s[1], s[2], attrs);
        }
    }

    public static enum ContentLevelType {
        SITE,
        VERTICAL,
        PROGRAMMATIC;

    }

    private static class AsProperties
    extends XmlArchivedProperties {
        public AsProperties(SandboxConstraints sc) {
            this.setStringArray("Workspace", ContentLevel.encode(sc.workspace));
            int dsize = sc.dependents.size();
            this.setInteger("DependentsNum", dsize);
            for (int i = 0; i < dsize; ++i) {
                this.setStringArray("Dependents" + i, ContentLevel.encode((ContentLevel)sc.dependents.get(i)));
            }
            this.setInteger("AttrsNum", sc.attributes.size());
            int attrIndex = 0;
            for (String key : sc.attributes.keySet()) {
                this.setStringArray("Attrs" + attrIndex, new String[]{key, (String)sc.attributes.get(key)});
                ++attrIndex;
            }
        }

        public String toXml() {
            return AsProperties.toXml(this);
        }

        public static SandboxConstraints valueOf(String xml) {
            HashMap<String, String> attrs;
            Integer attrsNum;
            ArrayList<ContentLevel> dpList;
            XmlArchivedProperties sp = XmlArchivedProperties.fromXml(xml);
            String[] ws = sp.getStringArray("Workspace");
            if (ws == null) {
                return null;
            }
            ContentLevel wsp = ContentLevel.decode(ws);
            Integer dpnum = sp.getInteger("DependentsNum");
            if (dpnum != null && dpnum > 0) {
                dpList = new ArrayList<ContentLevel>(dpnum);
                for (int i = 0; i < dpnum; ++i) {
                    String[] dp = sp.getStringArray("Dependents" + i);
                    if (dp == null) continue;
                    dpList.add(ContentLevel.decode(dp));
                }
            } else {
                dpList = null;
            }
            if ((attrsNum = sp.getInteger("AttrsNum")) != null && attrsNum > 0) {
                attrs = new HashMap<String, String>(attrsNum);
                for (int i = 0; i < attrsNum; ++i) {
                    String[] entry = sp.getStringArray("Attrs" + i);
                    if (entry == null) continue;
                    attrs.put(entry[0], entry[1]);
                }
            } else {
                attrs = null;
            }
            return new SandboxConstraints(wsp, dpList, attrs);
        }
    }
}

