/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.config;

import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.util.AdfPlatformFactoryResolver;
import oracle.adf.share.logging.internal.perf.SensorTable;
import oracle.adf.share.platform.UnknownPlatformException;
import oracle.jrf.Application;
import oracle.jrf.PortabilityLayerException;

public class JRFApplicationHelper {
    private static final Logger logger = Logger.getLogger(JRFApplicationHelper.class.getName());
    private static final WeakHashMap<ClassLoader, Object> upeMap = new WeakHashMap();
    private static final Object MARKER = new Object();

    private JRFApplicationHelper() {
    }

    public static String getMDSInstanceAppName() throws PortabilityLayerException {
        if (upeMap.get(ClassUtils.getClassLoader(SensorTable.class)) != null) {
            return null;
        }
        String appName = null;
        try {
            Application id = null;
            id = AdfPlatformFactoryResolver.getAdfServerPlatformSupport().getApplication();
            if (id != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("ApplicationIdentifier=[applicationName=" + id.getApplicationName() + ", deploymentName=" + id.getDeploymentName() + ", partitionName=" + id.getPartitionName() + ", version=" + id.getVersion() + "]");
                }
                if ((appName = id.getApplicationName()) != null && appName.length() > 0) {
                    appName = appName.trim();
                    String version = id.getVersion();
                    if (version != null && version.length() > 0) {
                        appName = appName + "#" + version.trim();
                    }
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("ApplicationIdentifier was null!");
            }
        }
        catch (UnknownPlatformException upe) {
            upeMap.put(ClassUtils.getClassLoader(SensorTable.class), MARKER);
            throw upe;
        }
        catch (Exception e) {
            upeMap.put(ClassUtils.getClassLoader(SensorTable.class), MARKER);
            throw new UnknownPlatformException((Throwable)e);
        }
        finally {
            if (logger.isLoggable(Level.FINEST) && appName == null) {
                logger.log(Level.FINEST, "Returning null appName from JRF!", new Throwable("DIAGNOSTIC AID, NOT AN ERROR"));
            }
        }
        return appName;
    }
}

