/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.context.ApplicationContext;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;

class ApplicationContextImpl
implements ApplicationContext {
    private int m_platform = 0;
    private String m_deployDir;
    private Logger m_logger = Logger.getLogger("oracle.odl");
    private static final int WLS = 1;
    private static final int WAS = 2;
    private static final int JBOSS = 3;

    ApplicationContextImpl() {
        try {
            final ServerPlatformSupport sps = ServerPlatformSupportFactory.getInstance();
            if (sps.isWebLogic()) {
                this.m_platform = 1;
            } else if (sps.isWebSphere()) {
                this.m_platform = 2;
            } else if (sps.isJBoss()) {
                this.m_platform = 3;
                this.m_deployDir = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        String deployDir = System.getProperty("oracle.deployed.app.dir");
                        deployDir = deployDir != null ? new File(deployDir).getCanonicalPath() : new File(new File(sps.getServerConfigDirectory()).getCanonicalFile().getParentFile().getParentFile().getParentFile(), "deploy").getCanonicalPath();
                        return new File(deployDir).getCanonicalFile().toURI().getPath();
                    }
                });
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.FINE, "Error initializing ApplicationContextImpl: " + e, e);
            this.m_deployDir = null;
        }
    }

    @Override
    public String getApplicationName() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                return this._getApplicationName();
            }
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return ApplicationContextImpl.this._getApplicationName();
                }
            });
        }
        catch (Exception e) {
            return null;
        }
    }

    private String _getApplicationName() {
        block11: {
            block12: {
                block10: {
                    if (this.m_platform != 3) break block10;
                    if (this.m_deployDir == null) {
                        return null;
                    }
                    for (ClassLoader cl = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
                        String ds;
                        String clStr = cl.toString();
                        int i = clStr.indexOf("vfs");
                        if (i < 0) continue;
                        if (clStr.startsWith("zip:", i += 3)) {
                            i += 4;
                        } else {
                            if (!clStr.startsWith("file:", i)) continue;
                            i += 5;
                        }
                        File d = new File(clStr.substring(i, clStr.length() - 1));
                        try {
                            ds = d.getCanonicalPath();
                        }
                        catch (Exception e) {
                            ds = d.getAbsolutePath();
                        }
                        if (ds.startsWith(this.m_deployDir)) {
                            File f = new File(ds.substring(this.m_deployDir.length()));
                            String name = f.getName();
                            while ((f = f.getParentFile()) != null) {
                                name = f.getName();
                            }
                            return name;
                        }
                        return null;
                    }
                    break block11;
                }
                if (this.m_platform != 2) break block12;
                for (ClassLoader cl = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
                    int j;
                    String clStr = cl.toString();
                    int i = clStr.indexOf("[app:");
                    if (i < 0 || (j = clStr.indexOf("]", i += 5)) <= 0) continue;
                    return clStr.substring(i, j);
                }
                break block11;
            }
            if (this.m_platform != 1) break block11;
            for (ClassLoader cl = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
                int j;
                String clStr = cl.toString();
                int i = clStr.indexOf("annotation:");
                if (i < 0 || (j = clStr.indexOf(64, i + "annotation:".length())) <= 0 || j >= clStr.length()) continue;
                return clStr.substring(j + 1);
            }
        }
        return null;
    }
}

