/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public abstract class ODLHandlerBase
extends Handler {
    protected ReadWriteLock m_rwLock = new ReentrantReadWriteLock();
    private Level m_level = Level.ALL;
    private static final int OFF = Level.OFF.intValue();

    public ReadWriteLock getReadWriteLock() {
        return this.m_rwLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEncoding() {
        this.m_rwLock.readLock().lock();
        try {
            String string = super.getEncoding();
            return string;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorManager getErrorManager() {
        this.m_rwLock.readLock().lock();
        try {
            ErrorManager errorManager = super.getErrorManager();
            return errorManager;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter getFilter() {
        this.m_rwLock.readLock().lock();
        try {
            Filter filter = super.getFilter();
            return filter;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Formatter getFormatter() {
        this.m_rwLock.readLock().lock();
        try {
            Formatter formatter = super.getFormatter();
            return formatter;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Level getLevel() {
        this.m_rwLock.readLock().lock();
        try {
            Level level = this.m_level;
            return level;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEncoding(String enc) throws SecurityException, UnsupportedEncodingException {
        this.m_rwLock.writeLock().lock();
        try {
            super.setEncoding(enc);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setErrorManager(ErrorManager em) throws SecurityException {
        this.m_rwLock.writeLock().lock();
        try {
            super.setErrorManager(em);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFilter(Filter filter) throws SecurityException {
        this.m_rwLock.writeLock().lock();
        try {
            super.setFilter(filter);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFormatter(Formatter formatter) throws SecurityException {
        this.m_rwLock.writeLock().lock();
        try {
            super.setFormatter(formatter);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLevel(Level level) throws SecurityException {
        LogManager.getLogManager().checkAccess();
        this.m_rwLock.writeLock().lock();
        try {
            this.m_level = level;
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLoggable(LogRecord rec) {
        this.m_rwLock.readLock().lock();
        try {
            int levelValue = this.m_level.intValue();
            if (rec.getLevel().intValue() < levelValue || levelValue == OFF) {
                boolean bl = false;
                return bl;
            }
            Filter filter = this.getFilter();
            if (filter == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = filter.isLoggable(rec);
            return bl;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }
}

