/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.core.ojdl.logging.context.DMSLoggingContextProvider;
import oracle.core.ojdl.logging.context.LoggingContext;
import oracle.core.ojdl.logging.context.LoggingContextProvider;

public abstract class LoggingContextManager {
    private static Map<String, LoggingContextProvider> s_providers = Collections.synchronizedMap(new HashMap());
    static LoggingContext s_noOpContext = new LoggingContext(){

        @Override
        public String getECID() {
            return null;
        }

        @Override
        public String getRID() {
            return null;
        }

        @Override
        public Set<String> getLoggableAttributes() {
            return Collections.emptySet();
        }

        @Override
        public String getAttributeValue(String name) {
            return null;
        }

        @Override
        public Level getLevel() {
            return null;
        }
    };
    static LoggingContextProvider s_noOpProvider = new LoggingContextProvider(){

        @Override
        public LoggingContext getLoggingContext() {
            return s_noOpContext;
        }

        @Override
        public boolean isContextLevelEnabled() {
            return false;
        }
    };
    private static LoggingContextProvider s_defaultProvider;

    private LoggingContextManager() {
    }

    public static LoggingContext getLoggingContext(String loggerName) {
        return LoggingContextManager.getEffectiveLoggingContextProvider(loggerName).getLoggingContext();
    }

    public static LoggingContextProvider getDefaultLoggingContextProvider() {
        return s_defaultProvider;
    }

    public static void setDefaultLoggingContextProvider(LoggingContextProvider provider) {
        s_defaultProvider = provider != null ? provider : s_noOpProvider;
    }

    public static LoggingContextProvider getEffectiveLoggingContextProvider(String loggerName) {
        if (loggerName == null) {
            return s_defaultProvider;
        }
        LoggingContextProvider p = s_providers.get(loggerName);
        return p != null ? p : s_defaultProvider;
    }

    public static LoggingContextProvider getLoggingContextProvider(String loggerName) {
        return s_providers.get(loggerName);
    }

    public static void setLoggingContextProvider(String loggerName, LoggingContextProvider provider) {
        if (provider == null || loggerName == null) {
            throw new IllegalArgumentException();
        }
        s_providers.put(loggerName, provider);
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger != null && logger instanceof ODLLogger) {
            ((ODLLogger)logger).setLoggingContextProvider(provider);
        }
    }

    public static void removeLoggingContextProvider(String loggerName) {
        s_providers.remove(loggerName);
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger != null && logger instanceof ODLLogger) {
            ((ODLLogger)logger).setLoggingContextProvider(s_defaultProvider);
        }
    }

    static {
        try {
            Class.forName("oracle.dms.context.ExecutionContext");
            s_defaultProvider = new DMSLoggingContextProvider();
        }
        catch (Throwable t) {
            s_defaultProvider = s_noOpProvider;
        }
    }
}

