/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.editor.IRestHandler;
import oracle.dbtools.rest.editor.RestDetailsPanel;
import oracle.dbtools.rest.editor.RestEditor;
import oracle.dbtools.rest.editor.RestParametersPanel;
import oracle.dbtools.rest.editor.RestWorkSheet;
import oracle.dbtools.rest.model.RestHandlerParameter;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.navigator.RestHandlerNode;
import oracle.dbtools.rest.utils.RestTemplatePattern;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;

public class RestHandlerEditorPanel
extends JPanel
implements IRestHandler {
    private CustomTabbedPane _tabbed;
    private RestWorkSheet _worksheet;
    private RestParametersPanel _parameters;
    private RestDetailsPanel _details;
    private RestResourceHandler _handler;
    private RestResourceHandler _persistedHandler;
    private URL _parentURL;
    private String _moduleName;
    private String _uriTemplate;

    public RestHandlerEditorPanel(RestResourceHandler restResourceHandler) {
        this._handler = restResourceHandler;
        this._persistedHandler = new RestResourceHandler(restResourceHandler);
    }

    public void initPanel(RestHandlerNode restHandlerNode, ArrayList<ActionProvider> arrayList, ArrayList<IdeAction> arrayList2) {
        this._moduleName = restHandlerNode.getModuleName();
        this._uriTemplate = restHandlerNode.getTemplateURI();
        this._parentURL = restHandlerNode.getParentURL();
        String string = null;
        if (this._parentURL != null) {
            string = DBURLFormatHelper.getSchema((URL)this._parentURL);
        }
        List<String> list = RestTemplatePattern.getParameters(restHandlerNode.getTemplateURI());
        this._worksheet = new RestWorkSheet(arrayList, this._handler.getSQL(), list, this._handler.getConnectionName());
        this._parameters = new RestParametersPanel(this._handler);
        this._details = new RestDetailsPanel(this._handler);
        this._parameters.initialize(this.createToolbar(arrayList2));
        this._details.initialize(this.createToolbar(arrayList2), restHandlerNode.getModuleURI(), restHandlerNode.getTemplateURI(), string);
        if (this._details.getResourceHandlerSourceTypeCB() != null) {
            this._details.getResourceHandlerSourceTypeCB().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (RestHandlerEditorPanel.this._handler.getMethodType() == RestResourceHandler.HTTP_METHOD_TYPE.GET) {
                        int n = RestHandlerEditorPanel.this._details.getResourceHandlerSourceTypeCB().getSelectedIndex();
                        RestResourceHandler.SOURCE_TYPE sOURCE_TYPE = RestResourceHandler.SOURCE_TYPE.values()[n];
                        RestHandlerEditorPanel.this._parameters.refreshHandlerSourceType(sOURCE_TYPE);
                    }
                }
            });
        }
        this._tabbed = new CustomTabbedPane();
        this._tabbed.addTab(null, RestArb.getString("WORKSHEET"), this._worksheet.getGUI());
        this._tabbed.addTab(null, RestArb.getString("PARAMETERS"), (Component)this._parameters);
        this._tabbed.addTab(null, RestArb.getString("DETAILS"), (Component)this._details);
        this.setLayout(new BorderLayout());
        this.add((Component)this._tabbed, "Center");
    }

    private Toolbar createToolbar(ArrayList<IdeAction> arrayList) {
        Toolbar toolbar = null;
        if (arrayList != null) {
            toolbar = new Toolbar();
            for (IdeAction ideAction : arrayList) {
                if (ideAction.getCommandId() == RestEditor.PIN_EDITOR_CMD_ID) {
                    toolbar.add((Component)new ToggleToolButton((ToggleAction)ideAction));
                    continue;
                }
                toolbar.add((ToggleAction)ideAction);
            }
        }
        return toolbar;
    }

    @Override
    public RestResourceHandler getResourceHandler() {
        this._handler = this._details.getResourceHandler();
        String string = this._worksheet.getText();
        if (string != null) {
            string = string.trim();
            if (this._handler.getSourceType() != null && this._handler.getSourceType() != RestResourceHandler.SOURCE_TYPE.PLSQL && string.endsWith(";") && this._handler.getSourceType() != RestResourceHandler.SOURCE_TYPE.PLSQL) {
                string = string.substring(0, string.length() - 1);
            }
        }
        this._handler.setSQL(string);
        if (this._worksheet.getConnectionName() != null) {
            this._handler.setConnectionName(this._worksheet.getConnectionName());
        }
        this._handler.setParameters(this._parameters.getParameters());
        return this._handler;
    }

    public boolean refresh(RestHandlerNode restHandlerNode) {
        if (restHandlerNode == null) {
            return false;
        }
        this._handler = restHandlerNode.getHandler();
        this._worksheet.setSQL(this._handler.getSQL());
        this._worksheet.updateBindVariables(RestTemplatePattern.getParameters(restHandlerNode.getTemplateURI()));
        this._parameters.refresh(this._handler);
        URL uRL = restHandlerNode.getParentURL();
        String string = null;
        if (uRL != null) {
            string = DBURLFormatHelper.getSchema((URL)uRL);
        }
        this._details.refresh(this._handler, restHandlerNode.getModuleURI(), restHandlerNode.getTemplateURI(), string);
        return true;
    }

    public void refreshURI(RestHandlerNode restHandlerNode) {
        if (restHandlerNode == null) {
            return;
        }
        this._worksheet.updateBindVariables(RestTemplatePattern.getParameters(restHandlerNode.getTemplateURI()));
        URL uRL = restHandlerNode.getParentURL();
        String string = null;
        if (uRL != null) {
            string = DBURLFormatHelper.getSchema((URL)uRL);
        }
        this._details.refreshURIExamples(restHandlerNode.getModuleURI(), restHandlerNode.getTemplateURI(), string, true);
    }

    public boolean isRESTWorksheetTab() {
        return this._tabbed.getSelectedIndex() == 0;
    }

    public RestWorkSheet getRESTWorksheet() {
        return this._worksheet;
    }

    @Override
    public String getModuleName() {
        return this._moduleName;
    }

    @Override
    public String getURITemplate() {
        return this._uriTemplate;
    }

    @Override
    public URL getParentURL() {
        return this._parentURL;
    }

    @Override
    public void setPersistedObject(RestResourceHandler restResourceHandler) {
        this._persistedHandler = new RestResourceHandler(restResourceHandler);
    }

    public boolean isHandlerChanged() {
        RestResourceHandler restResourceHandler = this.getResourceHandler();
        if (restResourceHandler.getMethodType() != this._persistedHandler.getMethodType()) {
            return true;
        }
        if (restResourceHandler.getSourceType() != this._persistedHandler.getSourceType()) {
            return true;
        }
        if (this.isSqlChanged(restResourceHandler)) {
            return true;
        }
        if (restResourceHandler.getMethodType() == RestResourceHandler.HTTP_METHOD_TYPE.GET ? restResourceHandler.getFormatType() != this._persistedHandler.getFormatType() : this.isMimeTypesChanged(restResourceHandler)) {
            return true;
        }
        if (restResourceHandler.getPaginationSize() != this._persistedHandler.getPaginationSize()) {
            return true;
        }
        return this.isParametersChanged(restResourceHandler);
    }

    private boolean isSqlChanged(RestResourceHandler restResourceHandler) {
        String string = this._persistedHandler.getSQL();
        String string2 = restResourceHandler.getSQL();
        if (string == null || string.isEmpty()) {
            return true;
        }
        if (string2 == null || string2.isEmpty()) {
            return true;
        }
        return !(string2 = string2.replaceAll("\\r\\n|\\r", "\n")).equals(string = string.replaceAll("\\r\\n|\\r", "\n"));
    }

    private boolean isMimeTypesChanged(RestResourceHandler restResourceHandler) {
        boolean bl;
        List list = restResourceHandler.getMimeTypes();
        List list2 = this._persistedHandler.getMimeTypes();
        boolean bl2 = list == null || list.isEmpty();
        boolean bl3 = bl = list2 == null || list2.isEmpty();
        if (bl2 && bl) {
            return false;
        }
        if (bl2 && list2.size() > 0 || bl && list.size() > 0) {
            return true;
        }
        if (list.size() != list2.size()) {
            return true;
        }
        if (!bl2 && !bl) {
            for (int i = 0; i < list.size(); ++i) {
                String string;
                String string2 = (String)list.get(i);
                if (string2.equals(string = (String)list2.get(i))) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean isParametersChanged(RestResourceHandler restResourceHandler) {
        boolean bl;
        List list = restResourceHandler.getParameters();
        List list2 = this._persistedHandler.getParameters();
        boolean bl2 = list == null || list.isEmpty();
        boolean bl3 = bl = list2 == null || list2.isEmpty();
        if (bl2 && bl) {
            return false;
        }
        if (bl2 && list2.size() > 0 || bl && list.size() > 0) {
            return true;
        }
        if (list.size() != list2.size()) {
            return true;
        }
        if (!bl2 && !bl) {
            for (int i = 0; i < list.size(); ++i) {
                RestHandlerParameter restHandlerParameter = (RestHandlerParameter)list.get(i);
                RestHandlerParameter restHandlerParameter2 = (RestHandlerParameter)list2.get(i);
                if (!restHandlerParameter.getName().equals(restHandlerParameter2.getName())) {
                    return true;
                }
                if (!restHandlerParameter.getBindVariable().equals(restHandlerParameter2.getBindVariable())) {
                    return true;
                }
                if (restHandlerParameter.getAccessMethod() != restHandlerParameter.getAccessMethod()) {
                    return true;
                }
                if (restHandlerParameter.getDataType() != restHandlerParameter.getDataType()) {
                    return true;
                }
                if (restHandlerParameter.getSourceType() == restHandlerParameter.getSourceType()) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

