/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestHandlerParameter;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class RestParametersPanel
extends JPanel
implements TableModelListener {
    private RestResourceHandler _handler;
    private HandlerParametersView _view = null;
    private static final int COL_NAME = 0;
    private static final int COL_BIND_PARAM = 1;
    private static final int COL_ACCESS_METHOD = 2;
    private static final int COL_SOURCE_TYPE = 3;
    private static final int COL_DATA_TYPE = 4;
    private JTable _table;
    private DefaultTableModel _tableModel;
    private String[] ACCESS_METHOD_LIST = null;
    private String[] DATA_TYPE_LIST = null;
    private String[] SOURCE_TYPE_IN = new String[]{RestHandlerParameter.SOURCE_TYPE.HTTP_HEADER.getNLS(), RestHandlerParameter.SOURCE_TYPE.URI_TEMPLATE.getNLS()};

    public RestParametersPanel(RestResourceHandler restResourceHandler) {
        this._handler = restResourceHandler;
    }

    public void initialize(Toolbar toolbar) {
        this.setLayout(new BorderLayout());
        JButton jButton = new JButton();
        jButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        jButton.setToolTipText(RestArb.getString("ADD_PARAMETER_BUTTON"));
        JButton jButton2 = new JButton();
        jButton2.setIcon(OracleIcons.getIcon((String)"delete.png"));
        jButton2.setToolTipText(RestArb.getString("REMOVE_PARAMETER_BUTTON"));
        toolbar.addSeparator();
        toolbar.add((Component)jButton);
        toolbar.add((Component)jButton2);
        this._view = new HandlerParametersView(toolbar);
        this.add((Component)this._view.getToolbar(), "North");
        this._tableModel = new DefaultTableModel();
        this._tableModel.addColumn(RestArb.getString("NAME_PARAM"));
        this._tableModel.addColumn(RestArb.getString("BIND_PARAM"));
        this._tableModel.addColumn(RestArb.getString("ACCESS_METHOD"));
        this._tableModel.addColumn(RestArb.getString("PARAM_SOURCE_TYPE"));
        this._tableModel.addColumn(RestArb.getString("DATA_TYPE"));
        this._table = new JTable(this._tableModel){

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return new DefaultCellEditor(new JTextField());
                    }
                    case 1: {
                        return new DefaultCellEditor(new JTextField());
                    }
                    case 2: {
                        JComboBox<String> jComboBox = new JComboBox<String>(RestParametersPanel.this.getNLSValues(2));
                        jComboBox.setSelectedIndex(0);
                        return new DefaultCellEditor(jComboBox);
                    }
                    case 3: {
                        JComboBox<String> jComboBox = new JComboBox<String>(RestParametersPanel.this.getNLSValues(3));
                        jComboBox.setSelectedIndex(0);
                        return new SourceTypeComboCellEditor(jComboBox);
                    }
                    case 4: {
                        JComboBox<String> jComboBox = new JComboBox<String>(RestParametersPanel.this.getNLSValues(4));
                        jComboBox.setSelectedIndex(0);
                        return new DefaultCellEditor(jComboBox);
                    }
                }
                return new DefaultCellEditor(new JTextField());
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return new CustomCellRenderer();
            }
        };
        this.addParameters();
        this._table.setPreferredScrollableViewportSize(new Dimension(200, 200));
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)jScrollPane, "Center");
        this._table.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (RestParametersPanel.this._table.getEditingColumn() > -1 && RestParametersPanel.this._table.getEditingRow() > -1) {
                    RestParametersPanel.this._table.getCellEditor(RestParametersPanel.this._table.getEditingRow(), RestParametersPanel.this._table.getEditingColumn()).stopCellEditing();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RestParametersPanel.this.addRow(null, null, RestHandlerParameter.ACCESS_METHOD_TYPE.IN.getNLS(), RestHandlerParameter.SOURCE_TYPE.HTTP_HEADER.getNLS(), RestHandlerParameter.DATA_TYPE.STRING.getNLS());
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                while (RestParametersPanel.this._table.getSelectedRowCount() > 0) {
                    RestParametersPanel.this._tableModel.removeRow(RestParametersPanel.this._table.getSelectedRow());
                }
            }
        });
        this._tableModel.addTableModelListener(this);
    }

    private void addRow(String string, String string2, String string3, String string4, String string5) {
        this._tableModel.addRow(new Object[]{string, string2, string3, string4, string5});
    }

    public void removeAllRows() {
        if (this._tableModel != null) {
            this.stopCellEditing();
            while (this._tableModel.getRowCount() > 0) {
                this._tableModel.removeRow(this._tableModel.getRowCount() - 1);
            }
        }
    }

    private void stopCellEditing() {
        if (this._table != null && this._table.getCellEditor() != null && this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 2) {
            int n = tableModelEvent.getFirstRow();
            DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this._table.getCellEditor(n, 3);
            JComboBox jComboBox = (JComboBox)defaultCellEditor.getTableCellEditorComponent(this._table, RestHandlerParameter.SOURCE_TYPE.HTTP_HEADER.getNLS(), true, n, 3);
            this._tableModel.setValueAt((String)jComboBox.getSelectedItem(), n, 3);
        }
    }

    public void addParameters() {
        if (this._handler.getParameters() != null) {
            for (RestHandlerParameter restHandlerParameter : this._handler.getParameters()) {
                if (restHandlerParameter == null) continue;
                this.addRow(restHandlerParameter.getName(), restHandlerParameter.getBindVariable(), restHandlerParameter.getAccessMethod().getNLS(), restHandlerParameter.getSourceType().getNLS(), restHandlerParameter.getDataType().getNLS());
            }
        }
    }

    private void setParameters() {
        if (this._table != null && this._table.getCellEditor() != null && this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
        RestHandlerParameter.ACCESS_METHOD_TYPE aCCESS_METHOD_TYPE = null;
        RestHandlerParameter.SOURCE_TYPE sOURCE_TYPE = null;
        RestHandlerParameter.DATA_TYPE dATA_TYPE = null;
        this._handler.setParameters(null);
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            String string = (String)this._table.getModel().getValueAt(i, 0);
            String string2 = (String)this._table.getModel().getValueAt(i, 1);
            String string3 = (String)this._table.getModel().getValueAt(i, 2);
            String string4 = (String)this._table.getModel().getValueAt(i, 3);
            String string5 = (String)this._table.getModel().getValueAt(i, 4);
            aCCESS_METHOD_TYPE = RestHandlerParameter.ACCESS_METHOD_TYPE.values()[this.getIndex(2, string3)];
            sOURCE_TYPE = RestHandlerParameter.SOURCE_TYPE.values()[this.getIndex(3, string4)];
            dATA_TYPE = RestHandlerParameter.DATA_TYPE.values()[this.getIndex(4, string5)];
            RestHandlerParameter restHandlerParameter = new RestHandlerParameter();
            restHandlerParameter.setName(string);
            restHandlerParameter.setBindVariable(string2);
            restHandlerParameter.setAccessMethod(aCCESS_METHOD_TYPE);
            restHandlerParameter.setSourceType(sOURCE_TYPE);
            restHandlerParameter.setDataType(dATA_TYPE);
            this._handler.addParameter(restHandlerParameter);
        }
    }

    private int getIndex(int n, String string) {
        switch (n) {
            case 2: {
                for (RestHandlerParameter.ACCESS_METHOD_TYPE aCCESS_METHOD_TYPE : RestHandlerParameter.ACCESS_METHOD_TYPE.values()) {
                    if (!aCCESS_METHOD_TYPE.getNLS().equals(string)) continue;
                    return aCCESS_METHOD_TYPE.ordinal();
                }
                break;
            }
            case 3: {
                for (RestHandlerParameter.SOURCE_TYPE sOURCE_TYPE : RestHandlerParameter.SOURCE_TYPE.values()) {
                    if (!sOURCE_TYPE.getNLS().equals(string)) continue;
                    return sOURCE_TYPE.ordinal();
                }
                break;
            }
            case 4: {
                for (RestHandlerParameter.DATA_TYPE dATA_TYPE : RestHandlerParameter.DATA_TYPE.values()) {
                    if (!dATA_TYPE.getNLS().equals(string)) continue;
                    return dATA_TYPE.ordinal();
                }
                break;
            }
        }
        return 0;
    }

    private String[] getNLSValues(int n) {
        int n2 = 0;
        switch (n) {
            case 2: {
                if (this._handler.getMethodType() == RestResourceHandler.HTTP_METHOD_TYPE.GET && this._handler.getSourceType() != RestResourceHandler.SOURCE_TYPE.PLSQL) {
                    this.ACCESS_METHOD_LIST = new String[]{RestHandlerParameter.ACCESS_METHOD_TYPE.IN.getNLS()};
                } else {
                    this.ACCESS_METHOD_LIST = new String[RestHandlerParameter.ACCESS_METHOD_TYPE.values().length];
                    for (RestHandlerParameter.ACCESS_METHOD_TYPE aCCESS_METHOD_TYPE : RestHandlerParameter.ACCESS_METHOD_TYPE.values()) {
                        this.ACCESS_METHOD_LIST[n2++] = aCCESS_METHOD_TYPE.getNLS();
                    }
                }
                return this.ACCESS_METHOD_LIST;
            }
            case 3: {
                return this.SOURCE_TYPE_IN;
            }
            case 4: {
                if (this.DATA_TYPE_LIST == null) {
                    this.DATA_TYPE_LIST = new String[RestHandlerParameter.DATA_TYPE.values().length];
                    for (RestHandlerParameter.DATA_TYPE dATA_TYPE : RestHandlerParameter.DATA_TYPE.values()) {
                        this.DATA_TYPE_LIST[n2++] = dATA_TYPE.getNLS();
                    }
                }
                return this.DATA_TYPE_LIST;
            }
        }
        return null;
    }

    public boolean isValidParameters() {
        if (this._table != null && this._table.getCellEditor() != null && this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            String string = (String)this._table.getModel().getValueAt(i, 0);
            String string2 = (String)this._table.getModel().getValueAt(i, 1);
            if (RestUtils.emptyValue(string)) {
                stringBuffer.append(RestArb.format("PARAM_MISSING_NAME", Integer.toString(i + 1))).append("\n");
            } else if (RestUtils.emptyValue(string2)) {
                stringBuffer.append(RestArb.format("PARAM_MISSING_BIND", Integer.toString(i + 1))).append("\n");
            }
            if (stringBuffer.length() <= 0) continue;
            this.showErrors(stringBuffer.toString());
            return false;
        }
        return true;
    }

    private void showErrors(String string) {
        MessageDialog.error(null, (Object)string, (String)RestArb.getString("PARAMETER_ERROR_TITLE"), null);
    }

    public List<RestHandlerParameter> getParameters() {
        if (this._handler != null) {
            this.setParameters();
        }
        return this._handler.getParameters();
    }

    public boolean refresh(RestResourceHandler restResourceHandler) {
        this._handler = restResourceHandler;
        this.removeAllRows();
        this.addParameters();
        this.revalidate();
        this.repaint();
        return true;
    }

    public boolean refreshHandlerSourceType(RestResourceHandler.SOURCE_TYPE sOURCE_TYPE) {
        this._handler.setSourceType(sOURCE_TYPE);
        this.revalidate();
        this.repaint();
        return true;
    }

    public class SourceTypeComboCellEditor
    extends DefaultCellEditor {
        public SourceTypeComboCellEditor(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JComboBox jComboBox = (JComboBox)super.getComponent();
            jComboBox.removeAllItems();
            String string = (String)jTable.getModel().getValueAt(n, 2);
            RestHandlerParameter.ACCESS_METHOD_TYPE aCCESS_METHOD_TYPE = RestHandlerParameter.ACCESS_METHOD_TYPE.values()[RestParametersPanel.this.getIndex(2, string)];
            switch (aCCESS_METHOD_TYPE) {
                case IN: {
                    jComboBox.addItem(RestHandlerParameter.SOURCE_TYPE.HTTP_HEADER.getNLS());
                    jComboBox.addItem(RestHandlerParameter.SOURCE_TYPE.URI_TEMPLATE.getNLS());
                    break;
                }
                case OUT: {
                    jComboBox.addItem(RestHandlerParameter.SOURCE_TYPE.HTTP_HEADER.getNLS());
                    jComboBox.addItem(RestHandlerParameter.SOURCE_TYPE.RESPONSE.getNLS());
                    break;
                }
                case IN_OUT: {
                    jComboBox.addItem(RestHandlerParameter.SOURCE_TYPE.HTTP_HEADER.getNLS());
                    break;
                }
                default: {
                    jComboBox.addItem(RestHandlerParameter.SOURCE_TYPE.HTTP_HEADER.getNLS());
                    jComboBox.addItem(RestHandlerParameter.SOURCE_TYPE.URI_TEMPLATE.getNLS());
                }
            }
            jComboBox.setSelectedIndex(0);
            return this.editorComponent;
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl2) {
                component.setBackground(Color.BLUE);
                component.setForeground(Color.WHITE);
            } else {
                component.setBackground(Color.WHITE);
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }

    private class HandlerParametersView
    extends View {
        private Toolbar _toolbar;

        protected HandlerParametersView(Toolbar toolbar) {
            this._toolbar = toolbar;
            RestParametersPanel.this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    View.updateToolbarActions((Toolbar)HandlerParametersView.this.getToolbar());
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    View.updateToolbarActions((Toolbar)HandlerParametersView.this.getToolbar());
                }
            });
            View.updateToolbarActions((Toolbar)this.getToolbar());
        }

        public Component getGUI() {
            return RestParametersPanel.this;
        }

        public Toolbar getToolbar() {
            return this._toolbar;
        }
    }
}

