/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.common.util.SortedProperties;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.RestInstallConstants;
import oracle.dbtools.rest.install.RestInstallController;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.log.LogPage;
import oracle.ide.runner.SimpleProcess;

public class InstallORDS {
    private static final Logger logger = Logger.getLogger(InstallORDS.class.getName());
    private LogPage m_logPage;
    private File m_configDir;
    private File m_javaExe;
    private File m_warFile;
    private String m_paramFileName;
    private int m_installID;
    private boolean m_isSchemaOnly;

    public static void executeInstall(Map<String, Object> map) {
        if (map != null) {
            new InstallORDS().runInstallORDS(map);
        } else {
            logger.severe(RestArb.getString("ERROR_PARM_INVALID"));
        }
    }

    public static void executeUninstall(Map<String, Object> map) {
        if (map != null) {
            new InstallORDS().runUninstallORDS(map);
        } else {
            logger.severe(RestArb.getString("ERROR_PARM_INVALID"));
        }
    }

    public static void executeRepair(Map<String, Object> map) {
        if (map != null) {
            new InstallORDS().runRepairORDS(map);
        } else {
            logger.severe(RestArb.getString("ERROR_PARM_INVALID"));
        }
    }

    private void runInstallORDS(Map<String, Object> map) {
        if (map != null) {
            try {
                this.initialize(map);
                this.runInstall(map);
            }
            catch (Exception exception) {
                logger.severe(exception.getLocalizedMessage());
            }
        }
    }

    private void runInstall(final Map<String, Object> map) throws Exception {
        final WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(RestArb.getString("RUN_ORDS_INSTALL"), true, IRaptorTaskRunMode.TASKVIEWER){

            protected Void doWork() throws TaskException {
                try {
                    boolean bl;
                    if (map.containsKey("config.dir.update") && (bl = ((Boolean)map.get("config.dir.update")).booleanValue())) {
                        InstallORDS.this.runORDSCommand(InstallORDS.this.getConfigDirCommand(), true, true);
                    }
                    if (InstallORDS.this.m_isSchemaOnly) {
                        InstallORDS.this.runORDSCommand(InstallORDS.this.getSchemaOnlyCommand(), true, true);
                    }
                    if (InstallORDS.this.m_installID == RestInstallController.RUN_STANDALONE_CMD_ID) {
                        InstallORDS.this.runORDSCommand(InstallORDS.this.getStandaloneCommand(), true, false);
                    } else {
                        InstallORDS.this.runORDSCommand(InstallORDS.this.getInstallCommand(), true, false);
                    }
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable = raptorTaskEvent.getThrowable();
                ExceptionHandler.handleException((Throwable)((Exception)throwable));
                this.cleanup();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            private void cleanup() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitCursor.hide();
                    }
                });
            }
        });
        waitCursor.show();
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void runUninstallORDS(Map<String, Object> map) {
        if (map != null) {
            try {
                this.initialize(map);
                this.runORDS(map, CMD_TYPE.UNINSTALL);
            }
            catch (Exception exception) {
                logger.severe(exception.getLocalizedMessage());
            }
        }
    }

    private void runRepairORDS(Map<String, Object> map) {
        if (map != null) {
            try {
                this.initialize(map);
                this.runORDS(map, CMD_TYPE.REPAIR);
            }
            catch (Exception exception) {
                logger.severe(exception.getLocalizedMessage());
            }
        }
    }

    private void runORDS(Map<String, Object> map, final CMD_TYPE cMD_TYPE) throws Exception {
        final WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        String string = cMD_TYPE == CMD_TYPE.UNINSTALL ? RestArb.getString("RUN_ORDS_UNINSTALL") : RestArb.getString("RUN_ORDS_REPAIR");
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(string, true, IRaptorTaskRunMode.TASKVIEWER){

            protected Void doWork() throws TaskException {
                try {
                    if (cMD_TYPE == CMD_TYPE.UNINSTALL) {
                        InstallORDS.this.runORDSCommand(InstallORDS.this.getUninstallCommand(), true, true);
                    } else if (cMD_TYPE == CMD_TYPE.REPAIR) {
                        InstallORDS.this.runORDSCommand(InstallORDS.this.getRepairCommand(), true, true);
                    }
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable = raptorTaskEvent.getThrowable();
                ExceptionHandler.handleException((Throwable)((Exception)throwable));
                this.cleanup();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            private void cleanup() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitCursor.hide();
                    }
                });
            }
        });
        waitCursor.show();
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void runORDSCommand(String[] stringArray, boolean bl, boolean bl2) throws Exception {
        SimpleProcess simpleProcess = null;
        simpleProcess = new SimpleProcess(stringArray);
        simpleProcess.setWorkingDirectory(new File(Ide.getBinDirectory()));
        simpleProcess.setIcon(RestArb.getIcon("REST_ICON"));
        simpleProcess.setLabel(RestArb.getString("LOG_TITLE"));
        simpleProcess.setShowStartStatus(false);
        simpleProcess.setAddToProcessesFolder(bl);
        simpleProcess.setDoUILater();
        if (this.m_logPage == null) {
            simpleProcess.setLogCommandString(true);
            simpleProcess.setLogStartDirectory(false);
        } else {
            simpleProcess.setLogPage(this.m_logPage);
        }
        if (bl2) {
            simpleProcess.execAndWait();
        } else {
            simpleProcess.exec();
        }
        if (this.m_logPage == null) {
            this.m_logPage = simpleProcess.getRunProcess().getLogPage();
        }
    }

    private String[] getConfigDirCommand() {
        String[] stringArray = new String[]{this.m_javaExe.getAbsolutePath(), "-Duser.language=" + System.getProperty("user.language"), "-Duser.country=" + System.getProperty("user.country"), "-jar", this.m_warFile.getAbsolutePath(), "configdir", this.m_configDir.getAbsolutePath()};
        return stringArray;
    }

    private String[] getInstallCommand() {
        String[] stringArray = new String[]{this.m_javaExe.getAbsolutePath(), "-Duser.language=" + System.getProperty("user.language"), "-Duser.country=" + System.getProperty("user.country"), "-jar", this.m_warFile.getAbsolutePath(), "install", "--parameterFile", this.m_paramFileName, "simple"};
        return stringArray;
    }

    private String[] getSchemaOnlyCommand() {
        String[] stringArray = new String[]{this.m_javaExe.getAbsolutePath(), "-Duser.language=" + System.getProperty("user.language"), "-Duser.country=" + System.getProperty("user.country"), "-jar", this.m_warFile.getAbsolutePath(), "setup", "--schemaOnly", "--parameterFile", this.m_paramFileName, "--preserveParamFile", "--silent"};
        return stringArray;
    }

    private String[] getUninstallCommand() {
        String[] stringArray = new String[]{this.m_javaExe.getAbsolutePath(), "-Duser.language=" + System.getProperty("user.language"), "-Duser.country=" + System.getProperty("user.country"), "-jar", this.m_warFile.getAbsolutePath(), "uninstall", "--parameterFile", this.m_paramFileName, "simple"};
        return stringArray;
    }

    private String[] getRepairCommand() {
        String[] stringArray = new String[]{this.m_javaExe.getAbsolutePath(), "-Duser.language=" + System.getProperty("user.language"), "-Duser.country=" + System.getProperty("user.country"), "-jar", this.m_warFile.getAbsolutePath(), "validate", "--parameterFile", this.m_paramFileName, "--silent"};
        return stringArray;
    }

    private String[] getStandaloneCommand() {
        String[] stringArray = new String[]{this.m_javaExe.getAbsolutePath(), "-Duser.language=" + System.getProperty("user.language"), "-Duser.country=" + System.getProperty("user.country"), "-jar", this.m_warFile.getAbsolutePath(), "standalone", "--parameterFile", this.m_paramFileName};
        return stringArray;
    }

    private File getJavaExe() {
        String string = System.getProperty("java.home");
        File file = new File(string);
        File file2 = new File(file, "bin");
        File file3 = new File(file2, "java");
        return file3;
    }

    private void initialize(Map<String, Object> map) throws IOException {
        this.m_warFile = (File)map.get("ords.warfile");
        this.m_configDir = (File)map.get("config.dir");
        this.m_paramFileName = this.m_warFile.getParent() + RestInstallConstants.SQLDEV_INSTALL_PARAMS_XML;
        this.m_installID = (Integer)map.get("INSTALL_ID");
        this.m_javaExe = this.getJavaExe();
        if (map.containsKey("schema.only")) {
            this.m_isSchemaOnly = (Boolean)map.get("schema.only");
        }
        Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
        this.writeInstallProperties(map2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInstallProperties(Map<String, String> map) throws IOException {
        SortedProperties sortedProperties;
        if (!(InstallUtils.nullOrEmpty(map) || InstallUtils.nullOrEmpty(this.m_paramFileName) || InstallUtils.nullOrEmpty(sortedProperties = this.createInstallProperties(map)))) {
            File file = new File(this.m_paramFileName);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                sortedProperties.store((OutputStream)fileOutputStream, null);
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private SortedProperties createInstallProperties(Map<String, String> map) {
        if (!InstallUtils.nullOrEmpty(map)) {
            SortedProperties sortedProperties = new SortedProperties();
            Iterator<String> iterator = null;
            iterator = this.m_installID == RestInstallController.UNINSTALL_CMD_ID ? RestInstallConstants.SQLDEV_UNINSTALL_PARAM_SET.iterator() : RestInstallConstants.SQLDEV_INSTALL_PARAM_SET.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = iterator.next();
                String string3 = map.get(string2);
                if (string3 == null || string3.trim().isEmpty()) continue;
                if (string2.equals("sys.user")) {
                    string = this.encrypt(string2);
                    String string4 = this.encrypt(string3);
                    sortedProperties.put((Object)string, (Object)string4);
                    continue;
                }
                if (string2.equals("sys.password")) {
                    string = this.encrypt(string2);
                    sortedProperties.put((Object)string, (Object)string3);
                    continue;
                }
                sortedProperties.put((Object)string2, (Object)string3);
            }
            if (this.m_installID != RestInstallController.UNINSTALL_CMD_ID && !sortedProperties.containsKey((Object)"standalone.static.images")) {
                sortedProperties.put((Object)"standalone.skip.static.resources", (Object)"true");
            }
            sortedProperties.put((Object)"file.creator", (Object)"sqldev");
            return sortedProperties;
        }
        return null;
    }

    private String encrypt(String string) {
        return "@" + Passwords.goingOut((String)string);
    }

    private static enum CMD_TYPE {
        INSTALL,
        UPGRADE,
        UNINSTALL,
        REPAIR;

    }
}

