/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.wizard.InstallDBAUserDialog;

public class InstallVerifyUserDialog
extends InstallDBAUserDialog {
    private Map<String, String> m_userAccounts;
    private String m_url;
    private String[] m_usernames;

    public InstallVerifyUserDialog() {
        super(RestArb.getString("VERIFY_DB_USERS_ACCT"), RestArb.getString("VERIFY_USER_DBA_PRIV_DESCRIP"), "install_verify_user_dba_credentials_html");
    }

    public boolean checkUser(String string, String string2) {
        String[] stringArray = new String[]{string2};
        return this.checkUser(string, stringArray);
    }

    public boolean checkUser(String string, String[] stringArray) {
        this.m_url = string;
        this.m_usernames = stringArray;
        return this.runDialog();
    }

    public Map<String, String> getUserAccounts() {
        return this.m_userAccounts;
    }

    public String getErrorMessage() {
        return this.getErrMsg().toString();
    }

    @Override
    protected boolean validInfo() {
        if (super.validInfo()) {
            return this.verifyUsers();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyUsers() {
        boolean bl = false;
        Connection connection = null;
        String string = InstallDBUtils.getDBAUsername(this.getUsername());
        try {
            connection = DriverManager.getConnection(this.m_url, string, new String(this.getPassword()));
            this.m_userAccounts = InstallDBUtils.getUsersStatus(connection, this.m_usernames);
            bl = true;
        }
        catch (SQLException sQLException) {
            if (this.getErrMsg().length() > 0) {
                this.getErrMsg().append("\n");
            }
            this.getErrMsg().append(RestArb.format("ERR_CONN_FAILED", string, this.m_url, sQLException.getLocalizedMessage()));
            if (sQLException.getErrorCode() == 1017) {
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            if (this.getErrMsg().length() > 0) {
                this.getErrMsg().append("\n");
            }
            this.getErrMsg().append(RestArb.format("ERR_CONN_FAILED", string, this.m_url, exception.getLocalizedMessage()));
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return bl;
    }
}

