/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.RestInstallConstants;
import oracle.dbtools.rest.install.RestVersionObject;
import oracle.dbtools.rest.install.wizard.WizBaseCDBOptionsPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class InstallWizCDBOptionsPanel
extends WizBaseCDBOptionsPanel {
    private Logger logger = Logger.getLogger(InstallWizCDBOptionsPanel.class.getName());
    private RestInstallConstants.InstallType m_installType;
    private String m_prevConnInfo = "";
    private boolean m_init;
    private boolean m_tablespaceRequired;

    public InstallWizCDBOptionsPanel() {
        super("INSTALL", "LABEL_LC_INSTALL_UPGRADE", "WIZ_TITLE_INSTALL_UPGRADE", "LABEL_UL_INSTALL");
    }

    @Override
    protected void setupDisplayValues(Map<String, Map<String, String>> map, boolean bl) {
        block23: {
            try {
                if (map == null) break block23;
                for (String string : map.keySet()) {
                    String string2;
                    String string3;
                    String string4;
                    boolean bl2;
                    boolean bl3;
                    int n;
                    String string5;
                    block25: {
                        block24: {
                            Map<String, String> map2 = map.get(string);
                            string5 = map2.get("OPEN_MODE");
                            n = Integer.parseInt(map2.get("CON_ID"));
                            String string6 = map2.get("ORDS_VERSION");
                            bl3 = false;
                            bl2 = false;
                            string4 = string6;
                            string3 = string6;
                            string2 = "SKIP";
                            if (string5 == null || string5.isEmpty()) break block24;
                            if (string5.equals("MOUNTED") && !bl) continue;
                            switch (string5) {
                                case "READ WRITE": 
                                case "MIGRATE": {
                                    if (string6 == null || string6.isEmpty()) {
                                        bl3 = true;
                                        string2 = "INSTALL";
                                        string4 = RestArb.getString("LABEL_NONE");
                                        break;
                                    }
                                    if (string6.equals("UNKNOWN") || string6.equals(this.m_productVersion)) break;
                                    if (InstallDBUtils.isEarlierVersion(string6, this.m_productVersion)) {
                                        bl3 = true;
                                        string2 = "UPGRADE";
                                        break;
                                    }
                                    break block25;
                                }
                                case "READ ONLY": {
                                    if (string6 == null || string6.isEmpty()) {
                                        string2 = "INSTALL";
                                        if (string.equals("PDB$SEED")) {
                                            bl3 = true;
                                        } else {
                                            bl2 = true;
                                        }
                                        string4 = RestArb.getString("LABEL_NONE");
                                        break;
                                    }
                                    if (string6.equals("UNKNOWN") || string6.equals(this.m_productVersion)) break;
                                    if (InstallDBUtils.isEarlierVersion(string6, this.m_productVersion)) {
                                        bl2 = false;
                                        bl3 = true;
                                        string2 = "UPGRADE";
                                        break;
                                    }
                                    break block25;
                                }
                                case "MOUNTED": {
                                    if (string6 == null || string6.isEmpty()) {
                                        string2 = "INSTALL";
                                        if (string.equals("PDB$SEED")) {
                                            // empty if block
                                        }
                                        string4 = RestArb.getString("LABEL_NONE");
                                        break;
                                    }
                                    if (string6.equals("UNKNOWN") || string6.equals(this.m_productVersion)) break;
                                    if (InstallDBUtils.isEarlierVersion(string6, this.m_productVersion)) {
                                        bl3 = true;
                                        string2 = "UPGRADE";
                                        break;
                                    }
                                    break block25;
                                }
                                default: {
                                    string4 = RestArb.getString("LABEL_UKNOWN");
                                }
                            }
                            break block25;
                        }
                        string5 = RestArb.getString("LABEL_UKNOWN");
                        string4 = RestArb.getString("LABEL_UKNOWN");
                    }
                    this.addRow(string, n, string5, string3, string4, string2, bl3, bl2);
                }
            }
            catch (Exception exception) {
                this.logger.warning(exception.getLocalizedMessage());
                throw exception;
            }
        }
    }

    private void installUpgradeParameterValues(Map<String, Object> map) {
        Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
        List<RestVersionObject> list = this.getTableModel().getData();
        if (list != null && list.size() > 0) {
            RestVersionObject restVersionObject = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<RestVersionObject> arrayList2 = new ArrayList<RestVersionObject>();
            int n = 0;
            int n2 = 0;
            boolean bl = InstallDBUtils.isEarlierVersion((String)map.get("product.version"), "3.1.0.0.0");
            for (RestVersionObject restVersionObject2 : list) {
                String string = restVersionObject2.getName();
                String string2 = restVersionObject2.getMode();
                String string3 = restVersionObject2.getInstallType();
                if (restVersionObject2.isSelected()) {
                    if (string3.equals("INSTALL")) {
                        ++n;
                    } else if (string3.equals("UPGRADE")) {
                        ++n2;
                    }
                    arrayList2.add(restVersionObject2);
                    if (bl) {
                        if (!string2.equals("READ ONLY") || string.equals("PDB$SEED")) continue;
                        arrayList.add(restVersionObject2.getName());
                        continue;
                    }
                    if (this.m_includeAllCB.isSelected() || !string2.equals("MOUNTED") && (!string2.equals("READ ONLY") || string.equals("PDB$SEED"))) continue;
                    arrayList.add(restVersionObject2.getName());
                    continue;
                }
                if (!string.equals("CDB$ROOT")) continue;
                restVersionObject = restVersionObject2;
            }
            if (!bl && this.m_includeAllCB.isSelected()) {
                map2.put("pdb.open.asneeded", "true");
            } else if (!arrayList.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (i == 0) {
                        stringBuilder.append((String)arrayList.get(i));
                        continue;
                    }
                    stringBuilder.append(",").append((String)arrayList.get(i));
                }
                map2.put("pdb.open.readwrite", stringBuilder.toString());
            }
            if (n > 0) {
                this.m_tablespaceRequired = true;
                if (restVersionObject != null) {
                    arrayList2.add(restVersionObject);
                }
            }
            map.put("cdb.pdb.list", arrayList2);
            if (restVersionObject != null && n + n2 > 0) {
                map.put("schema.only", Boolean.TRUE);
            }
            this.logger.info("Total CDB install: " + n + " upgrade: " + n2);
            map2.put("pdb.skip.closed", "true");
            map2.put("pdb.skip.readonly", "true");
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        Map map;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1 && (map = (Map)traversableContext.get("ORDS_PARAMS")) != null && map.containsKey("INSTALL_KEY_PARAMS")) {
            final Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            this.m_installer = (String)map2.get("installer");
            String string = (String)map2.get("db.url") + (String)map2.get("sys.user");
            String string2 = (String)map.get("product.version");
            this.m_init = !this.m_productVersion.isEmpty() && this.m_productVersion.equals(string2) ? !string.equals(this.m_prevConnInfo) || this.m_containers == null || this.m_containers.isEmpty() : true;
            this.m_productVersion = (String)map.get("product.version");
            this.m_installType = (RestInstallConstants.InstallType)((Object)map.get("config.status"));
            if (this.m_init) {
                this.init();
                this.m_tablespaceRequired = false;
                this.retrieveCdbPdbInfo(map2);
                this.m_showClosedBtn.addActionListener(new ActionListener(){
                    final Map<String, String> params;
                    {
                        this.params = map2;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        InstallWizCDBOptionsPanel.this.showClosedPDBs(this.params);
                        InstallWizCDBOptionsPanel.this.m_showClosedBtn.setEnabled(false);
                    }
                });
                this.m_includeAllCB.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        InstallWizCDBOptionsPanel.this.updateProcessSelection();
                    }
                });
            }
            this.m_prevConnInfo = (String)map2.get("db.url") + (String)map2.get("sys.user");
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            if (this.getTable().getCellEditor() != null) {
                this.getTable().getCellEditor().stopCellEditing();
            }
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            this.installUpgradeParameterValues(map);
            map.put("cdb.total.containers", this.m_totalContainers);
        }
    }

    public Object getExitTransition() {
        if (this.m_installer.equals("install") || (this.m_installer.equals("upgrade") || this.m_installer.equals("cdb.upgrade")) && this.m_tablespaceRequired) {
            return "Transition.CdbTablespaces";
        }
        switch (this.m_installType) {
            case REQUIRES_CONFIG: {
                return "Transition.PLSQLGateway";
            }
            case MIGRATE_V2: {
                return "Transition.Standalone";
            }
            case VERIFY_SCHEMA: {
                return "Transition.Standalone";
            }
        }
        return "Transition.Standalone";
    }
}

