/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.InstallValidator;
import oracle.dbtools.rest.install.RestInstallConstants;
import oracle.dbtools.rest.install.wizard.InstallVerifySchemaDialog;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class InstallWizSchemaPanel
extends DefaultTraversablePanel {
    private static Logger logger = Logger.getLogger(InstallWizSchemaPanel.class.getName());
    private static String DEFAULT_DB_HOST = "localhost";
    private static String DEFAULT_DB_PORT = "1521";
    private static String DEFAULT_DB_SERVICENAME = "orcl";
    private JTextField m_host = new JTextField();
    private JTextField m_port = new JTextField();
    private JTextField m_sid = new JTextField();
    private JTextField m_serviceName = new JTextField();
    private JRadioButton m_sidBtn = new JRadioButton();
    private JRadioButton m_servicenameBtn = new JRadioButton();
    private JLabel m_publicUsername = new JLabel();
    private JPasswordField m_publicPassword = new JPasswordField();
    private JPasswordField m_publicConfirmPassword = new JPasswordField();
    private JCheckBox m_skipInstall = new JCheckBox();
    private String m_prevConnInfo = "";
    private RestInstallConstants.InstallType m_installType;
    private String m_installer;
    private boolean m_isCDB;

    public InstallWizSchemaPanel() {
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.m_publicUsername.setText("ORDS_PUBLIC_USER");
        this.m_servicenameBtn.setSelected(true);
        this.m_skipInstall.setSelected(false);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_host, (String)RestArb.getString("HOST"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_port, (String)RestArb.getString("PORT"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_publicUsername, (String)RestArb.getString("USERNAME"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.m_publicPassword, (String)RestArb.getString("PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this.m_publicConfirmPassword, (String)RestArb.getString("CONFIRM_PASSWORD"));
        ResourceUtils.resButton((AbstractButton)this.m_sidBtn, (String)RestArb.getString("SID"));
        ResourceUtils.resButton((AbstractButton)this.m_servicenameBtn, (String)RestArb.getString("SERVICE_NAME"));
        ResourceUtils.resButton((AbstractButton)this.m_skipInstall, (String)RestArb.getString("SKIP_INSTALL_SCHEMA"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_sidBtn);
        buttonGroup.add(this.m_servicenameBtn);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_host, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_port, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_servicenameBtn, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_serviceName, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_sidBtn, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_sid, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        JPanel jPanel2 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_DB_CONN"), (Component)jPanel);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(RestArb.getString("WIZ_PUBLIC_USER_DESCRIP"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        n = 0;
        JPanel jPanel3 = LayoutControl.GBC.createPanel();
        jPanel3.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)this.m_publicUsername, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)jLabel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)this.m_publicPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)jLabel5, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)this.m_publicConfirmPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)this.m_skipInstall, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        LayoutControl.GBC.addVSpring((JPanel)jPanel3, (int)(++n));
        JPanel jPanel4 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_PUBLIC_USER"), (Component)jPanel3);
        n = 0;
        this.add(jPanel2, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
        this.m_sidBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    InstallWizSchemaPanel.this.enableDisableSidServiceNameFields();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.m_servicenameBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    InstallWizSchemaPanel.this.enableDisableSidServiceNameFields();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.m_skipInstall.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    InstallWizSchemaPanel.this.enableDisablePublicUser();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void enableDisableSidServiceNameFields() {
        this.m_sid.setEnabled(this.m_sidBtn.isSelected());
        this.m_serviceName.setEnabled(this.m_servicenameBtn.isSelected());
    }

    private void enableDisablePublicUser() {
        this.m_publicUsername.setEnabled(!this.m_skipInstall.isSelected());
        this.m_publicPassword.setEnabled(!this.m_skipInstall.isSelected());
        this.m_publicConfirmPassword.setEnabled(!this.m_skipInstall.isSelected());
    }

    private void cdbVerifyExistingSchema(Map<String, String> map, String string, String string2, String string3) throws Exception {
        if (InstallDBUtils.isEarlierVersion(string3, "3.0.5.0.0")) {
            throw new TraversalException(RestArb.format("ERROR_INVALID_VERSION_CDB", string3, RestArb.getString("LABEL_LC_UPGRADE")));
        }
        if (InstallDBUtils.isEarlierVersion(string3, "3.1.0.0.0") && InstallUtils.nullOrEmpty(string2)) {
            throw new TraversalException(RestArb.getString("ERROR_USER_EXISTS_VERSION_MISSING"));
        }
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (InstallDBUtils.isEarlierVersion(string2, string3)) {
            string4 = RestArb.getString("WIZ_VERIFY_UPGRADE");
            string5 = RestArb.format("WIZ_VERIFY_UPGRADE_DESCRIP", string3);
            string6 = "upgrade_sysdba_priv_html";
            string7 = "upgrade";
        } else if (string2.equals(string3)) {
            string4 = RestArb.getString("WIZ_VERIFY_CDB_PDBS_UPGRADE");
            string5 = RestArb.format("WIZ_VERIFY_CDB_UPGRADE_DESCRIP", string3);
            string6 = "verify_sysdba_priv_html";
            string7 = "cdb.upgrade";
        }
        InstallVerifySchemaDialog installVerifySchemaDialog = new InstallVerifySchemaDialog(string4, string5, string6);
        if (installVerifySchemaDialog.checkSchema(string)) {
            String string8 = installVerifySchemaDialog.getSchemaVersion();
            if (string8.equals(string2)) {
                map.put("sys.user", installVerifySchemaDialog.getUsername());
                String string9 = "@" + Passwords.goingOut((String)new String(installVerifySchemaDialog.getPassword()));
                map.put("sys.password", string9);
                map.put("db.url", string);
                map.put("installer", string7);
            } else {
                RestArb.format("ERR_MISMATCH_SCHEMA_VER", string2, installVerifySchemaDialog.getUsername(), string8);
            }
        } else {
            throw new TraversalException(RestArb.format("WIZ_CANCEL_UPGRADE_USER", string3));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nonCdbVerifyExistingSchema(Map<String, String> map, String string, String string2, String string3) throws Exception {
        if (InstallUtils.nullOrEmpty(string2)) {
            throw new TraversalException(RestArb.getString("ERROR_USER_EXISTS_VERSION_MISSING"));
        }
        if (InstallDBUtils.isEarlierVersion(string2, string3)) {
            InstallVerifySchemaDialog installVerifySchemaDialog = new InstallVerifySchemaDialog(RestArb.getString("WIZ_VERIFY_UPGRADE"), RestArb.format("WIZ_VERIFY_UPGRADE_DESCRIP", string3), "upgrade_sysdba_priv_html");
            if (!installVerifySchemaDialog.checkSchema(string)) throw new TraversalException(RestArb.format("WIZ_CANCEL_UPGRADE_USER", string3));
            String string4 = installVerifySchemaDialog.getSchemaVersion();
            if (string4.equals(string2)) {
                map.put("sys.user", installVerifySchemaDialog.getUsername());
                String string5 = "@" + Passwords.goingOut((String)new String(installVerifySchemaDialog.getPassword()));
                map.put("sys.password", string5);
                map.put("db.url", string);
                map.put("installer", "upgrade");
                map.put("schema.version", string2);
                return;
            } else {
                RestArb.format("ERR_MISMATCH_SCHEMA_VER", string2, installVerifySchemaDialog.getUsername(), string4);
            }
            return;
        } else {
            if (!string2.equals(string3)) return;
            map.put("installer", "none");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String verifySchemaVersion(TraversableContext traversableContext) throws TraversalException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        Connection connection = null;
        String string3 = InstallDBUtils.getUrl(this.m_host.getText(), this.m_port.getText(), this.m_sid.isEnabled() ? this.m_sid.getText() : null, this.m_serviceName.isEnabled() ? this.m_serviceName.getText() : null);
        Map map = (Map)traversableContext.get("ORDS_PARAMS");
        Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
        String string4 = (String)map.get("product.version");
        try {
            connection = DriverManager.getConnection(string3, this.m_publicUsername.getText(), new String(this.m_publicPassword.getPassword()));
            string = InstallDBUtils.getORDSVersion(connection);
            if (InstallUtils.nullOrEmpty(string)) {
                throw new TraversalException(RestArb.getString("ERROR_USER_EXISTS_VERSION_MISSING"));
            }
            if (InstallDBUtils.isEarlierVersion(string4, string)) {
                throw new TraversalException(RestArb.format("ERR_MISMATCH_VERSIONS", string4, string));
            }
            if (InstallDBUtils.isCDBRoot(connection)) {
                this.cdbVerifyExistingSchema(map2, string3, string, string4);
                this.m_isCDB = true;
            } else {
                this.nonCdbVerifyExistingSchema(map2, string3, string, string4);
                this.m_isCDB = false;
            }
            map2.put("schema.version", string);
        }
        catch (SQLException sQLException) {
            string2 = sQLException.getMessage();
            if (sQLException.getErrorCode() != 1017) {
                String string5 = RestArb.format("ERR_CONN_FAILED", this.m_publicUsername.getText(), string3, sQLException.getLocalizedMessage());
                logger.log(Level.WARNING, string5);
                throw new TraversalException(string5);
            }
            bl = true;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            throw new TraversalException(exception.getLocalizedMessage());
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        if (!bl) return string;
        InstallVerifySchemaDialog installVerifySchemaDialog = new InstallVerifySchemaDialog();
        if (!installVerifySchemaDialog.checkSchema(string3)) {
            String string6 = RestArb.format("WIZ_CANCEL_PRIV_USER", new Object[0]);
            throw new TraversalException(string6);
        }
        string = installVerifySchemaDialog.getSchemaVersion();
        if (InstallUtils.nullOrEmpty(string)) {
            if (installVerifySchemaDialog.isCDBRoot()) {
                if (InstallDBUtils.isEarlierVersion(string4, "3.0.5.0.0")) {
                    throw new TraversalException(RestArb.format("ERROR_INVALID_VERSION_CDB", string4, RestArb.getString("LABEL_LC_INSTALL")));
                }
                this.m_isCDB = true;
            } else {
                this.m_isCDB = false;
            }
            map2.put("sys.user", installVerifySchemaDialog.getUsername());
            String string7 = "@" + Passwords.goingOut((String)new String(installVerifySchemaDialog.getPassword()));
            map2.put("sys.password", string7);
            map2.put("installer", "install");
            map2.put("schema.version", string);
            return string;
        }
        String string8 = RestArb.format("ERR_INVALID_PASSWORD", string, string2 != null ? string2 : "");
        throw new TraversalException(string8);
    }

    private void validateValues(TraversableContext traversableContext) throws TraversalException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_host.getText() == null || this.m_host.getText().trim().length() == 0) {
            stringBuffer.append(RestArb.getString("ERROR_HOST_MISSING"));
            this.m_host.requestFocus();
        }
        if (this.m_port.getText() == null || this.m_port.getText().trim().length() == 0) {
            if (stringBuffer.toString().length() > 0) {
                stringBuffer.append("\n");
            } else {
                this.m_port.requestFocus();
            }
            stringBuffer.append(RestArb.getString("ERROR_PORT_MISSING"));
        }
        String string2 = string = this.m_sidBtn.isSelected() ? this.m_sid.getText() : this.m_serviceName.getText();
        if (string == null || string.trim().length() == 0) {
            if (stringBuffer.toString().length() > 0) {
                stringBuffer.append("\n");
            } else if (this.m_sidBtn.isSelected()) {
                this.m_sid.requestFocus();
            } else {
                this.m_serviceName.requestFocus();
            }
            stringBuffer.append(this.m_sidBtn.isSelected() ? RestArb.getString("ERROR_SID_MISSING") : RestArb.getString("ERROR_SERVICENAME_MISSING"));
        }
        if (stringBuffer.toString().length() > 0) {
            throw new TraversalException(stringBuffer.toString());
        }
        String string3 = InstallDBUtils.getUrl(this.m_host.getText(), this.m_port.getText(), this.m_sid.isEnabled() ? this.m_sid.getText() : null, this.m_serviceName.isEnabled() ? this.m_serviceName.getText() : null);
        Map map = (Map)traversableContext.get("ORDS_PARAMS");
        Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
        if (!this.m_skipInstall.isSelected()) {
            InstallValidator.validatePasswords(this.m_publicUsername.getText(), this.m_publicPassword, this.m_publicConfirmPassword);
            if (!map2.containsKey("installer") || !string3.equals(this.m_prevConnInfo) || this.m_installer.equals("skip")) {
                this.verifySchemaVersion(traversableContext);
            }
        } else {
            map2.put("installer", "skip");
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        Map map;
        Map map2;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1 && (map2 = (Map)traversableContext.get("ORDS_PARAMS")) != null && map2.containsKey("INSTALL_KEY_PARAMS") && (map = (Map)map2.get("INSTALL_KEY_PARAMS")) != null) {
            this.m_host.setText(map.get("db.hostname") != null ? (String)map.get("db.hostname") : DEFAULT_DB_HOST);
            this.m_port.setText(map.get("db.port") != null ? (String)map.get("db.port") : DEFAULT_DB_PORT);
            String string = (String)map.get("db.servicename");
            String string2 = (String)map.get("db.sid");
            if (string == null || string.trim().length() == 0) {
                string = "";
            }
            if (string2 == null || string2.trim().length() == 0) {
                string2 = "";
            }
            if (!string.isEmpty()) {
                this.m_servicenameBtn.setSelected(true);
            } else if (!string2.isEmpty()) {
                this.m_sidBtn.setSelected(true);
            } else {
                this.m_servicenameBtn.setSelected(true);
                string = DEFAULT_DB_SERVICENAME;
            }
            this.m_sid.setText(string2);
            this.m_serviceName.setText(string);
            this.enableDisableSidServiceNameFields();
            if (this.m_skipInstall.isSelected()) {
                map.put("installer", "skip");
            }
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateValues(traversableContext);
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            this.m_installType = (RestInstallConstants.InstallType)((Object)map.get("config.status"));
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            this.m_installer = (String)map2.get("installer");
            if (this.m_installer == null) {
                map2.put("installer", "skip");
            }
            if (this.m_installer.equals("skip")) {
                map2.put("rest.services.ords.add", "false");
            } else {
                map2.put("rest.services.ords.add", "true");
            }
            map2.put("db.hostname", this.m_host.getText());
            map2.put("db.port", this.m_port.getText());
            if (this.m_sidBtn.isSelected()) {
                map2.put("db.sid", this.m_sid.getText());
                map2.remove("db.servicename");
            } else {
                map2.put("db.servicename", this.m_serviceName.getText());
                map2.remove("db.sid");
            }
            String string = InstallDBUtils.getUrl(this.m_host.getText(), this.m_port.getText(), this.m_sid.isEnabled() ? this.m_sid.getText() : null, this.m_serviceName.isEnabled() ? this.m_serviceName.getText() : null);
            map2.put("db.url", string);
            map2.put("user.name.public", this.m_publicUsername.getText());
            String string2 = "@" + Passwords.goingOut((String)new String(this.m_publicPassword.getPassword()));
            map2.put("user.public.password", string2);
            this.m_prevConnInfo = string;
        }
    }

    public Object getExitTransition() {
        if (this.m_isCDB) {
            if (this.m_installer.equals("install") || this.m_installer.equals("upgrade") || this.m_installer.equals("cdb.upgrade")) {
                return "Transition.CdbOptions";
            }
        } else if (this.m_installer.equals("install")) {
            return "Transition.Tablespace";
        }
        switch (this.m_installType) {
            case REQUIRES_CONFIG: {
                return "Transition.PLSQLGateway";
            }
            case MIGRATE_V2: {
                return "Transition.Standalone";
            }
            case VERIFY_SCHEMA: {
                return "Transition.Standalone";
            }
        }
        return "Transition.Standalone";
    }
}

