/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.config.RestConfig;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.RestInstallConstants;
import oracle.dbtools.rest.install.RestInstallController;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class InstallWizWarFilePanel
extends DefaultTraversablePanel {
    public static final WildcardURLFilter WAR_FILTER = new WildcardURLFilter(RestArb.getString("WAR_FILTER_MASK"), URLFileSystem.isLocalFileSystemCaseSensitive(), RestArb.getString("WAR_FILTER_NAME"));
    private static final int ORDS_MIN_VERSION = 3;
    private RestInstallConstants.InstallType m_installType = RestInstallConstants.InstallType.REQUIRES_CONFIG;
    private JRadioButton m_SQLDevORDSWarFile = new JRadioButton();
    private JRadioButton m_userORDSWarFile = new JRadioButton();
    private ButtonGroup m_btnGrp = new ButtonGroup();
    private JTextField m_fileName = new JTextField();
    private JTextField m_configLoc = new JTextField();
    private JLabel m_versionLbl = new JLabel();
    private JButton m_warBrowseBtn = new JButton();
    private JButton m_resetBtn = new JButton();
    private JButton m_configBrowseBtn = new JButton();
    private String m_sqldev_ords_path;
    private String m_sqldev_warConfigDir;
    private String m_sqldev_warVersion;
    private String m_warProductVersion;
    private String m_warConfigDir;
    private File m_lastFileURL;
    private File m_lastFolderURL;
    private File m_prevWarFile;
    private File m_prevConfigPath;
    private Set<String> createdConfigFolders = new HashSet<String>();
    private int m_installID;

    public InstallWizWarFilePanel() {
        this.m_sqldev_ords_path = this.getSQLDevDefaultWarFile();
        try {
            if (this.m_sqldev_ords_path != null && this.validWarFile(this.m_sqldev_ords_path)) {
                if (this.m_warConfigDir == null || this.m_warConfigDir.trim().isEmpty()) {
                    this.m_warConfigDir = RestConfig.getInstance().getString("SQLDEV_ORDS_CONFIGDIR");
                }
                this.m_sqldev_warConfigDir = this.m_warConfigDir;
                this.m_sqldev_warVersion = this.m_warProductVersion;
                this.m_SQLDevORDSWarFile.setSelected(true);
                this.m_configLoc.setText(this.m_sqldev_warConfigDir);
                this.m_versionLbl.setText(RestArb.format("WIZ_WAR_VERSION", this.m_sqldev_warVersion));
            } else {
                this.hideSQLDEVDefaultORDSOption();
            }
        }
        catch (Exception exception) {
            this.hideSQLDEVDefaultORDSOption();
        }
        this.buildPanel();
    }

    private String getSQLDevDefaultWarFile() {
        String string = System.getProperty("oracle.home") + RestInstallConstants.SQLDEV_ORDS_WAR_FILE;
        try {
            if (this.checkWarFileExists(string)) {
                return string;
            }
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
        try {
            string = System.getenv("ORACLE_HOME") + RestInstallConstants.SQLDEV_ORDS_WAR_FILE;
            if (this.checkWarFileExists(string)) {
                return string;
            }
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
        return null;
    }

    private void hideSQLDEVDefaultORDSOption() {
        this.m_fileName.setText("");
        this.m_configLoc.setText("");
        this.m_versionLbl.setText(RestArb.getString("WIZ_WAR_SELECT_ORDS"));
        this.m_SQLDevORDSWarFile.setSelected(false);
        this.m_userORDSWarFile.setSelected(true);
        this.m_SQLDevORDSWarFile.setEnabled(false);
        this.m_userORDSWarFile.setEnabled(true);
        this.m_warConfigDir = "";
        this.m_warProductVersion = "";
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.m_btnGrp.add(this.m_SQLDevORDSWarFile);
        this.m_btnGrp.add(this.m_userORDSWarFile);
        this.m_fileName.setEditable(false);
        this.m_fileName.setFocusable(false);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resButton((AbstractButton)this.m_SQLDevORDSWarFile, (String)RestArb.getString("WIZ_WAR_FILE_SQLDEV"));
        ResourceUtils.resButton((AbstractButton)this.m_userORDSWarFile, (String)RestArb.getString("WIZ_WAR_FILE_USER"));
        ResourceUtils.resButton((AbstractButton)this.m_warBrowseBtn, (String)RestArb.getString("ORDS_BTN"));
        ResourceUtils.resButton((AbstractButton)this.m_resetBtn, (String)RestArb.getString("RESET_BTN"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_fileName, (String)RestArb.getString("WIZ_WAR_FILE_NAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_resetBtn, (String)RestArb.getString("WIZ_WAR_RESET_CONFIG"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(RestArb.getString("WIZ_WAR_FILE_DESCRIP"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        JPanel jPanel = LayoutControl.GBC.createPanel();
        if (this.m_sqldev_ords_path != null) {
            jPanel.add((Component)this.m_SQLDevORDSWarFile, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            jPanel.add((Component)this.m_userORDSWarFile, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        } else {
            JTextPane jTextPane2 = new JTextPane();
            jTextPane2.setText(RestArb.getString("WIZ_WAR_FILE_USER"));
            jTextPane2.setEditable(false);
            jTextPane2.setOpaque(false);
            jTextPane2.setRequestFocusEnabled(false);
            jTextPane2.setFocusable(false);
            jPanel.add((Component)jTextPane2, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        }
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)1);
        int n = 0;
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        jPanel2.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel2.add((Component)this.m_resetBtn, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        n = 0;
        JPanel jPanel3 = LayoutControl.GBC.createPanel();
        jPanel3.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)jPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        jPanel3.add((Component)this.m_fileName, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)this.m_warBrowseBtn, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        JPanel jPanel4 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_WAR_FILE"), (Component)jPanel3);
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_configLoc, (String)RestArb.getString("WIZ_CONFIG_FOLDER"));
        ResourceUtils.resButton((AbstractButton)this.m_configBrowseBtn, (String)RestArb.getString("BROWSE_BTN"));
        JTextPane jTextPane3 = new JTextPane();
        jTextPane3.setText(RestArb.getString("WIZ_CONFIG_DIR_DESCRIP"));
        jTextPane3.setEditable(false);
        jTextPane3.setOpaque(false);
        jTextPane3.setRequestFocusEnabled(false);
        jTextPane3.setFocusable(false);
        n = 0;
        int n2 = 0;
        JPanel jPanel5 = LayoutControl.GBC.createPanel();
        jPanel5.add((Component)jTextPane3, LayoutControl.GBC.gbc((int)n2, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        jPanel5.add((Component)jLabel3, LayoutControl.GBC.gbc((int)n2, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel5.add((Component)this.m_configLoc, LayoutControl.GBC.gbc((int)(++n2), (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel5.add((Component)this.m_configBrowseBtn, LayoutControl.GBC.gbc((int)(++n2), (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        jPanel5.add((Component)jPanel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        JPanel jPanel6 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_CONFIG_FILE"), (Component)jPanel5);
        n = 0;
        n2 = 0;
        JPanel jPanel7 = LayoutControl.GBC.createPanel();
        jPanel7.add((Component)this.m_versionLbl, LayoutControl.GBC.gbc((int)n2, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        LayoutControl.GBC.addHSpring((JPanel)jPanel7, (int)(++n2));
        JPanel jPanel8 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_VERSION"), (Component)jPanel7);
        n = 0;
        this.add(jPanel4, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel6, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel8, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
        this.m_warBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (InstallWizWarFilePanel.this.selectFileDialog()) {
                    try {
                        if (InstallWizWarFilePanel.this.checkWarFileExists(InstallWizWarFilePanel.this.m_lastFileURL.getPath()) && InstallWizWarFilePanel.this.validWarFile(InstallWizWarFilePanel.this.m_lastFileURL.getPath())) {
                            InstallWizWarFilePanel.this.m_fileName.setText(InstallWizWarFilePanel.this.m_lastFileURL.getPath());
                            InstallWizWarFilePanel.this.m_configLoc.setText(InstallWizWarFilePanel.this.m_warConfigDir);
                            InstallWizWarFilePanel.this.m_versionLbl.setText(RestArb.format("WIZ_WAR_VERSION", InstallWizWarFilePanel.this.m_warProductVersion));
                        }
                    }
                    catch (Exception exception) {
                        InstallWizWarFilePanel.this.m_fileName.setText("");
                        InstallWizWarFilePanel.this.m_configLoc.setText("");
                        InstallWizWarFilePanel.this.m_versionLbl.setText(RestArb.getString("WIZ_WAR_SELECT_ORDS"));
                        MessageDialog.error(null, (Object)exception.getLocalizedMessage(), (String)RestArb.getString("WIZ_TITLE_WAR_FILE"), null);
                    }
                }
            }
        });
        this.enableDisableComponents();
        this.m_configBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (InstallWizWarFilePanel.this.selectFolderDialog()) {
                    InstallWizWarFilePanel.this.m_configLoc.setText(InstallWizWarFilePanel.this.m_lastFolderURL.getPath());
                }
            }
        });
        this.m_resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (InstallWizWarFilePanel.this.m_SQLDevORDSWarFile.isSelected()) {
                    InstallWizWarFilePanel.this.m_configLoc.setText(InstallWizWarFilePanel.this.m_sqldev_warConfigDir);
                } else {
                    InstallWizWarFilePanel.this.m_configLoc.setText(InstallWizWarFilePanel.this.m_warConfigDir);
                }
            }
        });
        this.m_SQLDevORDSWarFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    InstallWizWarFilePanel.this.enableDisableComponents();
                    if (InstallWizWarFilePanel.this.m_SQLDevORDSWarFile.isSelected()) {
                        InstallWizWarFilePanel.this.m_configLoc.setText(InstallWizWarFilePanel.this.m_sqldev_warConfigDir);
                        InstallWizWarFilePanel.this.m_versionLbl.setText(RestArb.format("WIZ_WAR_VERSION", InstallWizWarFilePanel.this.m_sqldev_warVersion));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.m_userORDSWarFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    InstallWizWarFilePanel.this.enableDisableComponents();
                    if (InstallWizWarFilePanel.this.m_userORDSWarFile.isSelected()) {
                        if (InstallWizWarFilePanel.this.m_fileName.getText() != null && InstallWizWarFilePanel.this.m_fileName.getText().trim().length() > 0) {
                            InstallWizWarFilePanel.this.m_configLoc.setText(InstallWizWarFilePanel.this.m_warConfigDir);
                            InstallWizWarFilePanel.this.m_versionLbl.setText(RestArb.format("WIZ_WAR_VERSION", InstallWizWarFilePanel.this.m_warProductVersion));
                        } else {
                            InstallWizWarFilePanel.this.m_configLoc.setText("");
                            InstallWizWarFilePanel.this.m_versionLbl.setText(RestArb.getString("WIZ_WAR_SELECT_ORDS"));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void enableDisableComponents() {
        boolean bl = this.m_SQLDevORDSWarFile.isSelected();
        this.m_fileName.setEnabled(!bl);
        this.m_warBrowseBtn.setEnabled(!bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validConfigLocation() throws TraversalException {
        File file = null;
        String string = this.m_configLoc.getText();
        if (RestUtils.emptyValue(string)) {
            throw new TraversalException(RestArb.getString("ERROR_MISSING_CONFIG_DIR"));
        }
        file = new File(string);
        if (!file.exists()) {
            boolean bl = MessageDialog.confirm(null, (Object)RestArb.getString("WIZ_QUESTION_CREATE_DIR"), (String)RestArb.getString("WIZ_CONFIRM_CREATE_DIR"), null);
            if (!bl) throw new TraversalException(RestArb.getString("WARNING_CONFIG_DIR_REQUIRED"));
            try {
                boolean bl2 = file.mkdir();
                if (!bl2) {
                    throw new TraversalException(RestArb.getString("WARNING_CONFIG_DIR_REQUIRED"));
                }
                this.createdConfigFolders.add(file.getAbsolutePath());
                return true;
            }
            catch (Exception exception) {
                throw new TraversalException(exception.getLocalizedMessage());
            }
        } else {
            if (file.isDirectory()) return true;
            throw new TraversalException(RestArb.format("ERROR_CONFIG_DIR_INVALID", file.getPath()));
        }
    }

    private boolean checkWarFileExists(String string) throws TraversalException {
        if (RestUtils.emptyValue(string)) {
            throw new TraversalException(RestArb.getString("ERROR_MISSING_WAR_FILE"));
        }
        File file = new File(string);
        if (file.isDirectory()) {
            throw new TraversalException(RestArb.format("ERROR_WAR_FILE_INVALID", file.getPath()));
        }
        if (!file.exists()) {
            throw new TraversalException(RestArb.format("ERROR_WAR_FILE_NOT_EXIST", file.getPath()));
        }
        return true;
    }

    private boolean validWarFile(String string) throws TraversalException {
        this.m_warProductVersion = "";
        this.m_warConfigDir = "";
        try {
            File file = new File(string);
            Map<String, String> map = InstallUtils.getWEBXMLParams(file);
            String string2 = map.get("product.version");
            if (!this.isValidORDSVersion(string2)) {
                throw new TraversalException(RestArb.format("ERROR_WAR_FILE_VERSION", string2));
            }
            this.m_warConfigDir = map.get("config.dir");
            this.m_warProductVersion = string2;
        }
        catch (IOException iOException) {
            throw new TraversalException((Object)iOException);
        }
        return true;
    }

    private boolean isValidORDSVersion(String string) {
        String[] stringArray;
        int n;
        return string != null && !string.isEmpty() && (n = Integer.parseInt((stringArray = string.split("\\."))[0])) >= 3;
    }

    private void validateValues() throws TraversalException {
        if (this.m_userORDSWarFile.isSelected() && RestUtils.emptyValue(this.m_fileName.getText())) {
            throw new TraversalException(RestArb.getString("ERROR_MISSING_WAR_FILE"));
        }
        if (this.m_SQLDevORDSWarFile.isSelected() && this.m_sqldev_warVersion == null) {
            throw new TraversalException(RestArb.getString("ERROR_SQLDEV_WAR_FILE"));
        }
        this.validConfigLocation();
    }

    protected boolean selectFileDialog() {
        String string;
        if (this.m_lastFileURL == null) {
            string = System.getProperty("user.home");
            this.m_lastFileURL = new File(string);
        }
        string = new URLFileChooser(this.m_lastFileURL);
        string.clearChooseableURLFilters();
        string.setURLFilter((URLFilter)WAR_FILTER);
        string.setSelectionScope(2);
        string.setSelectionMode(0);
        string.setShowJarsAsDirs(false);
        int n = string.showOpenDialog((Component)Ide.getMainWindow(), RestArb.getString("WIZ_SELECT_WAR_FILE"));
        if (n == 0) {
            this.m_lastFileURL = string.getSelectedFile().getAbsoluteFile();
            return true;
        }
        return false;
    }

    protected boolean selectFolderDialog() {
        String string;
        if (this.m_lastFolderURL == null) {
            string = System.getProperty("user.home");
            this.m_lastFolderURL = new File(string);
        }
        string = new URLFileChooser(this.m_lastFolderURL);
        string.clearChooseableURLFilters();
        string.setSelectionScope(1);
        string.setSelectionMode(0);
        string.setShowJarsAsDirs(false);
        int n = string.showOpenDialog((Component)Ide.getMainWindow(), RestArb.getString("WIZ_SELECT_CONFIG_DIR"));
        if (n == 0) {
            this.m_lastFolderURL = string.getSelectedFile();
            return true;
        }
        return false;
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateValues();
            try {
                String string;
                File file;
                Map map = (Map)traversableContext.get("ORDS_PARAMS");
                if (this.m_SQLDevORDSWarFile.isSelected()) {
                    file = new File(this.m_sqldev_ords_path);
                    string = this.m_sqldev_warVersion;
                    map.put("use.sqldev.configdir", Boolean.TRUE);
                } else {
                    file = new File(this.m_fileName.getText());
                    string = this.m_warProductVersion;
                    map.put("use.sqldev.configdir", Boolean.FALSE);
                }
                File file2 = new File(this.m_configLoc.getText());
                this.m_installID = (Integer)map.get("INSTALL_ID");
                if (this.m_prevConfigPath == null || !this.m_prevConfigPath.getCanonicalPath().equals(file2.getCanonicalPath())) {
                    this.m_installType = InstallUtils.getInstallType(file2);
                    map.put("config.status", this.m_installType);
                    map.put("config.dir", file2);
                }
                if (this.m_prevWarFile == null || !this.m_prevWarFile.getCanonicalPath().equals(file.getCanonicalPath())) {
                    map.put("ords.warfile", file);
                    map.put("product.version", string);
                    map.put("config.dir.update", Boolean.TRUE);
                    Map<String, String> map2 = InstallUtils.getInstallParamsFromFile(file);
                    map2.put("config.status", this.m_installType.toString());
                    map.put("INSTALL_KEY_PARAMS", map2);
                }
                map.put("config.dir.created", this.createdConfigFolders);
                this.m_prevWarFile = file;
                this.m_prevConfigPath = file2;
            }
            catch (Exception exception) {
                throw new TraversalException(exception.getLocalizedMessage());
            }
        }
    }

    public Object getExitTransition() {
        if (this.m_installID == RestInstallController.RUN_STANDALONE_CMD_ID) {
            return "Transition.Standalone";
        }
        return "Transition.DBConn";
    }
}

