/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.patterns;

import java.util.Set;
import oracle.dbtools.common.immutables.ImmutableSet;
import oracle.dbtools.common.immutables.Immutables;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.rest.patterns.NamedPattern;
import oracle.dbtools.rest.patterns.PathToken;
import oracle.dbtools.rest.patterns.PathTokenPattern;

class NamedPatternImpl
extends PathTokenPattern
implements NamedPattern {
    private final Set<String> parameters;

    private NamedPatternImpl(Iterable<PathToken> iterable) {
        super(iterable);
        ImmutableSet.Builder builder = Immutables.sets().builder();
        for (PathToken pathToken : iterable) {
            if (!pathToken.type().equals((Object)PathToken.Type.PARAMETER)) continue;
            builder.add((Object)pathToken.name());
        }
        this.parameters = builder.build();
    }

    @Override
    public Set<String> parameters() {
        return this.parameters;
    }

    static class Builder
    extends PathTokenPattern.Builder
    implements NamedPattern.Builder {
        Builder() {
        }

        @Override
        public Builder addCompoundParameter(NamedPattern.Operator operator, CharSequence ... charSequenceArray) throws IllegalArgumentException {
            return this.addCompoundParameter(operator, Iterables.iterable((Object[])charSequenceArray));
        }

        @Override
        public Builder addCompoundParameter(NamedPattern.Operator operator, Iterable<? extends CharSequence> iterable) throws IllegalArgumentException {
            super.add(PathToken.compoundParameter(Iterables.asStrings(iterable), operator));
            return this;
        }

        @Override
        public Builder addFile(CharSequence charSequence) throws IllegalArgumentException {
            super.addFile(charSequence);
            return this;
        }

        @Override
        public Builder addFolder(CharSequence charSequence) throws IllegalArgumentException {
            super.addFolder(charSequence);
            return this;
        }

        @Override
        public Builder addParameter(CharSequence charSequence) throws IllegalArgumentException {
            return this.addParameter(charSequence, null);
        }

        @Override
        public Builder addParameter(CharSequence charSequence, NamedPattern.Operator operator) throws IllegalArgumentException {
            super.add(PathToken.parameter(charSequence.toString(), operator));
            return this;
        }

        @Override
        public NamedPattern build() {
            return new NamedPatternImpl(this.tokens());
        }

        @Override
        protected void validate(PathToken.Type type, PathToken pathToken) {
        }
    }
}

