/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.util.ResourceUtils;

public class RestRenamePanel
extends JPanel {
    private JTextField _oldNameTF;
    private JTextField _newNameTF;
    private List<String> _existingNames;
    private List<String> _errMsg;
    private String _nlsKeyRestType;
    private String _oldName;
    private String _newName;

    public RestRenamePanel(String string, String string2, List<String> list) {
        this._nlsKeyRestType = string;
        this._oldName = string2;
        this._existingNames = list;
        this.createPanel();
    }

    private void initializeComponents() {
        this._oldNameTF = new JTextField();
        this._newNameTF = new JTextField();
        if (this._oldName != null) {
            this._oldNameTF.setText(this._oldName);
            this._oldNameTF.setEnabled(false);
        }
        this._newNameTF.requestFocusInWindow();
    }

    private void createPanel() {
        this.initializeComponents();
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        String string = RestArb.format("RENAME_OLD_NAME", RestArb.getString(this._nlsKeyRestType));
        JLabel jLabel2 = new JLabel();
        String string2 = RestArb.getString("RENAME_NEW_NAME");
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._oldNameTF, (String)string);
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._newNameTF, (String)string2);
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._oldNameTF, new GridBagConstraints(1, n, 1, 1, 1.0, 0.5, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._newNameTF, new GridBagConstraints(1, n, 1, 1, 1.0, 0.5, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        n = 0;
        this.add((Component)jPanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.1, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addListeners();
    }

    public void addListeners() {
    }

    public void removeListeners() {
    }

    public boolean validInfo() {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        } else {
            this._errMsg.clear();
        }
        String string = this._oldNameTF.getText();
        String string2 = this._newNameTF.getText();
        if (RestUtils.emptyValue(string2)) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString(this._nlsKeyRestType)));
        } else if (string2.equals(string)) {
            this.setErrorMessage(RestArb.format("NEW_NAME_SAME_OLD_NAME", RestArb.getString(this._nlsKeyRestType)));
        } else if (this.isExistName(string2)) {
            this.setErrorMessage(RestArb.format("VALUE_ALREADY_EXIST", RestArb.getString(this._nlsKeyRestType)));
        }
        if (this._errMsg.size() > 0) {
            this._newNameTF.requestFocusInWindow();
        }
        return this._errMsg.size() == 0;
    }

    public String getValues() {
        return this._newNameTF.getText();
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this._errMsg) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private void setErrorMessage(String string) {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        }
        this._errMsg.add(string);
    }

    public void setExistingNames(List<String> list) {
        this._existingNames = list;
    }

    public boolean isExistName(String string) {
        if (this._existingNames == null || this._existingNames.isEmpty()) {
            return false;
        }
        return this._existingNames.contains(string);
    }

    public String getNewName() {
        return this._newNameTF.getText();
    }
}

