/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.plugin.api.json.objects.JSONArray;
import oracle.dbtools.plugin.api.json.objects.JSONObject;
import oracle.dbtools.raptor.utils.JSONUtils;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.utils.RestUtils;

public class RestJSONUtil {
    private static final String INDENT = "  ";
    private static final String REPLACE_BACKWARDSLASH = "\\\"";
    private StringBuilder _buf;

    public static String restPrivilegestoJSON(List<RestPrivilege> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return new RestJSONUtil().privilegestoJSON(list);
    }

    public static String restPrivilegetoJSON(RestPrivilege restPrivilege) {
        if (restPrivilege == null) {
            return null;
        }
        return new RestJSONUtil().privilegetoJSON(restPrivilege);
    }

    public static List<RestPrivilege> getPrivileges(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        return new RestJSONUtil().createPrivileges(jSONObject);
    }

    public static RestPrivilege getPrivilege(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        return new RestJSONUtil().getPrivilegeDetails(jSONObject);
    }

    private String privilegestoJSON(List<RestPrivilege> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"items\":[\n");
        for (int i = 0; i < list.size(); ++i) {
            RestPrivilege restPrivilege = list.get(i);
            String string = RestJSONUtil.restPrivilegetoJSON(restPrivilege);
            if (string == null) continue;
            stringBuilder.append(RestJSONUtil.restPrivilegetoJSON(restPrivilege));
            if (i < list.size() - 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    private String privilegetoJSON(RestPrivilege restPrivilege) {
        String string;
        Object object;
        Object object2;
        Object object3;
        this._buf = new StringBuilder(INDENT);
        this._buf.append("{");
        this._buf.append("\"name\":").append("\"").append(restPrivilege.getName()).append("\"");
        if (!RestUtils.emptyValue(restPrivilege.getTitle())) {
            object3 = restPrivilege.getTitle();
            object3 = ((String)object3).replace("\"", REPLACE_BACKWARDSLASH);
            this._buf.append(",");
            this._buf.append("\"title\":").append("\"").append((String)object3).append("\"");
        }
        if (!RestUtils.emptyValue(restPrivilege.getDescription())) {
            object3 = restPrivilege.getDescription();
            this._buf.append(",");
            object3 = ((String)object3).replace("\"", REPLACE_BACKWARDSLASH);
            this._buf.append("\"description\":").append("\"").append((String)object3).append("\"");
        }
        if ((object3 = restPrivilege.getRoles()) != null && !object3.isEmpty() && !RestUtils.emptyValue((String)(object2 = this.formatCommaDelimitedDoubleQuotedList(restPrivilege.getRoles())))) {
            this._buf.append(",");
            this._buf.append("\"roles\":");
            this._buf.append("[").append((String)object2).append("]");
        }
        if ((object2 = restPrivilege.getModules()) != null && !object2.isEmpty() && !RestUtils.emptyValue((String)(object = this.formatCommaDelimitedDoubleQuotedList(restPrivilege.getModules())))) {
            this._buf.append(",");
            this._buf.append("\"modules\":");
            this._buf.append("[").append((String)object).append("]");
        }
        if ((object = restPrivilege.getURIPatterns()) != null && !object.isEmpty() && !RestUtils.emptyValue(string = this.formatCommaDelimitedDoubleQuotedList(restPrivilege.getURIPatterns()))) {
            this._buf.append(",");
            this._buf.append("\"patterns\":");
            this._buf.append("[").append(string).append("]");
        }
        this._buf.append("}");
        return this._buf.toString();
    }

    private String formatCommaDelimitedDoubleQuotedList(List<String> list) {
        String string = "";
        if (list != null && !list.isEmpty()) {
            String string2 = null;
            for (int i = 0; i < list.size(); ++i) {
                string2 = list.get(i);
                if (RestUtils.emptyValue(string2)) continue;
                string2 = "\"" + string2 + "\"";
                string = string + string2;
                if (i >= list.size() - 1) continue;
                string = string + ",";
            }
        }
        return string;
    }

    public List<RestPrivilege> createPrivileges(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ArrayList<RestPrivilege> arrayList = new ArrayList<RestPrivilege>();
        JSONArray jSONArray = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"items");
        for (Object t : jSONArray.values()) {
            JSONObject jSONObject2 = (JSONObject)t;
            arrayList.add(this.getPrivilegeDetails(jSONObject2));
        }
        return arrayList;
    }

    private RestPrivilege getPrivilegeDetails(JSONObject jSONObject) {
        Object object;
        Object object2;
        JSONArray jSONArray;
        if (jSONObject == null) {
            return null;
        }
        RestPrivilege restPrivilege = new RestPrivilege();
        restPrivilege.setName((String)JSONUtils.getValue((JSONObject)jSONObject, (String)"name"));
        restPrivilege.setTitle((String)JSONUtils.getValue((JSONObject)jSONObject, (String)"title"));
        restPrivilege.setDescription((String)JSONUtils.getValue((JSONObject)jSONObject, (String)"description"));
        JSONArray jSONArray2 = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"modules");
        if (jSONArray2 != null) {
            jSONArray = new ArrayList();
            object2 = jSONArray2.values().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                jSONArray.add((String)object);
            }
            restPrivilege.setModules((List)jSONArray);
        }
        if ((jSONArray = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"roles")) != null) {
            object2 = new ArrayList();
            for (Object object3 : jSONArray.values()) {
                object2.add((String)object3);
            }
            restPrivilege.setRoles((List)object2);
        }
        if ((object2 = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"patterns")) != null) {
            object = new ArrayList();
            for (Object e : object2.values()) {
                object.add((String)e);
            }
            restPrivilege.setURIPatterns((List)object);
        }
        return restPrivilege;
    }
}

