/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dbtools.autorest.ui.JEditorPaneScrollPaneWrapper;
import oracle.dbtools.rest.RestArb;
import oracle.javatools.icons.OracleIcons;

public abstract class RestBaseSummaryTabPanel
extends JPanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JTabbedPane summaryTabbedPane = new JTabbedPane();
    private JScrollPane summaryScrollPane = new JScrollPane();
    private JTree summaryTree = new JTree();
    private JEditorPaneScrollPaneWrapper sqlEditorPane = null;

    public RestBaseSummaryTabPanel(JEditorPaneScrollPaneWrapper jEditorPaneScrollPaneWrapper) {
        this.sqlEditorPane = jEditorPaneScrollPaneWrapper;
        this.setUpTabs();
    }

    private void setUpTabs() {
        this.setLayout(this.borderLayout1);
        this.setName("RestSchemaSummaryPanel");
        this.summaryTabbedPane.setName("summaryTabbedPane");
        this.summaryScrollPane.setName("summaryScrollPane");
        this.summaryTree.setName("summaryTree");
        this.sqlEditorPane.setName("sqlEditorPane");
        this.summaryTree.setCellRenderer(new NodeRenderer());
        this.summaryScrollPane.getViewport().add(this.summaryTree);
        this.summaryTabbedPane.addTab(RestArb.getString("WIZ_TAB_SUMMARY"), this.summaryScrollPane);
        this.summaryTabbedPane.addTab(RestArb.getString("WIZ_TAB_SQL"), this.sqlEditorPane);
        this.add((Component)this.summaryTabbedPane, "Center");
    }

    public void setSqlEditorCode(String string) {
        if (!this.sqlEditorPane.isEditable()) {
            this.sqlEditorPane.setEditable(true);
            this.sqlEditorPane.setText(string);
            this.sqlEditorPane.setEditable(false);
        } else {
            this.sqlEditorPane.setText(string);
        }
    }

    public void setSummaryTree(JTree jTree) {
        this.summaryTree = jTree;
    }

    public JTree getSummaryTree() {
        if (this.summaryTree == null) {
            this.summaryTree = new JTree();
        }
        return this.summaryTree;
    }

    public JLabel getLabel(String string, boolean bl) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        if (bl) {
            jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
        } else {
            jLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        }
        return jLabel;
    }

    public JLabel getLabel(String string) {
        JLabel jLabel = new JLabel();
        String string2 = string != null ? string : "";
        jLabel.setText(string2);
        return jLabel;
    }

    public String format(String string, String string2) {
        return string + " " + string2;
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                jLabel.setText((String)object2);
                if (bl3) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
                return jLabel;
            }
            return (Component)object2;
        }
    }
}

