/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.merge;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.algorithm.directory.DirectoryList;
import oracle.jdeveloper.merge.MergeContext;
import oracle.jdeveloper.merge.MergeEngine;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.merge.ListMergeEditor;
import oracle.jdevimpl.vcs.svn.merge.SVNDirectoryCompareContributor;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNDirectoryMergeEditor
extends ListMergeEditor {
    private CompareModel _buffer;

    protected void initializeMergeContextCS(Context context) throws Exception {
        URL url = this.getRealURL();
        try {
            File wcRoot = SVNUtil.toFile(SVNUtil.resolveWorkingCopy(url));
            ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.CACHE_ADAPTER_CONTEXT_ID);
            SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.getFirstAssociatedRepository(url));
            SVNDirectoryCompareContributor leftcontributor = new SVNDirectoryCompareContributor();
            DirectoryList dirList = new DirectoryList();
            URL wcURL = wcRoot.toURI().toURL();
            Collection<URL> leftUrls = this.getFileAndFolders(wcURL, new SVNURLFilter());
            for (URL urlN : leftUrls) {
                String path = URLFileSystem.toRelativeSpec((URL)urlN, (URL)wcURL);
                if (path.lastIndexOf(47) == path.length() - 1) {
                    path = path.substring(0, path.length() - 1);
                }
                dirList.appendFile(new DirectoryFile(URLFileSystem.isDirectoryPath((URL)urlN), path, path));
            }
            leftcontributor.setPrestinDirectoryList(dirList);
            leftcontributor.setDirectoryList(dirList);
            leftcontributor.setShortLabel(wcRoot.getName() + Resource.get("SVN_DIRECTORY_MERGE_LOCAL"));
            leftcontributor.setLongLabel(wcRoot.toString() + Resource.get("SVN_DIRECTORY_MERGE_LOCAL"));
            SVNDirectoryCompareContributor rightcontributor = new SVNDirectoryCompareContributor(false);
            ISVNDirEntry[] rightEntries = client.getList(wcRoot, SVNRevision.WORKING, true);
            dirList = new DirectoryList();
            for (ISVNDirEntry entry : rightEntries) {
                dirList.appendFile(new DirectoryFile(entry.getNodeKind().equals((Object)SVNNodeKind.DIR), entry.getPath(), entry.getPath()));
            }
            rightcontributor.setPrestinDirectoryList(dirList);
            rightcontributor.setDirectoryList(dirList);
            rightcontributor.setShortLabel(wcRoot.getName() + Resource.get("SVN_DIRECTORY_MERGE_REMOTE"));
            rightcontributor.setLongLabel(wcRoot.toString() + Resource.get("SVN_DIRECTORY_MERGE_REMOTE"));
            SVNDirectoryCompareContributor ancestorcontributor = leftcontributor;
            SVNClientInteraction.getInstance().endInteraction();
            MergeContext.setFirstContributor((Context)context, (CompareContributor)leftcontributor);
            MergeContext.setSecondContributor((Context)context, (CompareContributor)rightcontributor);
            MergeContext.setAncestorContributor((Context)context, (CompareContributor)ancestorcontributor);
            MergeContext.setMergeEngine((Context)context, (MergeEngine)MergeEngine.getInstance());
        }
        catch (SVNClientException ex) {
            ex.printStackTrace();
        }
    }

    protected void initializeMergeModel(CompareModel compareModel) {
        this._buffer = compareModel;
    }

    protected CompareModel getSaveResultForNode() {
        return this._buffer;
    }

    protected boolean isSaveEnabled() {
        return true;
    }

    public String getTabLabel() {
        return Resource.get("TREE_MERGE_TAB_LABEL");
    }

    private Collection<URL> getFileAndFolders(URL url, URLFilter filter) {
        URL[] urls;
        ArrayList<URL> children = new ArrayList<URL>();
        for (URL u : urls = URLFileSystem.list((URL)url, (URLFilter)filter)) {
            children.add(u);
            if (!URLFileSystem.isDirectoryPath((URL)u)) continue;
            children.addAll(this.getFileAndFolders(u, filter));
        }
        return children;
    }

    private static class SVNURLFilter
    implements URLFilter {
        private VCSProfile _profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");

        public boolean accept(URL url) {
            if (!GlobalIgnoreList.isGloballyIgnored((URL)url)) {
                VCSStatus status;
                try {
                    status = (VCSStatus)this._profile.getPolicyStatusCache().get(url);
                }
                catch (Exception e) {
                    return false;
                }
                return status.isVersioned();
            }
            return false;
        }
    }
}

