/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSRegistry;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.vop.VersionOperationSelectTablePanel;
import oracle.jdevimpl.vcs.svn.SVNExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNException;

public abstract class AbstractSVNOperation
extends ActionCommand {
    public static final String OPTION_RECURSIVE = "oracle.jdeveloper.subversion.RECURSIVE";
    public static final String OPTION_REVISION = "oracle.jdeveloper.subversion.REVISION";
    public static final String OPTION_IGNORE_EXTERNALS = "oracle.jdeveloper.subversion.IGNORE_EXTERNALS";
    public static final String OPTION_KEEP_LOCKS = "oracle.jdeveloper.subversion.KEEP_LOCKS";
    public static final String OPTION_STEAL_LOCKS = "oracle.jdeveloper.subversion.STEAL_LOCKS";
    public static final String OPTION_FORCE_UNLOCK = "oracle.jdeveloper.subversion.FORCE_LOCKS";
    public static final String OPTION_DEPTH = "oracle.jdeveloper.subversion.DEPTH";
    public static final String OPTION_FORCE_UPDATE = "oracle.jdeveloper.subversion.FORCE_UPDATE";
    public static final String LIST_REVISION_URL = "oracle.jdeveloper.subversion.LIST_REVISION_URL";
    public static final String OPTION_BUGTRAQ_NO = "oracle.jdeveloper.subversion.bugtraq";
    public static final int DEFAULT_OPTION_DEPTH = 3;
    public static Object CLIENT_CONTEXT = new Object();
    protected static final String PROPERTY_RESOURCES_CREATED = AbstractSVNOperation.class.getName() + ".resourcesCreated";
    protected static final String PROPERTY_RESOURCES_DELETED = AbstractSVNOperation.class.getName() + ".resourcesDeleted";
    protected static final String PROPERTY_RESOURCES_STRUCTURE_CHANGED = AbstractSVNOperation.class.getName() + ".resourcesStructChanged";
    private static URLFilter _localFilter = VCSContextUtils.createLocalProtocolFilter();
    protected VersionOperationSelectTablePanel _svnSelectionTablePanel;
    protected SVNExceptionHandler _svnExceptionHandler;
    protected CommandState _commandState;

    protected AbstractSVNOperation(String commandId) {
        super(commandId);
    }

    protected static URLFilter getLocalFilter() {
        return _localFilter;
    }

    protected boolean isAvailableImpl() throws Exception {
        if (!super.isAvailableImpl()) {
            return false;
        }
        if (this.requiresModifiedRegularFile()) {
            Locatable[] locatables;
            for (Locatable locatable : locatables = this.getContextLocatables()) {
                URL url = VCSModelUtils.getLocatableURL((Object)locatable);
                if (url == null) continue;
                if (URLFileSystem.isDirectoryPath((URL)url)) {
                    return true;
                }
                VCSStatus status = this.getProfile().getStatus(new URL[]{url})[0];
                if (status == this.getProfile().getStatusInstance("UNMODIFIED")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean requiresModifiedRegularFile() {
        return false;
    }

    protected boolean invokeCommand(final VCSProfile profile, final CommandState commandState) throws Exception {
        if (!this.prepareStateForUI(commandState)) {
            return false;
        }
        List<Locatable> nodes = Arrays.asList(commandState.getLocatables());
        VCSOptionsCustomizer customizer = this.createOptionsCustomizer(nodes);
        final JEWTDialog dialog = this.createOperationDialog(nodes, customizer, commandState);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){
            VCSExceptionHandler _handler;

            protected boolean doCommitOperation(Map options) throws Exception {
                VersionOperationSelectTablePanel panel = AbstractSVNOperation.this.getSVNVersionOperationPanel();
                Locatable[] locatables = panel.getSelectedLocatables();
                commandState.setLocatables(locatables);
                boolean result = true;
                try {
                    result = AbstractSVNOperation.this.invokeCommandImpl(profile, commandState, (Component)dialog, options);
                }
                catch (Exception ex) {
                    throw SVNExceptionWrapper.wrapException(ex, AbstractSVNOperation.this.getContext());
                }
                return result;
            }

            protected VCSExceptionHandler getExceptionHandler() {
                if (this._handler == null) {
                    this._handler = new SVNExceptionHandler();
                }
                return this._handler;
            }
        });
        return VCSDialogRunner.runDialog((JDialog)dialog);
    }

    protected boolean prepareStateForUI(CommandState commandState) {
        return true;
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        this.setSVNVersionOperationPanel(VCSComponents.createSelectFileListerComponent((Collection)nodes));
        JEWTDialog dialog = this.createOperationDialogImpl(nodes, customizer, commandState);
        DialogHeader header = this.createOperationDialogHeader(nodes, commandState);
        if (header != null) {
            dialog.setDialogHeader((Component)header);
        }
        return dialog;
    }

    protected DialogHeader createOperationDialogHeader(Collection nodes, CommandState commandState) {
        String urlStr = this.getOperationDialogHeaderURLString(nodes, commandState);
        if (urlStr == null || urlStr.isEmpty()) {
            return null;
        }
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("ACTION_ABSTRACT_MULTISELECTION_REPO_TARGET") + "\n" + urlStr);
        header.setToolTipText(urlStr);
        return header;
    }

    protected String getOperationDialogHeaderURLString(Collection nodes, CommandState commandState) {
        String urlStr = "";
        Locatable[] locs = (Locatable[])nodes.toArray();
        if (locs.length > 0) {
            try {
                SVNUrl svnurl;
                if (locs.length == 1) {
                    svnurl = SVNURLInfoCache.getInstance().getURL(locs[0].getURL());
                } else {
                    URL parent = this.getCommonParent(locs);
                    svnurl = SVNURLInfoCache.getInstance().getURL(parent);
                }
                if (svnurl == null) {
                    return null;
                }
                urlStr = svnurl.toString();
            }
            catch (SVNException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        } else {
            return null;
        }
        return urlStr;
    }

    protected JEWTDialog createOperationDialogImpl(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)this.getSVNVersionOperationPanel(), (Component)(customizer != null ? customizer.getComponent() : null), (String)this.getHelpTopicId(), (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
    }

    protected final VersionOperationSelectTablePanel getSVNVersionOperationPanel() {
        return this._svnSelectionTablePanel;
    }

    protected final void setSVNVersionOperationPanel(VersionOperationSelectTablePanel votp) {
        this._svnSelectionTablePanel = votp;
    }

    protected String getDialogTitle() {
        String title = this.getActionInfo().getDialogTitle();
        if (title == null || title.equals("")) {
            title = Resource.get("ACTION_ABSTRACT_MULTISELECTION_DIALOG_TITLE");
        }
        return title;
    }

    protected String getDialogHint() {
        String msg = this.getActionInfo().getDialogHint();
        if (msg == null || msg.equals("")) {
            msg = Resource.get("ACTION_ABSTRACT_MULTISELECTION_DIALOG_MESSAGE");
        }
        return msg;
    }

    protected void postInvoke(VCSProfile profile, final CommandState commandState) throws Exception {
        URL[] eventUrls;
        Collection processed = this.getProcessedUrlsNotifier(commandState);
        URL[] urls = processed.toArray(new URL[processed.size()]);
        boolean recursive = false;
        Boolean b = (Boolean)commandState.getProperty(OPTION_RECURSIVE);
        recursive = b != null ? b : false;
        profile.getPolicyStatusCache().clear(urls);
        if (processed.size() > 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VCSBufferUtils.reloadBuffers((Map)commandState.getTimestampMap());
                }
            });
        }
        SVNURLInfoCache.getInstance().clear(urls);
        if (recursive) {
            ArrayList<URL> directories = new ArrayList<URL>(urls.length);
            for (int i = 0; i < urls.length; ++i) {
                if (!URLFileSystem.isDirectoryPath((URL)urls[i])) continue;
                directories.add(urls[i]);
            }
            profile.getPolicyStatusCache().clear(directories.toArray(new URL[directories.size()]), Depth.INFINITY);
        }
        if ((eventUrls = (URL[])commandState.getProperty(PROPERTY_RESOURCES_CREATED)) != null && eventUrls.length > 0) {
            this.fireSomeFilesCreated(eventUrls);
        }
        if ((eventUrls = (URL[])commandState.getProperty(PROPERTY_RESOURCES_DELETED)) != null && eventUrls.length > 0) {
            this.fireDeletionEvents(eventUrls);
        }
        if ((eventUrls = (URL[])commandState.getProperty(PROPERTY_RESOURCES_STRUCTURE_CHANGED)) != null && eventUrls.length > 0) {
            this.fireFileStructureChanged(eventUrls);
        }
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
    }

    protected void collapseSelectionToWorkingCopy(CommandState state) {
        Locatable workingCopyRoot = null;
        Locatable[] selection = state.getLocatables();
        for (int i = 0; i < selection.length && workingCopyRoot == null; ++i) {
            URL url = SVNUtil.resolveWorkingCopy(selection[i].getURL());
            workingCopyRoot = url != null ? VCSModelUtils.findOrCreateNodes((URL[])new URL[]{url})[0] : null;
        }
        state.setLocatables(new Locatable[]{workingCopyRoot});
    }

    private void fireDeletionEvents(URL[] deleted) {
        ArrayList<URL> files = new ArrayList<URL>(deleted.length * 2);
        ArrayList<URL> dirs = new ArrayList<URL>(deleted.length * 2);
        for (int i = 0; i < deleted.length; ++i) {
            if (URLFileSystem.isDirectoryPath((URL)deleted[i])) {
                dirs.add(deleted[i]);
                continue;
            }
            files.add(deleted[i]);
        }
        this.fireSomeFilesDeleted(files.toArray(new URL[files.size()]));
        Iterator it = dirs.iterator();
        while (it.hasNext()) {
            Node[] nodes = VCSModelUtils.findCachedNodes((URLFilter)VCSURLFilters.createBaseURLContentsFilter((URL[])new URL[]{(URL)it.next()}));
            this.fireSomeFilesDeleted(VCSModelUtils.convertNodesToURLs((Locatable[])nodes));
        }
    }

    protected Collection getProcessedUrlsNotifier(CommandState commandState) {
        ArrayList c = (ArrayList)commandState.getProperty("svn.processed.urls");
        if (c == null) {
            c = new ArrayList(30);
            commandState.setProperty("svn.processed.urls", c);
        }
        return c;
    }

    protected VCSExceptionHandler getExceptionHandler() {
        return this.getExtension().getExceptionHandler();
    }

    protected int doitImpl() throws Exception {
        try {
            return super.doitImpl();
        }
        catch (Exception ex) {
            throw SVNExceptionWrapper.wrapException(ex);
        }
    }

    protected CommandState getCommandState() {
        if (this._commandState == null) {
            throw new IllegalStateException("Command status is null");
        }
        return this._commandState;
    }

    protected CommandState createCommandState() {
        this._commandState = super.createCommandState();
        return this._commandState;
    }

    protected VCSExtension getExtension() {
        VCS vcs = VCSRegistry.lookup((String)"oracle.jdeveloper.subversion");
        return (VCSExtension)vcs;
    }

    protected URL getCommonParent(URL[] urls) {
        if (urls.length == 1) {
            if (URLFileSystem.equals((URL)SVNUtil.resolveWorkingCopy(urls[0]), (URL)urls[0])) {
                return urls[0];
            }
            return URLFileSystem.getParent((URL)urls[0]);
        }
        URL common = URLFileSystem.getParent((URL)urls[0]);
        boolean search = true;
        while (search) {
            if (this.isCommonParent(common, urls)) {
                search = false;
                continue;
            }
            if ((common = URLFileSystem.getParent((URL)common)) != null) continue;
            return null;
        }
        return common;
    }

    protected URL getCommonParent(Locatable[] locatables) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Locatable locatable : locatables) {
            urls.add(locatable.getURL());
        }
        return this.getCommonParent(urls.toArray(new URL[0]));
    }

    private boolean isCommonParent(URL parent, URL[] urls) {
        for (URL url : urls) {
            if (URLFileSystem.isBaseURLFor((URL)parent, (URL)url)) continue;
            return false;
        }
        return true;
    }
}

