/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectHierarchy;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.gui.AScratchWorksheet;
import oracle.dbtools.migration.gui.SEMessages;
import oracle.dbtools.migration.gui.SQLObjDoubleWorksheetGUI;
import oracle.dbtools.migration.gui.SQLObjSourceWorksheet;
import oracle.dbtools.migration.gui.SQLObjTargetWorksheet;
import oracle.dbtools.migration.gui.SourceWorksheet;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryStateListener;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.editor.Editor;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;

public final class CaptureConvertObjEditors
extends Editor {
    private static CaptureConvertObjEditors m_capconvEditors = null;
    private SQLObjDoubleWorksheetGUI m_gui = null;
    private Context m_context = null;
    private DBObject m_dbo = null;
    private boolean m_splitExpanded = false;
    private ConnectionDisconnectListener m_connDisconnListener = new ConnectionDisconnectListener(){

        public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
            String string = connectionDetails.getQualifiedConnectionName();
            if (MigrationAddin.isRepositoryOpen() && MigrationAddin.getRepositoryConnectionName().equals(string) && !CaptureConvertObjEditors.this.checkSave()) {
                CaptureConvertObjEditors.this.m_checkDisconnect = false;
                throw new DisconnectVetoException(connectionDetails, null);
            }
            CaptureConvertObjEditors.this.m_checkDisconnect = true;
        }

        public void connectionDisconnected(ConnectionDetails connectionDetails) {
        }
    };
    private ShutdownHook m_shutdownHook = null;
    private boolean m_checkDisconnect = false;

    public static synchronized CaptureConvertObjEditors getInstance() {
        if (m_capconvEditors == null) {
            m_capconvEditors = new CaptureConvertObjEditors();
        }
        return m_capconvEditors;
    }

    private CaptureConvertObjEditors() {
        Connections.getInstance().addConnectionDisconnectListener(this.m_connDisconnListener);
        this.m_shutdownHook = new ShutdownHook(){

            public boolean canShutdown() {
                return CaptureConvertObjEditors.this.checkSave();
            }

            public void shutdown() {
            }
        };
        ExitCommand.addShutdownHook((ShutdownHook)this.m_shutdownHook);
        MigrationAddin.addMigrationRepositoryStateListener((MigrationRepositoryStateListener)new MigrationRepositoryStateListener(){

            public void repositoryOpened(String string) {
            }

            public void repositoryClosed() {
                CaptureConvertObjEditors.this.m_checkDisconnect = true;
                CaptureConvertObjEditors.this.close();
            }
        });
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.m_context = context;
    }

    public void open() {
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public Component getGUI() {
        return this.getDoubleWorksheetGUI();
    }

    private SQLObjDoubleWorksheetGUI getDoubleWorksheetGUI() {
        if (this.m_gui == null) {
            this.m_gui = new SQLObjDoubleWorksheetGUI();
        }
        if (this.m_context != null) {
            DBObject dBObject = null;
            ViewerNode viewerNode = null;
            Node node = this.m_context.getNode();
            if (node instanceof ViewerNode) {
                viewerNode = (ViewerNode)node;
                dBObject = viewerNode.getDBObject();
            }
            if (this.m_dbo == null) {
                this.m_dbo = dBObject;
            } else if (this.m_dbo != dBObject) {
                if (!this.checkSave()) {
                    return this.m_gui;
                }
                this.m_dbo = dBObject;
            } else {
                return this.m_gui;
            }
            try {
                Object object;
                DBObject dBObject2 = dBObject;
                PersistableObject persistableObject = null;
                PersistableObject persistableObject2 = null;
                DBObjectHierarchy dBObjectHierarchy = null;
                PersistenceUtility persistenceUtility = PersistenceUtility.getInstance((PersistenceManager)MigrationAddin.getPersistenceManager());
                PersistableObject persistableObject3 = persistenceUtility.loadPersistableObject(MigrationURLFormatHelper.getObjectId((URL)dBObject2.getURL()), MigrationUtils.mapSDToSDMWType((String)dBObject2.getObjectType()));
                DBObjectHierarchy dBObjectHierarchy2 = new DBObjectHierarchy(persistableObject3, MigrationAddin.getPersistenceManager());
                if ("CONVERTED".equals(dBObjectHierarchy2.getConnection().getType())) {
                    persistableObject = persistableObject3;
                    if (persistableObject != null) {
                        DBObjectHierarchy dBObjectHierarchy3 = new DBObjectHierarchy(persistableObject, MigrationAddin.getPersistenceManager());
                        persistableObject2 = ConvertUtils.findPersistableOrigional((PersistenceManager)MigrationAddin.getPersistenceManager(), (PersistableObject)persistableObject, (DBObjectId)dBObjectHierarchy3.getConnection().getKey());
                        if (persistableObject2 != null) {
                            dBObjectHierarchy = new DBObjectHierarchy(persistableObject2, MigrationAddin.getPersistenceManager());
                        }
                    }
                } else {
                    persistableObject2 = persistableObject3;
                    if (persistableObject2 != null) {
                        dBObjectHierarchy = new DBObjectHierarchy(persistableObject2, MigrationAddin.getPersistenceManager());
                        persistableObject = this.getConvertedPO(MigrationAddin.getPersistenceManager(), persistableObject2.getKey(), MigrationUtils.mapSDToSDMWType((String)dBObject2.getObjectType()));
                        DBObjectHierarchy dBObjectHierarchy4 = new DBObjectHierarchy(persistableObject, MigrationAddin.getPersistenceManager());
                    }
                }
                String string = null;
                String string2 = null;
                if (dBObjectHierarchy != null) {
                    object = this.getTranslationDBObject(dBObjectHierarchy);
                    string = object.getDdl();
                }
                if (persistableObject != null) {
                    object = ConvertUtils.getClobHelper((PersistableObject)persistableObject);
                    string2 = ConvertUtils.getClobAsString((ClobHelper)object);
                }
                object = this.m_gui.getSourceWS();
                SQLObjTargetWorksheet sQLObjTargetWorksheet = this.m_gui.getTargetWS();
                if (string == null) {
                    ((AScratchWorksheet)((Object)object)).setPersistedObject(null);
                    ((AScratchWorksheet)((Object)object)).setSQL("");
                    ((SourceWorksheet)((Object)object)).createWorksheetContext().getEditor().setText("");
                    sQLObjTargetWorksheet.setComboConnection(dBObject.getConnectionName());
                    sQLObjTargetWorksheet.setPersistedObject(persistableObject);
                    sQLObjTargetWorksheet.setSQL(string2);
                    sQLObjTargetWorksheet.createWorksheetContext().getEditor().setText(string2);
                    sQLObjTargetWorksheet.updateVisibleActions();
                    this.m_gui.setInitialPaint(true);
                    this.m_splitExpanded = true;
                    JRootPane jRootPane = (JRootPane)this.m_gui.getTopComponent();
                    jRootPane.getGlassPane().setVisible(true);
                } else if (persistableObject == null) {
                    Object object2;
                    JRootPane jRootPane = (JRootPane)this.m_gui.getTopComponent();
                    jRootPane.getGlassPane().setVisible(false);
                    object.setComboConnection(dBObject.getConnectionName());
                    ((SourceWorksheet)((Object)object)).setComboCapturedProject(dBObjectHierarchy.getConnection().getProjectId().getId(), dBObjectHierarchy.getSchema().getKey().getId());
                    ((AScratchWorksheet)((Object)object)).setPersistedObject(persistableObject2);
                    ((AScratchWorksheet)((Object)object)).setSQL(string);
                    ((SourceWorksheet)((Object)object)).createWorksheetContext().getEditor().setText(string);
                    String string3 = dBObjectHierarchy.getConnection().getDburl();
                    Matcher matcher = Pattern.compile("(jdbc:)(\\w+\\:)?(\\w+)(\\:)?(\\//)?.*").matcher(string3);
                    if (matcher != null && matcher.find()) {
                        object2 = matcher.group(3);
                        ((SourceWorksheet)((Object)object)).setTranslator((String)object2);
                    }
                    object.updateVisibleActions();
                    object2 = (JRootPane)this.m_gui.getBottomComponent();
                    ((JRootPane)object2).getGlassPane().setVisible(true);
                    if (this.m_splitExpanded) {
                        this.m_gui.setInitialPaint(true);
                        this.m_splitExpanded = false;
                    }
                } else {
                    Object object3;
                    JRootPane jRootPane = (JRootPane)this.m_gui.getTopComponent();
                    jRootPane.getGlassPane().setVisible(false);
                    object.setComboConnection(dBObject.getConnectionName());
                    ((SourceWorksheet)((Object)object)).setComboCapturedProject(dBObjectHierarchy.getConnection().getProjectId().getId(), dBObjectHierarchy.getSchema().getKey().getId());
                    ((AScratchWorksheet)((Object)object)).setPersistedObject(persistableObject2);
                    ((AScratchWorksheet)((Object)object)).setSQL(string);
                    ((SourceWorksheet)((Object)object)).createWorksheetContext().getEditor().setText(string);
                    String string4 = dBObjectHierarchy.getConnection().getDburl();
                    Matcher matcher = Pattern.compile("(jdbc:)(\\w+\\:)?(\\w+)(\\:)?(\\//)?.*").matcher(string4);
                    if (matcher != null && matcher.find()) {
                        object3 = matcher.group(3);
                        ((SourceWorksheet)((Object)object)).setTranslator((String)object3);
                    }
                    object3 = (JRootPane)this.m_gui.getBottomComponent();
                    ((JRootPane)object3).getGlassPane().setVisible(false);
                    object.updateVisibleActions();
                    sQLObjTargetWorksheet.setComboConnection(dBObject.getConnectionName());
                    sQLObjTargetWorksheet.setPersistedObject(persistableObject);
                    sQLObjTargetWorksheet.setSQL(string2);
                    sQLObjTargetWorksheet.createWorksheetContext().getEditor().setText(string2);
                    sQLObjTargetWorksheet.updateVisibleActions();
                    if (this.m_splitExpanded) {
                        this.m_gui.setInitialPaint(true);
                        this.m_splitExpanded = false;
                    }
                }
                sQLObjTargetWorksheet.setViewerNode(viewerNode);
            }
            catch (Exception exception) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
            }
        }
        return this.m_gui;
    }

    private TranslationDBObject getTranslationDBObject(DBObjectHierarchy dBObjectHierarchy) {
        TranslationDBObject translationDBObject = null;
        try {
            translationDBObject = ConvertUtils.asDBObject((String)dBObjectHierarchy.getConnection().getHost(), (String)dBObjectHierarchy.getCatalog().getCatalogName(), (String)dBObjectHierarchy.getSchema().getName(), (PersistableObject)(dBObjectHierarchy.getPart() == null ? dBObjectHierarchy.getObject() : dBObjectHierarchy.getPart()));
        }
        catch (IOException iOException) {
            MigrationLogUtil.logThrowable((String)iOException.getLocalizedMessage(), (String)SEMessages.getString("CompareInitiator.4"), (Throwable)iOException);
        }
        return translationDBObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistableObject getConvertedPO(PersistenceManager persistenceManager, DBObjectId dBObjectId, String string) throws SQLException, PersistenceException, NoSuchObjectException {
        PersistableObject persistableObject = null;
        String string2 = "SELECT DERIVED_ID, DERIVED_TYPE FROM MD_DERIVATIVES WHERE SRC_ID = ? AND SRC_TYPE = ? AND SRC_ID <> DERIVED_ID AND DERIVATIVE_REASON IS NULL";
        try (CloseableResultSet closeableResultSet = null;){
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(string2);
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            PersistenceUtility persistenceUtility = PersistenceUtility.getInstance((PersistenceManager)persistenceManager);
            if (resultSet.next()) {
                DBObjectId dBObjectId2 = new DBObjectId(resultSet.getLong(1));
                String string3 = resultSet.getString(2);
                persistableObject = persistenceUtility.loadPersistableObject(dBObjectId2, string3);
            }
        }
        return persistableObject;
    }

    public Object getEditorAttribute(String string) {
        if ("horizontal_scrollbar_policy".equals(string)) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string)) {
            return new Integer(21);
        }
        if ("scrollable".equals(string)) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    public synchronized void close() {
        try {
            if (!this.m_checkDisconnect) {
                this.checkSave(false);
            }
            if (this.getContext().getNode() != null && this.getContext().getNode().isOpen()) {
                if (this.m_gui != null && this.isReady()) {
                    this.m_gui.removeAll();
                    if (this.m_gui.getSourceWS() != null && this.m_gui.getSourceWS().isVisible()) {
                        this.m_gui.getSourceWS().close();
                    }
                    if (this.m_gui.getTargetWS() != null && this.m_gui.getTargetWS().isVisible()) {
                        this.m_gui.getTargetWS().close();
                    }
                }
                this.getContext().getNode().close();
            }
        }
        catch (IOException iOException) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)iOException);
        }
        finally {
            this.m_gui = null;
            Connections.getInstance().removeConnectionDisconnectListener(this.m_connDisconnListener);
            ExitCommand.removeShutdownHook((ShutdownHook)this.m_shutdownHook);
            this.m_connDisconnListener = null;
            this.m_shutdownHook = null;
            this.m_checkDisconnect = false;
        }
        super.close();
    }

    private boolean checkSave() {
        return this.checkSave(true);
    }

    private boolean checkSave(boolean bl) {
        SQLObjSourceWorksheet sQLObjSourceWorksheet = this.m_gui.getSourceWS();
        SQLObjTargetWorksheet sQLObjTargetWorksheet = this.m_gui.getTargetWS();
        if (!sQLObjSourceWorksheet.isSavedSQL() || !sQLObjTargetWorksheet.isSavedSQL()) {
            int n = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), SEMessages.getString("SaveChanges"), this.m_dbo.getObjectName(), bl ? 1 : 0, 2, null, null, null);
            if (n == 0) {
                if (sQLObjSourceWorksheet.getPersistedObject() != null && !sQLObjSourceWorksheet.isSavedSQL()) {
                    sQLObjSourceWorksheet.updateSQLObj(sQLObjSourceWorksheet.getFocusedEditorPane().getText());
                }
                if (sQLObjTargetWorksheet.getPersistedObject() != null && !sQLObjTargetWorksheet.isSavedSQL()) {
                    sQLObjTargetWorksheet.updateSQLObj(sQLObjTargetWorksheet.getFocusedEditorPane().getText());
                }
            } else if (n == 2) {
                return false;
            }
        }
        return true;
    }
}

