/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.bookmarks;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.Bookmarks;
import oracle.ide.bookmarks.URLBookmark;
import oracle.ide.net.URLFileSystem;

public abstract class LineBookmark
extends URLBookmark {
    private int line;

    public LineBookmark(URL url, int line) {
        super(url);
        this.setLine(line);
        this.setDescription(Bookmarks.format("BOOKMARK_DESCRIPTION_FORMAT_LINE", URLFileSystem.getFileName((URL)url), line));
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("URL: " + this.getURL().toString());
        buffer.append("\n");
        buffer.append("line: " + this.line);
        buffer.append("\n");
        buffer.append("desc: " + this.getDescription());
        buffer.append("\n");
        return buffer.toString();
    }

    public boolean matches(URL url, int line) {
        return this.matches(url) && this.getLine() == line;
    }

    public boolean matches(URL url) {
        return this.getURL().equals(url);
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public abstract void gotoBookmark();

    @Override
    public int compareTo(Bookmark o) {
        if (o instanceof URLBookmark) {
            int ret = super.compareTo(o);
            if (ret == 0) {
                if (o instanceof LineBookmark) {
                    LineBookmark that = (LineBookmark)o;
                    if (this.getLine() == that.getLine()) {
                        return 0;
                    }
                    if (this.getLine() > that.getLine()) {
                        return 1;
                    }
                    return -1;
                }
            } else {
                return ret;
            }
        }
        return 0;
    }

    @Override
    public Bookmark.SortOrder compareTo(Context context) {
        Bookmark.SortOrder order = super.compareTo(context);
        if (order == Bookmark.SortOrder.EQUAL) {
            int contextLine = this.getLineFromContext(context);
            if (contextLine < 0) {
                return Bookmark.SortOrder.UNKNOWN;
            }
            if (this.line == contextLine) {
                return Bookmark.SortOrder.EQUAL;
            }
            if (this.line < contextLine) {
                return Bookmark.SortOrder.BEFORE;
            }
            return Bookmark.SortOrder.AFTER;
        }
        return order;
    }

    public abstract int getLineFromContext(Context var1);
}

