/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.raptor.utils.WindowsUtility;

public class JDBCHelper {
    public static final String ENV_OH = "ORACLE_HOME";
    private static final String JDBCJAR8 = "ojdbc8.jar";
    private static final String JDBCJAR7 = "ojdbc7.jar";
    private static final String JDBCJAR6 = "ojdbc6.jar";
    private static Logger logger = Logger.getLogger("oracle.dbtools.plusplus");

    public static boolean isOHSet() {
        String oh = JDBCHelper.getOH();
        return oh != null;
    }

    public static boolean isOHReal() {
        File dir;
        String oh = JDBCHelper.getOH();
        return oh != null && (dir = new File(oh)).exists();
    }

    public static String getOH() {
        boolean isWindows = PlatformUtils.isWindows();
        String oh = System.getenv().get(ENV_OH);
        if (oh == null && isWindows) {
            try {
                String key = "SOFTWARE\\ORACLE";
                List<String> oracle_keys = WindowsUtility.readStringSubKeys(-2147483646, key);
                String homeKey = null;
                if (oracle_keys != null) {
                    for (String oracle_key : oracle_keys) {
                        String temp = key + "\\" + oracle_key;
                        homeKey = WindowsUtility.readString(-2147483646, temp, "ORACLE_HOME_KEY");
                        if (homeKey == null) continue;
                        oh = WindowsUtility.readString(-2147483646, homeKey, ENV_OH);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return oh;
    }

    public static boolean doesOHJDBCExist() {
        if (!JDBCHelper.isOHReal()) {
            return false;
        }
        File jar = new File(JDBCHelper.getOHJDBCLib() + File.separator + JDBCJAR8);
        if (jar != null && jar.exists()) {
            return true;
        }
        jar = new File(JDBCHelper.getOHJDBCLib() + File.separator + JDBCJAR7);
        if (jar != null && jar.exists()) {
            return true;
        }
        jar = new File(JDBCHelper.getOHJDBCLib() + File.separator + JDBCJAR6);
        return jar != null && jar.exists();
    }

    public static String getOHJDBCLib() {
        if (JDBCHelper.isOHReal()) {
            String lib = JDBCHelper.getOH() + File.separator + "jdbc" + File.separator + "lib";
            File f = new File(lib);
            if (f.exists()) {
                return lib;
            }
            return JDBCHelper.getOH();
        }
        return null;
    }

    public static boolean doesOHJDBCLibExist() {
        File jdbclib = new File(JDBCHelper.getOHJDBCLib());
        return jdbclib.exists();
    }
}

