/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.clone;

import java.io.PrintStream;
import java.util.Iterator;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.Buffer;
import org.fusesource.jansi.Ansi;

public class ConsoleBufferPainter {
    private static Buffer _buffer;

    public static void main(String[] args) {
        Buffer buffer = new Buffer();
        buffer.add("select");
        buffer.add("1 from");
        buffer.add("from dual");
        buffer.setCurrentLine(2);
        ConsoleBufferPainter.setBuffer(buffer);
        ConsoleBufferPainter.printBuffer(System.out);
    }

    public static void setBuffer(Buffer buffer) {
        _buffer = buffer;
    }

    public static void printBuffer(PrintStream out) {
        Ansi cursorposition = Ansi.ansi().saveCursorPosition();
        Iterator<String> it = _buffer.getBufferList().iterator();
        while (it.hasNext()) {
            out.append(Ansi.ansi().a(it.next()).toString() + "\n");
            out.flush();
        }
        out.append(Ansi.ansi().restorCursorPosition().toString());
        out.flush();
    }

    public static int getTerminalWidth() {
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", "tput cols 2> /dev/tty"});
                byte[] buf = new byte[200];
                p.getInputStream().read(buf);
                String val = new String(buf).trim();
                return Integer.parseInt(val);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return -1;
    }

    public static int getTerminalHeight() {
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", "tput lines 2> /dev/tty"});
                byte[] buf = new byte[200];
                p.getInputStream().read(buf);
                String val = new String(buf).trim();
                return Integer.parseInt(val);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return -1;
    }
}

